/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.modules.texture.tooltextures.definitions;

import info.ata4.bspsrc.decompiler.modules.texture.tooltextures.ToolTextureDefinition;
import info.ata4.bspsrc.lib.struct.BrushFlag;
import info.ata4.bspsrc.lib.struct.SurfaceFlag;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public enum SourceToolTextureDefinition implements ToolTextureDefinition
{
    AREAPORTAL("tools/toolsareaportal", new ToolTextureDefinition.Builder().setRequiredFlags(BrushFlag.CONTENTS_AREAPORTAL).setRequiredFlags(SurfaceFlag.SURF_NOLIGHT).build()),
    BLOCK_BULLETS("tools/toolsblockbullets", new ToolTextureDefinition.Builder().setRequiredFlags(BrushFlag.CONTENTS_WINDOW, BrushFlag.CONTENTS_TRANSLUCENT).setRequiredFlags(SurfaceFlag.SURF_TRANS, SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    BLOCK_LIGHT("tools/toolsblocklight", new ToolTextureDefinition.Builder().setRequiredFlags(BrushFlag.CONTENTS_OPAQUE, BrushFlag.CONTENTS_DETAIL).setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    BLOCK_LOS("tools/toolsblock_los", new ToolTextureDefinition.Builder().setRequiredFlags(BrushFlag.CONTENTS_BLOCKLOS, BrushFlag.CONTENTS_DETAIL).setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    INVISIBLE("tools/toolsinvisible", new ToolTextureDefinition.Builder().setRequiredFlags(BrushFlag.CONTENTS_GRATE, BrushFlag.CONTENTS_TRANSLUCENT).setForbiddenFlags(BrushFlag.CONTENTS_SOLID).setRequiredFlags(SurfaceFlag.SURF_TRANS, SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    INVISIBLE_LADDER("tools/toolsinvisibleladder", new ToolTextureDefinition.Builder().setRequiredFlags(BrushFlag.CONTENTS_GRATE, BrushFlag.CONTENTS_TRANSLUCENT, BrushFlag.CONTENTS_LADDER).setForbiddenFlags(BrushFlag.CONTENTS_SOLID).setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    NODRAW("tools/toolsnodraw", new ToolTextureDefinition.Builder().setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    TRIGGER("tools/toolstrigger", new ToolTextureDefinition.Builder().setRequiredFlags(SurfaceFlag.SURF_NOLIGHT, SurfaceFlag.SURF_TRIGGER).build()),
    HINT("tools/toolshint", new ToolTextureDefinition.Builder().setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_HINT, SurfaceFlag.SURF_NOLIGHT).build()),
    SKIP("tools/toolsskip", new ToolTextureDefinition.Builder().setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_SKIP, SurfaceFlag.SURF_NOLIGHT).build()),
    CLIP("tools/toolsclip", new ToolTextureDefinition.Builder("default_silent").setRequiredFlags(BrushFlag.CONTENTS_PLAYERCLIP, BrushFlag.CONTENTS_MONSTERCLIP, BrushFlag.CONTENTS_DETAIL).setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    NPC_CLIP("tools/toolsnpcclip", new ToolTextureDefinition.Builder("default_silent").setRequiredFlags(BrushFlag.CONTENTS_MONSTERCLIP, BrushFlag.CONTENTS_DETAIL).setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    PLAYER_CLIP("tools/toolsplayerclip", new ToolTextureDefinition.Builder().setRequiredFlags(BrushFlag.CONTENTS_PLAYERCLIP, BrushFlag.CONTENTS_DETAIL).setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    SKYBOX("tools/toolsskybox", new ToolTextureDefinition.Builder("default_silent").setRequiredFlags(BrushFlag.CONTENTS_SOLID).setRequiredFlags(SurfaceFlag.SURF_SKY, SurfaceFlag.SURF_NOLIGHT).build()),
    SKYBOX_2D("tools/toolsskybox2d", new ToolTextureDefinition.Builder("default_silent").setRequiredFlags(BrushFlag.CONTENTS_SOLID).setRequiredFlags(SurfaceFlag.SURF_SKY, SurfaceFlag.SURF_SKY2D, SurfaceFlag.SURF_NOLIGHT).build());

    private final String materialName;
    private final ToolTextureDefinition toolTextureDefinition;

    private SourceToolTextureDefinition(String materialName, ToolTextureDefinition toolTextureDefinition) {
        this.materialName = Objects.requireNonNull(materialName);
        this.toolTextureDefinition = Objects.requireNonNull(toolTextureDefinition);
    }

    public String getMaterialName() {
        return this.materialName;
    }

    @Override
    public Optional<String> getSurfaceProperty() {
        return this.toolTextureDefinition.getSurfaceProperty();
    }

    @Override
    public Map<BrushFlag, Boolean> getBrushFlagsRequirements() {
        return this.toolTextureDefinition.getBrushFlagsRequirements();
    }

    @Override
    public Map<SurfaceFlag, Boolean> getSurfaceFlagsRequirements() {
        return this.toolTextureDefinition.getSurfaceFlagsRequirements();
    }

    public static Map<String, ToolTextureDefinition> getAll() {
        return Arrays.stream(SourceToolTextureDefinition.values()).collect(Collectors.toMap(SourceToolTextureDefinition::getMaterialName, definition -> definition));
    }
}

