/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.modules.texture.tooltextures.definitions;

import info.ata4.bspsrc.decompiler.modules.texture.tooltextures.ToolTextureDefinition;
import info.ata4.bspsrc.decompiler.modules.texture.tooltextures.definitions.SourceToolTextureDefinition;
import info.ata4.bspsrc.lib.struct.BrushFlag;
import info.ata4.bspsrc.lib.struct.SurfaceFlag;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public enum CssToolTextureDefinition implements ToolTextureDefinition
{
    CLIP("tools/toolsclip", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).clearSurfaceFlagRequirements().build()),
    NPC_CLIP("tools/toolsnpcclip", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.NPC_CLIP).clearSurfaceFlagRequirements().build()),
    PLAYER_CLIP("tools/toolsplayerclip", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.PLAYER_CLIP).clearSurfaceFlagRequirements().build());

    private final String materialName;
    private final ToolTextureDefinition toolTextureDefinition;

    private CssToolTextureDefinition(String materialName, ToolTextureDefinition toolTextureDefinition) {
        this.materialName = Objects.requireNonNull(materialName);
        this.toolTextureDefinition = Objects.requireNonNull(toolTextureDefinition);
    }

    public String getMaterialName() {
        return this.materialName;
    }

    @Override
    public Optional<String> getSurfaceProperty() {
        return this.toolTextureDefinition.getSurfaceProperty();
    }

    @Override
    public Map<BrushFlag, Boolean> getBrushFlagsRequirements() {
        return this.toolTextureDefinition.getBrushFlagsRequirements();
    }

    @Override
    public Map<SurfaceFlag, Boolean> getSurfaceFlagsRequirements() {
        return this.toolTextureDefinition.getSurfaceFlagsRequirements();
    }

    public static Map<String, ToolTextureDefinition> getAll() {
        return Arrays.stream(CssToolTextureDefinition.values()).collect(Collectors.toMap(CssToolTextureDefinition::getMaterialName, definition -> definition));
    }
}

