/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.modules.texture;

import info.ata4.bspsrc.common.util.StringUtil;
import info.ata4.bspsrc.decompiler.modules.texture.tooltextures.ToolTextureDefinition;
import info.ata4.bspsrc.lib.struct.BrushFlag;
import info.ata4.bspsrc.lib.struct.SurfaceFlag;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ToolTextureMatcher {
    private final Map<String, ToolTextureDefinition> toolTextureDefinitions;

    public ToolTextureMatcher(Map<String, ToolTextureDefinition> toolTextureDefinitions) {
        this.toolTextureDefinitions = Collections.unmodifiableMap(new HashMap<String, ToolTextureDefinition>(toolTextureDefinitions));
    }

    public Optional<String> fixToolTexture(String originalTextureName, Set<SurfaceFlag> surfFlags, Set<BrushFlag> brushFlags) {
        Optional<Optional> optOriginalSurfaceProperty = Optional.ofNullable(this.toolTextureDefinitions.get(originalTextureName)).map(ToolTextureDefinition::getSurfaceProperty);
        return this.toolTextureDefinitions.entrySet().stream().filter(ttEntry -> optOriginalSurfaceProperty.map(surfaceProperty -> StringUtil.equalsIgnoreCase(surfaceProperty.orElse(null), ((ToolTextureDefinition)ttEntry.getValue()).getSurfaceProperty().orElse(null))).orElse(true)).filter(ttEntry -> ((ToolTextureDefinition)ttEntry.getValue()).getBrushFlagsRequirements().entrySet().stream().allMatch(entry -> brushFlags.contains(entry.getKey()) == ((Boolean)entry.getValue()).booleanValue())).filter(ttEntry -> ((ToolTextureDefinition)ttEntry.getValue()).getSurfaceFlagsRequirements().entrySet().stream().allMatch(entry -> surfFlags.contains(entry.getKey()) == ((Boolean)entry.getValue()).booleanValue())).max(Comparator.comparingInt(ttEntry -> {
            ToolTextureDefinition definition = (ToolTextureDefinition)ttEntry.getValue();
            int brushFlagRequirements = definition.getBrushFlagsRequirements().size();
            int surfaceFlagRequirements = definition.getSurfaceFlagsRequirements().size();
            return brushFlagRequirements + surfaceFlagRequirements;
        })).map(Map.Entry::getKey);
    }
}

