/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.modules.texture;

import info.ata4.bspsrc.decompiler.modules.ModuleRead;
import info.ata4.bspsrc.decompiler.modules.texture.TextureBuilder;
import info.ata4.bspsrc.decompiler.modules.texture.ToolTextureMatcher;
import info.ata4.bspsrc.decompiler.modules.texture.tooltextures.ToolTextureSet;
import info.ata4.bspsrc.lib.BspFileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureSource
extends ModuleRead {
    private static final Logger L = LogManager.getLogger();
    private static final String CONTENT_GROUP = "content";
    private static final String CUBEMAP_X_GROUP = "x";
    private static final String CUBEMAP_Y_GROUP = "y";
    private static final String CUBEMAP_Z_GROUP = "z";
    private static final String MAP_NAME_PATTERN = "[^/]*";
    public static final Pattern originPattern = Pattern.compile(String.format("maps/%s/(?<%s>.+)_(?<%s>-?\\d+)_(?<%s>-?\\d+)_(?<%s>-?\\d+)", "[^/]*", "content", "x", "y", "z"));
    public static final Pattern wvtPatchPattern = Pattern.compile(String.format("maps/%s/(?<%s>.+)_wvt_patch", "[^/]*", "content"));
    public static final Pattern waterPatchPattern = Pattern.compile(String.format("maps/%s/(?<%s>.+)_depth_-?\\d+", "[^/]*", "content"));
    private Map<Integer, Set<Integer>> cubemapToSideList = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Integer> texnameToCubemap = new HashMap<Integer, Integer>();
    private List<String> texnamesFixed = new ArrayList<String>();
    private boolean fixTextureNames;
    private boolean fixToolTextures;
    private ToolTextureMatcher toolTextureMatcher = new ToolTextureMatcher(ToolTextureSet.forGame(this.bspFile.getAppId()));

    public TextureSource(BspFileReader reader) {
        super(reader);
        reader.loadTexInfo();
        reader.loadTexData();
        reader.loadCubemaps();
        this.processTextureNames();
    }

    private void processTextureNames() {
        for (int i = 0; i < this.bsp.texnames.size(); ++i) {
            String textureOld = this.bsp.texnames.get(i);
            String textureNew = TextureSource.canonizeTextureName(textureOld);
            Matcher matcher = wvtPatchPattern.matcher(textureNew);
            if (matcher.find()) {
                textureNew = this.removeMatchedPrefixSuffix(matcher);
            }
            if ((matcher = waterPatchPattern.matcher(textureNew)).find()) {
                textureNew = this.removeMatchedPrefixSuffix(matcher);
            }
            if ((matcher = originPattern.matcher(textureNew)).find()) {
                try {
                    int cx = Integer.valueOf(matcher.group(CUBEMAP_X_GROUP));
                    int cy = Integer.valueOf(matcher.group(CUBEMAP_Y_GROUP));
                    int cz = Integer.valueOf(matcher.group(CUBEMAP_Z_GROUP));
                    this.setCubemapForTexname(i, cx, cy, cz);
                }
                catch (NumberFormatException e) {
                    L.warn("Error parsing cubemap position from regex. Matcher: " + matcher.pattern().pattern() + ", input: " + textureNew, (Throwable)e);
                }
                textureNew = this.removeMatchedPrefixSuffix(matcher);
            }
            if (!textureNew.equalsIgnoreCase(textureOld)) {
                L.trace("{} -> {}", (Object)textureOld, (Object)textureNew);
            }
            this.texnamesFixed.add(textureNew);
        }
    }

    private String removeMatchedPrefixSuffix(Matcher matcher) {
        return matcher.replaceFirst("${content}");
    }

    private void setCubemapForTexname(int itexname, int cx, int cy, int cz) {
        for (int i = 0; i < this.bsp.cubemaps.size(); ++i) {
            int[] origin = this.bsp.cubemaps.get((int)i).origin;
            if (cx != origin[0] && cy != origin[1] && cz != origin[2]) continue;
            if (L.isTraceEnabled()) {
                L.trace("TN: {} C: {}", (Object)itexname, (Object)i);
            }
            this.texnameToCubemap.put(itexname, i);
            return;
        }
        L.trace("Couldn't find cubemap for coordinates ({}, {}, {})", (Object)cx, (Object)cy, (Object)cz);
    }

    public TextureBuilder getTextureBuilder() {
        return new TextureBuilder(this, this.bsp, this.toolTextureMatcher);
    }

    public void addBrushSideID(int itexname, int side) {
        Integer icubemap = this.texnameToCubemap.get(itexname);
        if (icubemap == null) {
            return;
        }
        Set<Integer> sides = this.cubemapToSideList.get(icubemap);
        if (sides == null) {
            sides = new HashSet<Integer>();
            this.cubemapToSideList.put(icubemap, sides);
        }
        sides.add(side);
    }

    public Set<Integer> getBrushSidesForCubemap(int icubemap) {
        return this.cubemapToSideList.get(icubemap);
    }

    public String getTextureName(short itexinfo) {
        try {
            int ti = this.bsp.texinfos.get((int)itexinfo).texdata;
            int td = this.bsp.texdatas.get((int)ti).texname;
            if (this.fixTextureNames) {
                return this.texnamesFixed.get(td);
            }
            return this.bsp.texnames.get(td);
        }
        catch (IndexOutOfBoundsException ex) {
            return "tools/toolsskip";
        }
    }

    public static String canonizeTextureName(String textureNew) {
        textureNew = textureNew.toLowerCase(Locale.ROOT);
        textureNew = textureNew.replace('\\', '/');
        return textureNew;
    }

    public List<String> getFixedTextureNames() {
        return Collections.unmodifiableList(this.texnamesFixed);
    }

    public boolean isFixTextureNames() {
        return this.fixTextureNames;
    }

    public void setFixTextureNames(boolean fixTextureNames) {
        this.fixTextureNames = fixTextureNames;
    }

    public boolean isFixToolTextures() {
        return this.fixToolTextures;
    }

    public void setFixToolTextures(boolean fixToolTextures) {
        this.fixToolTextures = fixToolTextures;
    }

    public static boolean isPatchedMaterial(String fileName) {
        String canonizedName = TextureSource.canonizeTextureName(fileName);
        return originPattern.matcher(canonizedName).find() || wvtPatchPattern.matcher(canonizedName).find() || waterPatchPattern.matcher(canonizedName).find();
    }
}

