/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.modules.geom;

import info.ata4.bspsrc.decompiler.BspSourceConfig;
import info.ata4.bspsrc.decompiler.VmfWriter;
import info.ata4.bspsrc.decompiler.modules.BspDecompiler;
import info.ata4.bspsrc.decompiler.modules.BspProtection;
import info.ata4.bspsrc.decompiler.modules.ModuleDecompile;
import info.ata4.bspsrc.decompiler.modules.VmfMeta;
import info.ata4.bspsrc.decompiler.modules.geom.BrushSideFaceMapper;
import info.ata4.bspsrc.decompiler.modules.texture.Texture;
import info.ata4.bspsrc.decompiler.modules.texture.TextureBuilder;
import info.ata4.bspsrc.decompiler.modules.texture.TextureSource;
import info.ata4.bspsrc.decompiler.util.BspTreeStats;
import info.ata4.bspsrc.decompiler.util.Winding;
import info.ata4.bspsrc.decompiler.util.WindingFactory;
import info.ata4.bspsrc.lib.BspFileReader;
import info.ata4.bspsrc.lib.struct.DBrush;
import info.ata4.bspsrc.lib.struct.DBrushSide;
import info.ata4.bspsrc.lib.struct.DModel;
import info.ata4.bspsrc.lib.vector.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrushSource
extends ModuleDecompile {
    private static final Logger L = LogManager.getLogger();
    private final WindingFactory windingFactory;
    private final BspSourceConfig config;
    private final TextureSource texsrc;
    private final BspProtection bspprot;
    private final VmfMeta vmfmeta;
    private final BrushSideFaceMapper brushSideFaceMapper;
    private List<DBrushModel> models = new ArrayList<DBrushModel>();
    private int worldbrushes = 0;
    private Map<Integer, Integer> brushSideToID = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> brushIndexToID = new HashMap<Integer, Integer>();

    public BrushSource(BspFileReader reader, VmfWriter writer, BspSourceConfig config, TextureSource texsrc, BspProtection bspprot, VmfMeta vmfmeta, BrushSideFaceMapper brushSideFaceMapper, WindingFactory windingFactory) {
        super(reader, writer);
        this.config = Objects.requireNonNull(config);
        this.texsrc = Objects.requireNonNull(texsrc);
        this.bspprot = Objects.requireNonNull(bspprot);
        this.vmfmeta = Objects.requireNonNull(vmfmeta);
        this.brushSideFaceMapper = Objects.requireNonNull(brushSideFaceMapper);
        this.windingFactory = Objects.requireNonNull(windingFactory);
        this.assignBrushes();
    }

    public boolean isFuncDetail(DBrush dBrush) {
        boolean potentialNonObjectBrushLadderDetail = BspDecompiler.usesNonObjectBrushLadders(this.bspFile.getAppId()) && dBrush.isLadder();
        return (potentialNonObjectBrushLadderDetail || dBrush.isSolid() || dBrush.isTranslucent()) && dBrush.isDetail();
    }

    public int getBrushSideIDForIndex(int ibrushside) {
        if (this.brushSideToID.containsKey(ibrushside)) {
            return this.brushSideToID.get(ibrushside);
        }
        return -1;
    }

    public int getBrushIDForIndex(int ibrush) {
        if (this.brushIndexToID.containsKey(ibrush)) {
            return this.brushIndexToID.get(ibrush);
        }
        return -1;
    }

    private void assignBrushes() {
        BspTreeStats tl = new BspTreeStats(this.bsp);
        tl.walk(0);
        L.debug("Walked worldspawn tree");
        this.worldbrushes = tl.getMaxBrushLeaf() + 1;
        for (DModel dModel : this.bsp.models) {
            tl.reset();
            tl.walk(dModel.headnode);
            DBrushModel bmodel = new DBrushModel(this);
            bmodel.fstbrush = tl.getMinBrushLeaf();
            bmodel.numbrush = tl.getMaxBrushLeaf() - tl.getMinBrushLeaf() + 1;
            this.models.add(bmodel);
        }
        L.debug("Largest worldbrush: {}", (Object)this.worldbrushes);
    }

    public void writeBrushes() {
        L.info("Writing brushes and planes");
        for (int i = 0; i < this.worldbrushes; ++i) {
            DBrush brush = this.bsp.brushes.get(i);
            if (this.config.writeDetails && this.isFuncDetail(brush) || this.config.writeAreaportals && brush.isAreaportal() || this.config.writeLadders && brush.isLadder() && !BspDecompiler.usesNonObjectBrushLadders(this.bspFile.getAppId())) continue;
            this.writeBrush(i);
        }
    }

    public boolean writeBrush(int ibrush, Vector3f origin, Vector3f angles) {
        Winding wind;
        DBrush brush = this.bsp.brushes.get(ibrush);
        int brushID = this.vmfmeta.getUID();
        this.brushIndexToID.put(ibrush, brushID);
        HashMap<Integer, Winding> validBrushSides = new HashMap<Integer, Winding>();
        for (int i = 0; i < brush.numside; ++i) {
            int ibrushside = brush.fstside + i;
            DBrushSide brushSide = this.bsp.brushSides.get(ibrushside);
            if (brushSide.bevel) continue;
            try {
                wind = this.windingFactory.fromSide(this.bsp, brush, brushSide).removeDegenerated();
                if (wind.isEmpty()) {
                    throw new BrushSideException("no vertices");
                }
                if (wind.size() < 3) {
                    throw new BrushSideException("less than 3 vertices");
                }
                if (wind.isHuge()) {
                    throw new BrushSideException("too big");
                }
                Vector3f[] plane = wind.buildPlane();
                Vector3f e1 = plane[0];
                Vector3f e2 = plane[1];
                Vector3f e3 = plane[2];
                if (!(e1.isValid() && e2.isValid() && e3.isValid())) {
                    throw new BrushSideException("invalid plane");
                }
                for (int p1 = 0; p1 < plane.length; ++p1) {
                    for (int p2 = 0; p2 < plane.length; ++p2) {
                        Vector3f v2;
                        Vector3f v1;
                        if (p1 == p2 || !(v1 = plane[p1]).equals(v2 = plane[p2])) continue;
                        throw new BrushSideException("duplicate plane point " + String.valueOf(v1));
                    }
                }
                if (angles != null) {
                    wind = wind.rotate(angles);
                }
                if (origin != null) {
                    wind = wind.translate(origin);
                }
                validBrushSides.put(ibrushside, wind);
                continue;
            }
            catch (BrushSideException ex) {
                if (!this.config.debug) continue;
                L.warn("Skipped side {} of brush {}: {}", (Object)i, (Object)ibrush, (Object)ex.getMessage());
            }
        }
        if (validBrushSides.isEmpty()) {
            L.warn("Skipped empty brush {}", (Object)ibrush);
            return false;
        }
        if (validBrushSides.size() < 3) {
            L.warn("Skipped brush {} with less than 3 sides", (Object)ibrush);
            return false;
        }
        this.writer.start("solid");
        this.writer.put("id", brushID);
        if (this.config.debug) {
            this.writer.start("bspsrc_debug");
            this.writer.put("brush_index", ibrush);
            this.writer.put("brush_contents", brush.contents.toString());
            this.writer.end("bspsrc_debug");
        }
        for (Map.Entry entry : validBrushSides.entrySet()) {
            int ibrushside = (Integer)entry.getKey();
            wind = (Winding)entry.getValue();
            this.writeSide(ibrushside, ibrush, wind, origin, angles);
        }
        if (!brush.isDetail() && this.bspprot.isProtectedBrush(brush)) {
            this.vmfmeta.writeMetaVisgroup("VMEX protector brushes");
        }
        this.writer.end("solid");
        return true;
    }

    public boolean writeBrush(int ibrush) {
        return this.writeBrush(ibrush, null, null);
    }

    private boolean writeSide(int ibrushside, int ibrush, Winding wind, Vector3f origin, Vector3f angles) {
        DBrushSide brushSide = this.bsp.brushSides.get(ibrushside);
        Vector3f[] plane = wind.buildPlane();
        Vector3f e1 = plane[0];
        Vector3f e2 = plane[1];
        Vector3f e3 = plane[2];
        Vector3f ev12 = e2.sub(e1);
        Vector3f ev13 = e3.sub(e1);
        Vector3f normal = ev12.cross(ev13).normalize();
        TextureBuilder tb = this.texsrc.getTextureBuilder();
        tb.setOrigin(origin);
        tb.setAngles(angles);
        tb.setNormal(normal);
        tb.setTexinfoIndex(brushSide.texinfo);
        tb.setBrushIndex(ibrush);
        tb.setBrushSideIndex(ibrushside);
        boolean potentialCompactedTexinf = !this.brushSideFaceMapper.getOrigFaceIndex(ibrushside).isPresent();
        tb.setEnableTextureFixing(potentialCompactedTexinf);
        Texture texture = tb.build();
        if (!this.config.faceTexture.isEmpty()) {
            texture.setOverrideTexture(this.config.faceTexture);
        }
        int sideID = this.vmfmeta.getUID();
        if (texture.getData() != null) {
            this.texsrc.addBrushSideID(texture.getData().texname, sideID);
        }
        this.brushSideToID.put(ibrushside, sideID);
        int smoothingGroups = this.brushSideFaceMapper.getOrigFaceIndex(ibrushside).map(this.bsp.origFaces::get).map(dFace -> dFace.smoothingGroups).orElse(0);
        this.writer.start("side");
        this.writer.put("id", sideID);
        if (this.config.debug) {
            this.writer.start("bspsrc_debug");
            this.writer.put("brushside_index", ibrushside);
            this.writer.put("normal", normal);
            this.writer.put("winding", wind.toString());
            if (texture.getOverrideTexture() != null) {
                this.writer.put("original_material", texture.getOriginalTexture());
            }
            if (brushSide.texinfo != -1) {
                this.writer.put("texinfo_index", brushSide.texinfo);
                this.writer.put("texinfo_flags", this.bsp.texinfos.get((int)brushSide.texinfo).flags.toString());
                float[][] tvec = this.bsp.texinfos.get((int)brushSide.texinfo).textureVecsTexels;
                this.writer.put("texturevecs_u", Arrays.toString(tvec[0]));
                this.writer.put("texturevecs_v", Arrays.toString(tvec[1]));
                Vector3f uaxis = new Vector3f(tvec[0]);
                Vector3f vaxis = new Vector3f(tvec[1]);
                Vector3f texNorm = uaxis.cross(vaxis);
                double angle = Math.toDegrees(Math.acos(normal.dot(texNorm) / texNorm.length()));
                this.writer.put("input_uv_normal", texNorm);
                this.writer.put("input_uv_angle", Double.isNaN(angle) ? 0.0 : angle);
                texNorm = texture.getUAxis().axis.cross(texture.getVAxis().axis);
                angle = Math.toDegrees(Math.acos(normal.dot(texNorm)));
                this.writer.put("output_uv_normal", texNorm);
                this.writer.put("output_uv_angle", Double.isNaN(angle) ? 0.0 : angle);
            }
            this.writer.end("bspsrc_debug");
        }
        this.writer.put("plane", e1, e2, e3);
        this.writer.put("smoothing_groups", smoothingGroups);
        this.writer.put(texture);
        this.writer.end("side");
        return true;
    }

    public boolean writeModel(int imodel, Vector3f origin, Vector3f angles) {
        DBrushModel bmodel;
        try {
            bmodel = this.models.get(imodel);
        }
        catch (IndexOutOfBoundsException ex) {
            L.warn("Invalid model index {}", (Object)imodel);
            return false;
        }
        for (int i = 0; i < bmodel.numbrush; ++i) {
            this.writeBrush(bmodel.fstbrush + i, origin, angles);
        }
        return true;
    }

    public boolean writeModel(int imodel) {
        return this.writeModel(imodel);
    }

    public int getWorldbrushes() {
        return this.worldbrushes;
    }

    private class DBrushModel {
        private int fstbrush;
        private int numbrush;

        private DBrushModel(BrushSource brushSource) {
        }
    }

    private class BrushSideException
    extends Exception {
        BrushSideException(String message) {
            super(message);
        }
    }
}

