/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.modules.geom;

import info.ata4.bspsrc.common.util.JavaUtil;
import info.ata4.bspsrc.decompiler.modules.ModuleRead;
import info.ata4.bspsrc.decompiler.util.Winding;
import info.ata4.bspsrc.decompiler.util.WindingFactory;
import info.ata4.bspsrc.lib.BspFileReader;
import info.ata4.bspsrc.lib.struct.DBrush;
import info.ata4.bspsrc.lib.struct.DBrushSide;
import info.ata4.bspsrc.lib.struct.DFace;
import info.ata4.bspsrc.lib.vector.Vector3f;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrushSideFaceMapper
extends ModuleRead {
    private static final Logger L = LogManager.getLogger();
    private static final float AREA_EPS = 1.0f;
    private final WindingFactory windingFactory;
    public final Map<Integer, Integer> brushSideToOrigFace = new HashMap<Integer, Integer>();
    public final Map<Integer, HashSet<Integer>> origFaceToBrushSide = new HashMap<Integer, HashSet<Integer>>();

    public BrushSideFaceMapper(BspFileReader reader, WindingFactory windingFactory) {
        super(reader);
        this.windingFactory = Objects.requireNonNull(windingFactory);
    }

    public void load() {
        this.reader.loadOriginalFaces();
        this.reader.loadFaces();
        this.reader.loadBrushSides();
        this.identifyExactMatches();
        this.identifyMergedMatches();
    }

    private void identifyExactMatches() {
        Map<FaceIndexKey, Set> origFaceIndex = IntStream.range(0, this.bsp.origFaces.size()).boxed().collect(Collectors.groupingBy(origFaceI -> FaceIndexKey.fromFace(this.bsp.origFaces.get((int)origFaceI)), Collectors.toCollection(HashSet::new)));
        for (DBrush brush : this.bsp.brushes) {
            for (int i = 0; i < brush.numside; ++i) {
                int brushSideIndex = brush.fstside + i;
                DBrushSide brushSide = this.bsp.brushSides.get(brushSideIndex);
                Winding brushSideWinding = this.windingFactory.fromSide(this.bsp, brush, brushSide);
                Set potentialFaces = origFaceIndex.getOrDefault(FaceIndexKey.fromBrushSide(brushSide), Collections.emptySet());
                potentialFaces.stream().filter(origFaceI -> this.windingFactory.fromFace(this.bsp, this.bsp.origFaces.get((int)origFaceI)).matches(brushSideWinding)).findAny().ifPresent(origFaceI -> {
                    potentialFaces.remove(origFaceI);
                    this.brushSideToOrigFace.put(brushSideIndex, (Integer)origFaceI);
                    this.origFaceToBrushSide.computeIfAbsent((Integer)origFaceI, key -> new HashSet()).add(brushSideIndex);
                });
            }
        }
        Set remainingOrigFaces = origFaceIndex.values().stream().flatMap(Collection::stream).map(this.bsp.origFaces::get).collect(Collectors.toSet());
        Map<Boolean, Long> partitionedRemainingOrigFacesCount = remainingOrigFaces.stream().collect(Collectors.partitioningBy(dFace -> dFace.dispInfo >= 0, Collectors.counting()));
        L.info(String.format("%d (%.1f%%) exact brushside->origface matches", this.brushSideToOrigFace.size(), 100.0 * (double)this.brushSideToOrigFace.size() / (double)this.bsp.brushSides.size()));
        L.info(String.format("%d/%d (nondisp/disp) original faces left after exact brushside->origface matching", partitionedRemainingOrigFacesCount.get(false), partitionedRemainingOrigFacesCount.get(true)));
    }

    private void identifyMergedMatches() {
        Map<FaceIndexKey, Set> faceIndex = IntStream.range(0, this.bsp.faces.size()).boxed().collect(Collectors.groupingBy(faceI -> FaceIndexKey.fromFace(this.bsp.faces.get((int)faceI)), Collectors.toCollection(HashSet::new)));
        int oldMappingCount = this.brushSideToOrigFace.size();
        for (DBrush brush : this.bsp.brushes) {
            for (int i = 0; i < brush.numside; ++i) {
                int brushSideIndex = brush.fstside + i;
                if (this.brushSideToOrigFace.containsKey(brushSideIndex)) continue;
                DBrushSide brushSide = this.bsp.brushSides.get(brushSideIndex);
                Winding brushSideWinding = this.windingFactory.fromSide(this.bsp, brush, brushSide);
                Vector3f normal = this.bsp.planes.get((int)brushSide.pnum).normal;
                Set potentialFaces = faceIndex.getOrDefault(FaceIndexKey.fromBrushSide(brushSide), Collections.emptySet());
                potentialFaces.stream().map(this.bsp.faces::get).filter(dFace -> dFace.origFace >= 0).collect(Collectors.groupingBy(dFace -> dFace.origFace, Collectors.summingDouble(dFace -> this.windingFactory.fromFace(this.bsp, (DFace)dFace).clipWinding(brushSideWinding, normal).getArea()))).entrySet().stream().filter(entry -> (Double)entry.getValue() > 1.0).max(Map.Entry.comparingByKey()).map(Map.Entry::getKey).ifPresent(origFaceI -> {
                    this.brushSideToOrigFace.put(brushSideIndex, (Integer)origFaceI);
                    this.origFaceToBrushSide.computeIfAbsent((Integer)origFaceI, key -> new HashSet()).add(brushSideIndex);
                });
            }
        }
        int newMatchesCount = this.brushSideToOrigFace.size() - oldMappingCount;
        L.info(String.format("%d (%.1f%%) partial brushside->origface matches", newMatchesCount, 100.0 * (double)newMatchesCount / (double)this.bsp.brushSides.size()));
    }

    public Optional<Integer> getOrigFaceIndex(int brushSideI) {
        return Optional.ofNullable(this.brushSideToOrigFace.get(brushSideI));
    }

    public Set<Integer> getBrushSideIndices(int origFaceI) {
        return JavaUtil.mapGetOrDefault(this.origFaceToBrushSide, origFaceI, Set.of());
    }

    private static class FaceIndexKey {
        public final int pnum;
        public final short texinfo;
        public final short dispInfo;

        private FaceIndexKey(int pnum, short texinfo, short dispInfo) {
            this.pnum = pnum;
            this.texinfo = texinfo;
            this.dispInfo = dispInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FaceIndexKey faceIndexKey = (FaceIndexKey)o;
            return this.pnum == faceIndexKey.pnum && this.texinfo == faceIndexKey.texinfo && this.dispInfo == faceIndexKey.dispInfo;
        }

        public int hashCode() {
            int result = this.pnum;
            result = 31 * result + this.texinfo;
            result = 31 * result + this.dispInfo;
            return result;
        }

        public static FaceIndexKey fromFace(DFace face) {
            return new FaceIndexKey(face.pnum, face.texinfo, face.dispInfo);
        }

        public static FaceIndexKey fromBrushSide(DBrushSide side) {
            return new FaceIndexKey(side.pnum, side.texinfo, (short)(side.dispinfo - 1));
        }
    }
}

