/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.modules;

import info.ata4.bspsrc.decompiler.modules.ModuleRead;
import info.ata4.bspsrc.lib.BspFileReader;
import info.ata4.bspsrc.lib.lump.Lump;
import info.ata4.bspsrc.lib.lump.LumpType;
import java.io.IOException;
import java.nio.file.Files;
import java.util.zip.CRC32;

public class BspChecksum
extends ModuleRead {
    public BspChecksum(BspFileReader reader) {
        super(reader);
    }

    public long getMapCRC() {
        CRC32 crc = new CRC32();
        for (Lump lump : this.bspFile.getLumps()) {
            if (lump.getType() == LumpType.LUMP_ENTITIES) continue;
            crc.update(lump.getBuffer());
        }
        return crc.getValue();
    }

    public long getFileCRC() throws IOException {
        byte[] bytes = Files.readAllBytes(this.bspFile.getFile());
        CRC32 crc = new CRC32();
        crc.update(bytes);
        return crc.getValue();
    }
}

