/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler;

import info.ata4.bspsrc.decompiler.modules.geom.BrushMode;
import info.ata4.bspsrc.decompiler.util.SourceFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BspSourceConfig {
    private static final Logger L = LogManager.getLogger();
    public int defaultAppId = 0;
    public BrushMode brushMode = BrushMode.BRUSHPLANES;
    public SourceFormat sourceFormat = SourceFormat.AUTO;
    public String backfaceTexture = "";
    public String faceTexture = "";
    public boolean fixCubemapTextures = true;
    public boolean fixEntityRot = true;
    public boolean fixToolTextures = true;
    public boolean loadLumpFiles = true;
    public boolean nullOutput = false;
    public boolean skipProt = false;
    public boolean unpackEmbedded = false;
    public boolean smartUnpack = true;
    public float backfaceDepth = 1.0f;
    public int maxCubemapSides = 8;
    public int maxOverlaySides = 64;
    public boolean detailMerge = false;
    public float detailMergeThresh = 1.0f;
    public boolean apForceManualMapping = false;
    public boolean occForceManualMapping = false;
    public boolean writeAreaportals = true;
    public boolean writeBrushEntities = true;
    public boolean writeCameras = true;
    public boolean writeCubemaps = true;
    public boolean writeDetails = true;
    public boolean writeDisp = true;
    public boolean writeOccluders = true;
    public boolean writeOverlays = true;
    public boolean writePointEntities = true;
    public boolean writeStaticProps = true;
    public boolean writeVisgroups = true;
    public boolean writeWorldBrushes = true;
    public boolean writeLadders = true;
    public boolean debug = false;

    public BspSourceConfig() {
    }

    public BspSourceConfig(BspSourceConfig config) {
        this.defaultAppId = config.defaultAppId;
        this.brushMode = config.brushMode;
        this.sourceFormat = config.sourceFormat;
        this.backfaceTexture = config.backfaceTexture;
        this.faceTexture = config.faceTexture;
        this.fixCubemapTextures = config.fixCubemapTextures;
        this.fixEntityRot = config.fixEntityRot;
        this.fixToolTextures = config.fixToolTextures;
        this.loadLumpFiles = config.loadLumpFiles;
        this.nullOutput = config.nullOutput;
        this.skipProt = config.skipProt;
        this.unpackEmbedded = config.unpackEmbedded;
        this.smartUnpack = config.smartUnpack;
        this.backfaceDepth = config.backfaceDepth;
        this.maxCubemapSides = config.maxCubemapSides;
        this.maxOverlaySides = config.maxOverlaySides;
        this.detailMerge = config.detailMerge;
        this.detailMergeThresh = config.detailMergeThresh;
        this.apForceManualMapping = config.apForceManualMapping;
        this.occForceManualMapping = config.occForceManualMapping;
        this.writeAreaportals = config.writeAreaportals;
        this.writeBrushEntities = config.writeBrushEntities;
        this.writeCameras = config.writeCameras;
        this.writeCubemaps = config.writeCubemaps;
        this.writeDetails = config.writeDetails;
        this.writeDisp = config.writeDisp;
        this.writeOccluders = config.writeOccluders;
        this.writeOverlays = config.writeOverlays;
        this.writePointEntities = config.writePointEntities;
        this.writeStaticProps = config.writeStaticProps;
        this.writeVisgroups = config.writeVisgroups;
        this.writeWorldBrushes = config.writeWorldBrushes;
        this.writeLadders = config.writeLadders;
        this.debug = config.debug;
    }

    public void dumpToLog() {
        this.dumpToLog(L);
    }

    public void dumpToLog(Logger logger) {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                logger.info("%s = %s".formatted(field.getName(), field.get(this)));
            }
            catch (IllegalAccessException e) {
                logger.warn("", (Throwable)e);
            }
        }
    }

    public boolean isWriteEntities() {
        return this.writeBrushEntities || this.writePointEntities;
    }

    public void setWriteEntities(boolean writeEntities) {
        this.writeBrushEntities = this.writePointEntities = writeEntities;
    }
}

