/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class CountingInputStream
extends InputStream {
    private final InputStream delegate;
    private long bytesRead;

    public CountingInputStream(InputStream delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public int read() throws IOException {
        int read = this.delegate.read();
        if (read > 0) {
            this.bytesRead += (long)read;
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.delegate.read();
        if (read > 0) {
            this.bytesRead += (long)read;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.delegate.read();
        if (read > 0) {
            this.bytesRead += (long)read;
        }
        return read;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

