/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.util.log.plugins;

import java.awt.Component;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="Dialog", category="Core", elementType="appender")
public class DialogAppender
extends AbstractAppender {
    private final Component component;

    protected DialogAppender(String name, Filter filter, StringLayout layout, boolean ignoreExceptions, Property[] properties, Component component) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.component = Objects.requireNonNull(component);
    }

    @Override
    public void append(LogEvent event) {
        if (!event.getLevel().isMoreSpecificThan(Level.ERROR)) {
            return;
        }
        String message = (String)((StringLayout)this.getLayout()).toSerializable(event);
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.component, message, "Error", 0));
    }

    @PluginFactory
    public static DialogAppender createAppender(String name, Filter filter, StringLayout layout, boolean ignoreExceptions, Component component) {
        if (name == null) {
            LOGGER.error("No name provided for DialogAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (component == null) {
            LOGGER.error("No parent component provided for DialogAppender");
        }
        return new DialogAppender(name, filter, layout, ignoreExceptions, null, component);
    }
}

