/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.util.log;

import info.ata4.bspsrc.app.util.log.plugins.DocumentAppender;
import info.ata4.bspsrc.common.util.JavaUtil;
import info.ata4.bspsrc.decompiler.BspFileEntry;
import info.ata4.io.util.PathUtils;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.swing.text.Document;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.KeyValuePair;

public class Log4jUtil {
    private static final Logger L = LogManager.getLogger();
    public static final PatternLayout FILE_PATTERN = PatternLayout.newBuilder().withPattern("%d{HH:mm:ss.SSS} %-5level %msg%n").build();
    public static final PatternLayout UI_PATTERN = PatternLayout.newBuilder().withPattern("[%level{WARN=warning, DEBUG=debug, ERROR=error, TRACE=trace, INFO=info}] %msg%n").build();

    public static void configure(URL configUrl) {
        try {
            Configurator.initialize((String)null, null, configUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setRootLevel(Level level) {
        ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).setLevel(level);
    }

    public static CloseableScope addAppenders(Appender ... appenders) {
        org.apache.logging.log4j.core.Logger rootLogger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        for (Appender appender : appenders) {
            rootLogger.addAppender(appender);
            appender.start();
        }
        return () -> {
            for (Appender appender : appenders) {
                rootLogger.removeAppender(appender);
                appender.stop();
            }
        };
    }

    public static CloseableScope configureDecompilationLogFileAppender(List<UUID> entryUuids, List<BspFileEntry> entries) {
        LoggerContext context = LoggerContext.getContext(false);
        Configuration config = context.getConfiguration();
        Set appenders = StreamSupport.stream(JavaUtil.zip(entryUuids, entries).spliterator(), false).map(entry -> Map.entry((UUID)entry.getKey(), PathUtils.setExtension(((BspFileEntry)entry.getValue()).getVmfFile(), "log"))).map(entry -> ((FileAppender.Builder)((AbstractAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)FileAppender.newBuilder()).setName("Decompile task file appender %s".formatted(entry.getKey()))).setFilter(ThreadContextMapFilter.createFilter(new KeyValuePair[]{new KeyValuePair("decompile_id", ((UUID)entry.getKey()).toString())}, null, Filter.Result.ACCEPT, Filter.Result.DENY))).setLayout(FILE_PATTERN)).withAppend(false)).withFileName(((Path)entry.getValue()).toString())).setConfiguration(config)).build()).collect(Collectors.toSet());
        return Log4jUtil.addAppenders((Appender[])appenders.toArray(Appender[]::new));
    }

    public static CloseableScope configureDecompilationDocumentAppenders(List<UUID> entryUuids, List<Document> taskLogs) {
        LoggerContext context = LoggerContext.getContext(false);
        Configuration config = context.getConfiguration();
        Set appenders = StreamSupport.stream(JavaUtil.zip(entryUuids, taskLogs).spliterator(), false).map(entry -> ((DocumentAppender.Builder)((DocumentAppender.Builder)((DocumentAppender.Builder)((AbstractFilterable.Builder)((DocumentAppender.Builder)((AbstractAppender.Builder)DocumentAppender.newBuilder()).setName("Decompile task document appender %s".formatted(entry.getKey()))).setDocument((Document)entry.getValue())).setFilter(ThreadContextMapFilter.createFilter(new KeyValuePair[]{new KeyValuePair("decompile_id", ((UUID)entry.getKey()).toString())}, null, Filter.Result.ACCEPT, Filter.Result.DENY))).setLayout(UI_PATTERN)).setConfiguration(config)).build()).collect(Collectors.toSet());
        return Log4jUtil.addAppenders((Appender[])appenders.toArray(Appender[]::new));
    }

    public static interface CloseableScope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

