/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.models;

import info.ata4.bspsrc.app.src.ObservableBspSourceConfig;
import info.ata4.bspsrc.app.src.gui.models.DecompileTaskModel;
import info.ata4.bspsrc.decompiler.BspFileEntry;
import info.ata4.bspsrc.decompiler.BspSourceConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class BspSourceModel {
    private final ObservableBspSourceConfig config = new ObservableBspSourceConfig(new BspSourceConfig());
    private final Set<Consumer<DecompileTaskModel>> onDecompileTaskListener = new HashSet<Consumer<DecompileTaskModel>>();

    public void addOnDecompileTask(Consumer<DecompileTaskModel> onDecompileTask) {
        this.onDecompileTaskListener.add(Objects.requireNonNull(onDecompileTask));
    }

    public ObservableBspSourceConfig getConfig() {
        return this.config;
    }

    public void setDefaults() {
        this.config.setConfig(new BspSourceConfig());
    }

    public void decompile(List<BspFileEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        BspSourceConfig c = this.config.getCopy();
        DecompileTaskModel decompileTaskModel = new DecompileTaskModel(c, entries);
        this.onDecompileTaskListener.forEach(consumer -> consumer.accept(decompileTaskModel));
    }
}

