/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.components.task;

import info.ata4.bspsrc.app.src.gui.data.ErrorNotification;
import info.ata4.bspsrc.app.src.gui.data.Task;
import info.ata4.bspsrc.app.src.gui.models.DecompileTaskModel;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.app.util.swing.model.ReadonlyListTableModel;
import info.ata4.bspsrc.app.util.swing.renderer.ErrorNotificationCellRenderer;
import info.ata4.bspsrc.app.util.swing.renderer.NoFocusProxyCellRenderer;
import info.ata4.bspsrc.app.util.swing.renderer.PathCellRenderer;
import info.ata4.bspsrc.app.util.swing.renderer.StateCellRender;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;

public class DecompileTaskDialog
extends JDialog {
    private final DecompileTaskModel model;
    private final ReadonlyListTableModel<Task> tableModel = new ReadonlyListTableModel(List.of(new ReadonlyListTableModel.Column<Task, Task.State>("", Task.State.class, Task::state), new ReadonlyListTableModel.Column<Task, Path>("Bsp", Path.class, Task::bspFile)));
    private final JTable tblTasks = new JTable(){
        {
            this.setModel(DecompileTaskDialog.this.tableModel);
            this.setAutoCreateRowSorter(true);
            this.getTableHeader().setReorderingAllowed(false);
            this.setSelectionMode(0);
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            this.setRowHeight(25);
            this.setPreferredScrollableViewportSize(new Dimension(150, 0));
            this.setDefaultRenderer(Task.State.class, new NoFocusProxyCellRenderer(new StateCellRender()));
            this.setDefaultRenderer(Path.class, new NoFocusProxyCellRenderer(new PathCellRenderer()));
            GuiUtil.setColumnWidth(this, 0, (Object)Task.State.FINISHED, true, true);
            this.getSelectionModel().addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = this.convertRowIndexToModel(this.getSelectedRow());
                DecompileTaskDialog.this.selectTask(row);
            });
        }
    };
    private final JTextArea txtaLog = new JTextArea(30, 100){
        {
            this.putClientProperty("FlatLaf.style", "inactiveBackground: @componentBackground");
            this.setFont(new Font("Consolas", 0, 12));
            this.setEditable(false);
        }
    };
    private final DefaultListModel<ErrorNotification> lstNotificationsModel = new DefaultListModel();
    private final JList<ErrorNotification> lstNotifications = new JList<ErrorNotification>(){
        {
            this.setModel(DecompileTaskDialog.this.lstNotificationsModel);
            this.setSelectionMode(0);
            this.setCellRenderer(new ErrorNotificationCellRenderer());
            this.getSelectionModel().addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DecompileTaskDialog.this.selectTask(((ErrorNotification)this.getSelectedValue()).taskIndex());
            });
        }
    };
    private final JButton btnDialog = new JButton(){
        {
            this.addActionListener(e -> {
                DecompileTaskDialog.this.model.close();
                DecompileTaskDialog.this.dispose();
            });
        }
    };

    public DecompileTaskDialog(Window owner, final DecompileTaskModel model) {
        super(owner);
        this.setTitle("BSPSource output");
        this.model = Objects.requireNonNull(model);
        model.addStateListener(this::onStateChange);
        model.addTaskUpdateListener(i -> this.onDataChange());
        model.addNotificationListener(this.lstNotificationsModel::addElement);
        this.onStateChange(model.getState());
        this.onDataChange();
        JPanel pnl = new JPanel(new MigLayout("", "[grow]", "[grow||]"));
        JScrollPane scrlTasks = new JScrollPane(this.tblTasks, 20, 31);
        JScrollPane scrlLog = new JScrollPane(this.txtaLog, 20, 30);
        JSplitPane spltUpper = new JSplitPane(1, scrlTasks, scrlLog);
        spltUpper.setResizeWeight(0.2);
        JScrollPane scrlInfos = new JScrollPane(this.lstNotifications, 20, 31);
        final JSplitPane splt = new JSplitPane(0, model.getTasks().size() == 1 ? scrlLog : spltUpper, scrlInfos);
        splt.setDividerLocation(Integer.MAX_VALUE);
        splt.setResizeWeight(0.8);
        pnl.add((Component)splt, "grow, wrap");
        pnl.add((Component)new JSeparator(), "grow, wrap");
        pnl.add((Component)this.btnDialog, "right");
        this.setContentPane(pnl);
        this.lstNotificationsModel.addListDataListener(new ListDataListener(){

            private void updateSplitPane() {
                if (DecompileTaskDialog.this.lstNotificationsModel.isEmpty()) {
                    splt.setDividerLocation(Integer.MAX_VALUE);
                } else {
                    splt.setDividerLocation(-1);
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.updateSplitPane();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.updateSplitPane();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        if (this.tblTasks.getRowCount() > 0) {
            this.tblTasks.setRowSelectionInterval(0, 0);
        }
        this.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosed(WindowEvent e) {
                model.close();
            }
        });
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setDefaultCloseOperation(2);
    }

    private void onStateChange(DecompileTaskModel.State state) {
        String text;
        if (state instanceof DecompileTaskModel.State.Running) {
            text = "Cancel";
        } else if (state instanceof DecompileTaskModel.State.Finished) {
            text = "Close";
        } else {
            throw new RuntimeException("Not reachable");
        }
        this.btnDialog.setText(text);
    }

    private void onDataChange() {
        if (this.tableModel.getRowCount() == 0) {
            this.tableModel.setData(this.model.getTasks());
        } else {
            this.tableModel.updateData(this.model.getTasks());
        }
    }

    private void selectTask(int index) {
        int viewIndex = this.tblTasks.convertRowIndexToView(index);
        this.tblTasks.setRowSelectionInterval(viewIndex, viewIndex);
        this.tblTasks.scrollRectToVisible(new Rectangle(this.tblTasks.getCellRect(viewIndex, 0, true)));
        Document logDoc = this.model.getTaskLog(index);
        this.txtaLog.setDocument(logDoc);
        this.txtaLog.scrollRectToVisible(new Rectangle());
    }
}

