/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.components.main;

import info.ata4.bspsrc.app.src.ObservableBspSourceConfig;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.decompiler.BspSourceConfig;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class TexturesPanel
extends JPanel {
    private final ObservableBspSourceConfig config;
    private final List<String> textureSuggestions = List.of("skybox/sky_fake_white", "tools/toolsblack", "tools/toolsnodraw", "dev/dev_measuregeneric01", "tools/toolsskip");
    private final JComboBox<String> cmbFaceTexture = new JComboBox<String>((String[])this.textureSuggestions.toArray(String[]::new)){
        {
            this.setEditable(true);
            this.putClientProperty("JTextField.placeholderText", "<None>");
            this.addActionListener(e -> TexturesPanel.this.config.updateConfig(c -> {
                c.faceTexture = (String)TexturesPanel.this.cmbFaceTexture.getSelectedItem();
            }));
        }
    };
    private final JComboBox<String> cmbBackFaceTexture = new JComboBox<String>((String[])this.textureSuggestions.toArray(String[]::new)){
        {
            this.setEditable(true);
            this.putClientProperty("JTextField.placeholderText", "<None>");
            this.addActionListener(e -> TexturesPanel.this.config.updateConfig(c -> {
                c.backfaceTexture = (String)TexturesPanel.this.cmbBackFaceTexture.getSelectedItem();
            }));
        }
    };
    private final JCheckBox chkFixCubemapTextures = new JCheckBox("Fix cubemap textures"){
        {
            this.setToolTipText("Fix textures for environment-mapped materials.");
            this.addActionListener(e -> TexturesPanel.this.config.updateConfig(c -> {
                c.fixCubemapTextures = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkFixToolTextures = new JCheckBox("Fix tool textures"){
        {
            this.setToolTipText("Fix tool textures such as toolsnodraw or toolsblocklight.");
            this.addActionListener(e -> TexturesPanel.this.config.updateConfig(c -> {
                c.fixToolTextures = this.isSelected();
            }));
        }
    };

    public TexturesPanel(ObservableBspSourceConfig config) {
        this.config = Objects.requireNonNull(config);
        config.addListener(this::update);
        this.update();
        this.setLayout(new MigLayout("", "", "[|]u[]"));
        JPanel pnlOverride = new JPanel(new MigLayout());
        pnlOverride.setBorder(BorderFactory.createTitledBorder("Texture overwrite"));
        pnlOverride.add(new JLabel("Face texture"));
        pnlOverride.add(this.cmbFaceTexture, "wrap");
        pnlOverride.add(new JLabel("Back-face texture"));
        pnlOverride.add(this.cmbBackFaceTexture, "wrap");
        this.add((Component)this.chkFixCubemapTextures, "wrap");
        this.add((Component)this.chkFixToolTextures, "wrap");
        this.add((Component)pnlOverride, "wrap");
    }

    private void update() {
        this.cmbFaceTexture.setSelectedItem(this.config.get(c -> c.faceTexture));
        this.cmbBackFaceTexture.setSelectedItem(this.config.get(c -> c.backfaceTexture));
        this.chkFixCubemapTextures.setSelected(this.config.get(c -> c.fixCubemapTextures));
        this.chkFixToolTextures.setSelected(this.config.get(c -> c.fixToolTextures));
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new TexturesPanel(new ObservableBspSourceConfig(new BspSourceConfig())));
    }
}

