/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.components.main;

import info.ata4.bspsrc.app.src.ObservableBspSourceConfig;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.decompiler.BspSourceConfig;
import info.ata4.bspsrc.decompiler.util.SourceFormat;
import info.ata4.bspsrc.lib.app.SourceAppDB;
import java.awt.Component;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class OtherPanel
extends JPanel {
    private final ObservableBspSourceConfig config;
    private final JCheckBox chkDebug = new JCheckBox("Debug mode"){
        {
            this.setToolTipText("<html>\nThe debug mode produces <i>very</i> verbose output<br>\ntext and writes additional data into the VMF file.\n</html>");
            this.addActionListener(e -> OtherPanel.this.config.updateConfig(c -> {
                c.debug = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkLoadLumpFiles = new JCheckBox("Load lump files"){
        {
            this.setToolTipText("<html>\nWhen enabled, external lump files  <i>(.lmp)</i> with the same<br>\nname as the BSP file will be processed during decompilation.\n</html>");
            this.addActionListener(e -> OtherPanel.this.config.updateConfig(c -> {
                c.loadLumpFiles = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkHammerVisgroups = new JCheckBox("Create hammer visgroups"){
        {
            this.setToolTipText("<html>\nAutomatically group instanced entities to visgroups.\n<p><b>Note:</b> World brushes created from instances can't<br>\nbe grouped because of missing information.</p>\n</html>");
            this.addActionListener(e -> OtherPanel.this.config.updateConfig(c -> {
                c.writeVisgroups = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkHammerCameras = new JCheckBox("Create hammer cameras"){
        {
            this.setToolTipText("Create Hammer viewport cameras above\neach player spawn to ease navigation.");
            this.addActionListener(e -> OtherPanel.this.config.updateConfig(c -> {
                c.writeCameras = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkExtractEmbedded = new JCheckBox("Extract embedded files"){
        {
            this.setToolTipText("Extract all resource files that are embedded into the BSP file.");
            this.addActionListener(e -> OtherPanel.this.config.updateConfig(c -> {
                c.unpackEmbedded = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkSmartExtract = new JCheckBox("Smart extracting"){
        {
            this.setToolTipText("Don't extract files that were automatically generated by vBsp.");
            this.addActionListener(e -> OtherPanel.this.config.updateConfig(c -> {
                c.smartUnpack = this.isSelected();
            }));
        }
    };
    private final JComboBox<MapFormatEntry> cmbBspFormat = new JComboBox<MapFormatEntry>(){
        {
            this.setToolTipText("<html>\n<p>Overrides the internal game detection for maps.</p>\n<p>Select <i>\"Automatic\"</i> for automatic detection.</p>\n<br>\n<b>Warning:</b> Change only if the game isn't detected<br>\ncorrectly, wrong values can cause program errors!\n</html>");
            this.addActionListener(e -> OtherPanel.this.config.updateConfig(c -> {
                c.defaultAppId = ((MapFormatEntry)OtherPanel.this.cmbBspFormat.getSelectedItem()).appId();
            }));
        }
    };
    private final JComboBox<SourceFormat> cmbVmfFormat = new JComboBox<SourceFormat>(SourceFormat.values()){
        {
            this.setToolTipText("Extract all resource files that are embedded into the BSP file.");
            this.addActionListener(e -> OtherPanel.this.config.updateConfig(c -> {
                c.sourceFormat = (SourceFormat)((Object)((Object)((Object)OtherPanel.this.cmbVmfFormat.getSelectedItem())));
            }));
        }
    };

    public OtherPanel(ObservableBspSourceConfig config) {
        this.config = Objects.requireNonNull(config);
        this.initCmbBspFormat();
        config.addListener(this::update);
        this.update();
        this.setLayout(new MigLayout("", "", "[]u[]"));
        this.add((Component)this.createUpperPanel(), "wrap");
        this.add(this.createLowerPanel());
    }

    private void initCmbBspFormat() {
        Map<Integer, String> apps = SourceAppDB.getInstance().getAppList();
        apps.entrySet().stream().map(entry -> new MapFormatEntry((Integer)entry.getKey(), (String)entry.getValue())).sorted(Comparator.comparing(MapFormatEntry::toString)).forEach(this.cmbBspFormat::addItem);
        this.cmbBspFormat.insertItemAt(new MapFormatEntry(0, "Automatic"), 0);
        this.cmbBspFormat.setSelectedIndex(0);
        this.cmbBspFormat.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof MapFormatEntry) {
                    MapFormatEntry entry = (MapFormatEntry)value;
                    value = entry.name();
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
    }

    private JPanel createUpperPanel() {
        JPanel panel = new JPanel(new MigLayout("insets 0"));
        panel.add(this.chkDebug);
        panel.add((Component)this.chkHammerVisgroups, "wrap");
        panel.add(this.chkLoadLumpFiles);
        panel.add((Component)this.chkHammerCameras, "wrap");
        panel.add((Component)this.chkExtractEmbedded, "span, wrap");
        panel.add((Component)this.chkSmartExtract, "gapleft i, span, wrap");
        return panel;
    }

    private JPanel createLowerPanel() {
        JPanel panel = new JPanel(new MigLayout("insets 0"));
        panel.add(new JLabel("BSP format"));
        panel.add(this.cmbBspFormat, "wrap");
        panel.add(new JLabel("VMF format"));
        panel.add(this.cmbVmfFormat, "wrap");
        return panel;
    }

    private void update() {
        this.chkSmartExtract.setEnabled(this.config.get(c -> c.unpackEmbedded));
        this.chkDebug.setSelected(this.config.get(c -> c.debug));
        this.chkLoadLumpFiles.setSelected(this.config.get(c -> c.loadLumpFiles));
        this.chkHammerVisgroups.setSelected(this.config.get(c -> c.writeVisgroups));
        this.chkHammerCameras.setSelected(this.config.get(c -> c.writeCameras));
        this.chkExtractEmbedded.setSelected(this.config.get(c -> c.unpackEmbedded));
        this.chkSmartExtract.setSelected(this.config.get(c -> c.smartUnpack));
        int defaultAppId = this.config.get(c -> c.defaultAppId);
        int bspFormatIndex = IntStream.range(0, this.cmbBspFormat.getItemCount()).filter(i -> this.cmbBspFormat.getItemAt(i).appId() == defaultAppId).findAny().orElse(-1);
        this.cmbBspFormat.setSelectedIndex(bspFormatIndex);
        this.cmbVmfFormat.setSelectedItem((Object)this.config.get(c -> c.sourceFormat));
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new OtherPanel(new ObservableBspSourceConfig(new BspSourceConfig())));
    }

    private record MapFormatEntry(int appId, String name) {
    }
}

