/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.components.main;

import info.ata4.bspsrc.app.src.ObservableBspSourceConfig;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.decompiler.BspSourceConfig;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class EntityMappingPanel
extends JPanel {
    private final ObservableBspSourceConfig config;
    private final JCheckBox chkManualAreaportals = new JCheckBox("Use manual areaportal reallocation"){
        {
            this.setToolTipText("Manually calculate areaportal reallocation.\nThis method should be more robust at the expense of\nbeing less precise sometimes");
            this.addActionListener(e -> EntityMappingPanel.this.config.updateConfig(c -> {
                c.apForceManualMapping = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkManualOccluders = new JCheckBox("Use manual occluder reallocation"){
        {
            this.setToolTipText("Manually calculate occluder reallocation.\nThis method should be more robust at the expense of\nbeing less precise sometimes");
            this.addActionListener(e -> EntityMappingPanel.this.config.updateConfig(c -> {
                c.occForceManualMapping = this.isSelected();
            }));
        }
    };

    public EntityMappingPanel(ObservableBspSourceConfig config) {
        this.config = Objects.requireNonNull(config);
        config.addListener(this::update);
        this.update();
        this.setLayout(new MigLayout());
        this.add((Component)this.chkManualAreaportals, "wrap");
        this.add((Component)this.chkManualOccluders, "wrap");
    }

    private void update() {
        this.chkManualAreaportals.setSelected(this.config.get(c -> c.apForceManualMapping));
        this.chkManualOccluders.setSelected(this.config.get(c -> c.occForceManualMapping));
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new EntityMappingPanel(new ObservableBspSourceConfig(new BspSourceConfig())));
    }
}

