/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.cli;

import info.ata4.bspsrc.app.util.BspPathUtil;
import info.ata4.bspsrc.app.util.ErrorMessageUtil;
import info.ata4.bspsrc.app.util.log.Log4jUtil;
import info.ata4.bspsrc.common.util.AlphanumComparator;
import info.ata4.bspsrc.decompiler.BspFileEntry;
import info.ata4.bspsrc.decompiler.BspSource;
import info.ata4.bspsrc.decompiler.BspSourceConfig;
import info.ata4.bspsrc.decompiler.modules.geom.BrushMode;
import info.ata4.bspsrc.decompiler.util.SourceFormat;
import info.ata4.bspsrc.lib.app.SourceAppDB;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="bspsrc", version={"BSPSource 1.4.4", "", "Based on VMEX v0.98g by Rof <rof@mellish.org.uk>", "Extended and modified by Nico Bergemann <barracuda415@yahoo.de>"}, parameterListHeading="%nParameters:%n", optionListHeading="%nOptions:%n", abbreviateSynopsis=true, mixinStandardHelpOptions=true, sortOptions=false, sortSynopsis=false, showDefaultValues=true)
public class BspSourceCliCommand
implements Callable<Void> {
    private static final Logger L = LogManager.getLogger();
    private static final BspSourceConfig INITIAL_CONFIG = new BspSourceConfig();
    @CommandLine.Option(names={"--appids"}, description={"List all available application IDs"}, help=true)
    private boolean listAppIds;
    @CommandLine.Option(names={"-d", "--debug"}, description={"Enable debug mode. Increases verbosity and adds additional data to the VMF file."})
    private boolean debug;
    @CommandLine.Option(names={"-r", "--recursive"}, description={"Recursively decompile files found in subdirectories."})
    private boolean recursive;
    @CommandLine.Option(names={"-o", "--output"}, description={"Override output path for VMF file(s). Treated as directory if multiple BSP files are provided."}, paramLabel="<path>")
    private Path outputPath;
    @CommandLine.Option(names={"-l", "--list"}, description={"Treat specified files as text files containing a BSP file list. BSP files are seperated by new lines."})
    private boolean useFileLists;
    @CommandLine.Parameters(description={"One or more bsp files or folders.", "Alternatively, if --list is specified, one or more text files containing a list of bsp file or folder paths."}, arity="1")
    private List<Path> paths;
    @CommandLine.ArgGroup(validate=false, heading="%nEntity related options%n")
    private EntityOpts entityOpts = new EntityOpts();
    private EntityMappingOptions entityMappingOptions = new EntityMappingOptions();
    @CommandLine.ArgGroup(validate=false, heading="%nBrush related options%n")
    private BrushOptions brushOptions = new BrushOptions();
    @CommandLine.ArgGroup(validate=false, heading="%nTexture related options%n")
    private TextureOptions textureOptions = new TextureOptions();
    @CommandLine.ArgGroup(validate=false, heading="%nMiscellaneous options%n")
    private MiscellaneousOptions miscellaneousOptions = new MiscellaneousOptions();

    @Override
    public Void call() throws IOException, InterruptedException {
        if (this.debug) {
            Log4jUtil.setRootLevel(Level.DEBUG);
            L.debug("Debug mode on, verbosity set to maximum");
        }
        if (this.listAppIds) {
            System.out.printf("%8s  %s\n", "ID", "Name");
            SourceAppDB.getInstance().getAppList().entrySet().stream().sorted(Map.Entry.comparingByValue(AlphanumComparator.COMPARATOR)).forEachOrdered(entry -> System.out.printf("%8d  %s\n", entry.getKey(), entry.getValue()));
            return null;
        }
        BspSourceConfig config = this.getConfig();
        ArrayList<BspFileEntry> entries = new ArrayList<BspFileEntry>(this.getEntries());
        if (entries.isEmpty()) {
            L.error("No BSP file(s) specified");
            return null;
        }
        BspSource bspsrc = new BspSource(config, entries);
        try (Log4jUtil.CloseableScope scope = Log4jUtil.configureDecompilationLogFileAppender(bspsrc.getEntryUuids(), entries);){
            bspsrc.run(signal -> {
                if (signal instanceof BspSource.Signal.TaskFinished) {
                    BspSource.Signal.TaskFinished task = (BspSource.Signal.TaskFinished)signal;
                    BspSourceCliCommand.printTaskFinished(entries, task);
                } else if (signal instanceof BspSource.Signal.TaskFailed) {
                    BspSource.Signal.TaskFailed task = (BspSource.Signal.TaskFailed)signal;
                    BspSourceCliCommand.printTaskFailed(entries, task);
                }
            });
        }
        return null;
    }

    private static void printTaskFailed(List<BspFileEntry> entries, BspSource.Signal.TaskFailed task) {
        Path bspFile = entries.get(task.index()).getBspFile();
        L.error("'{}' - Failed: {}", (Object)bspFile, (Object)ErrorMessageUtil.decompileExceptionToMessage(task.exception()));
    }

    private static void printTaskFinished(List<BspFileEntry> entries, BspSource.Signal.TaskFinished task) {
        Path bspFile = entries.get(task.index()).getBspFile();
        L.info("'{}' - Decompiled successfully.", (Object)bspFile);
    }

    private BspSourceConfig getConfig() {
        BspSourceConfig config = new BspSourceConfig();
        config.debug = this.debug;
        config.writePointEntities = !this.entityOpts.noPointEnts;
        config.writeBrushEntities = !this.entityOpts.noBrushEnts;
        config.writeStaticProps = !this.entityOpts.noStaticPropEnts;
        config.writeOverlays = !this.entityOpts.noOverlayEnts;
        config.writeCubemaps = !this.entityOpts.noCubemapEnts;
        config.writeDetails = !this.entityOpts.noDetailEnts;
        config.writeAreaportals = !this.entityOpts.noAreaportalEnts;
        config.writeOccluders = !this.entityOpts.noOccluderEnts;
        config.writeLadders = !this.entityOpts.noLadderEnts;
        config.fixEntityRot = !this.entityOpts.noInstanceEntityRotationFix;
        config.apForceManualMapping = this.entityMappingOptions.forceAreaportalManualEntMapping;
        config.occForceManualMapping = this.entityMappingOptions.forceOccluderManualEntMapping;
        config.writeWorldBrushes = !this.brushOptions.noBrushes;
        config.writeDisp = !this.brushOptions.noDisplacements;
        config.brushMode = this.brushOptions.brushMode;
        config.backfaceDepth = this.brushOptions.thickness;
        config.faceTexture = this.textureOptions.faceTex;
        config.backfaceTexture = this.textureOptions.backFaceTex;
        config.nullOutput = this.miscellaneousOptions.noVmf;
        config.loadLumpFiles = !this.miscellaneousOptions.noLumpFiles;
        config.skipProt = this.miscellaneousOptions.noProt;
        config.writeVisgroups = !this.miscellaneousOptions.noVisGroups;
        config.writeCameras = !this.miscellaneousOptions.noCams;
        config.defaultAppId = this.miscellaneousOptions.appId;
        config.sourceFormat = this.miscellaneousOptions.sourceFormat;
        config.unpackEmbedded = this.miscellaneousOptions.unpackEmbedded;
        config.smartUnpack = !this.miscellaneousOptions.noSmartUnpack;
        return config;
    }

    private Set<BspFileEntry> getEntries() throws IOException {
        List<Path> bspPaths;
        if (this.useFileLists) {
            ArrayList<Path> bspPathsTmp = new ArrayList<Path>();
            for (Path path : this.paths) {
                Files.readAllLines(path).stream().map(x$0 -> Path.of(x$0, new String[0])).forEach(bspPathsTmp::add);
            }
            bspPaths = bspPathsTmp;
        } else {
            bspPaths = this.paths;
        }
        HashSet<BspFileEntry> fileSet = new HashSet<BspFileEntry>();
        for (Path path : bspPaths) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                PathMatcher bspPathMatcher = path.getFileSystem().getPathMatcher("glob:**.bsp");
                Stream<Path> pathStream = Files.walk(path, this.recursive ? Integer.MAX_VALUE : 0, new FileVisitOption[0]);
                try {
                    pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(bspPathMatcher::matches).map(bspPath -> new BspFileEntry((Path)bspPath, BspPathUtil.defaultVmfPath(bspPath, this.outputPath))).forEach(fileSet::add);
                    continue;
                }
                finally {
                    if (pathStream != null) {
                        pathStream.close();
                    }
                    continue;
                }
            }
            Path vmfPath = bspPaths.size() > 1 || this.outputPath == null ? BspPathUtil.defaultVmfPath(path, this.outputPath) : this.outputPath;
            fileSet.add(new BspFileEntry(path, vmfPath));
        }
        return fileSet;
    }

    static class EntityOpts {
        @CommandLine.Option(names={"--no_point_ents"}, description={"Don't write any point entities."})
        private boolean noPointEnts;
        @CommandLine.Option(names={"--no_brush_ents"}, description={"Don't write any brush entities."})
        private boolean noBrushEnts;
        @CommandLine.Option(names={"--no_sprp"}, description={"Don't write prop_static entities."})
        private boolean noStaticPropEnts;
        @CommandLine.Option(names={"--no_overlays"}, description={"Don't write info_overlay entities."})
        private boolean noOverlayEnts;
        @CommandLine.Option(names={"--no_cubemaps"}, description={"Don't write env_cubemap entities."})
        private boolean noCubemapEnts;
        @CommandLine.Option(names={"--no_details"}, description={"Don't write func_detail entities."})
        private boolean noDetailEnts;
        @CommandLine.Option(names={"--no_areaportals"}, description={"Don't write func_areaportal(_window) entities."})
        private boolean noAreaportalEnts;
        @CommandLine.Option(names={"--no_occluders"}, description={"Don't write func_occluder entities."})
        private boolean noOccluderEnts;
        @CommandLine.Option(names={"--no_ladders"}, description={"Don't write func_ladder entities."})
        private boolean noLadderEnts;
        @CommandLine.Option(names={"--no_rotfix"}, description={"Don't fix instance entity brush rotations for Hammer."})
        private boolean noInstanceEntityRotationFix;

        EntityOpts() {
        }
    }

    private static class EntityMappingOptions {
        @CommandLine.Option(names={"--force_manual_areaportal"}, description={"Force manual entity mapping for areaportal entities."})
        private boolean forceAreaportalManualEntMapping;
        @CommandLine.Option(names={"--force_manual_occluder"}, description={"Force manual entitiy mapping for occluder entities."})
        private boolean forceOccluderManualEntMapping;

        private EntityMappingOptions() {
        }
    }

    private static class BrushOptions {
        @CommandLine.Option(names={"--no_brushes"}, description={"Don't write any world brushes."})
        private boolean noBrushes;
        @CommandLine.Option(names={"--no_disps"}, description={"Don't write displacement surfaces."})
        private boolean noDisplacements;
        @CommandLine.Option(names={"--brushmode"}, description={"Brush decompiling mode:", "${BrushMode.BRUSHPLANES.name()} - brushes and planes", "${BrushMode.ORIGFACE.name()} - original faces only", "${BrushMode.ORIGFACE_PLUS.name()} - original + split faces", "${BrushMode.SPLITFACE.name()} - split faces only"}, paramLabel="<mode>")
        private BrushMode brushMode;
        @CommandLine.Option(names={"--thickness"}, description={"Thickness of brushes create from flat faces in units."}, paramLabel="<value>")
        private float thickness;

        private BrushOptions() {
            this.brushMode = BspSourceCliCommand.INITIAL_CONFIG.brushMode;
            this.thickness = BspSourceCliCommand.INITIAL_CONFIG.backfaceDepth;
        }
    }

    private static class TextureOptions {
        @CommandLine.Option(names={"--facetex"}, description={"Replace all face textures with this one."}, paramLabel="<texture>")
        private String faceTex;
        @CommandLine.Option(names={"--bfacetex"}, description={"Replace all back-face textures with this one. Used in face-based decompiling modes only."}, paramLabel="<texture>")
        private String backFaceTex;

        private TextureOptions() {
            this.faceTex = BspSourceCliCommand.INITIAL_CONFIG.faceTexture;
            this.backFaceTex = BspSourceCliCommand.INITIAL_CONFIG.backfaceTexture;
        }
    }

    private static class MiscellaneousOptions {
        @CommandLine.Option(names={"--no_vmf"}, description={"Don't write any VMF files, read BSP only."})
        private boolean noVmf;
        @CommandLine.Option(names={"--no_lumpfiles"}, description={"Don't load lump files (.lmp) associated with the BSP file."})
        private boolean noLumpFiles;
        @CommandLine.Option(names={"--no_prot"}, description={"Skip decompiling protection checking. Can increase speed when mass-decompiling unprotected maps."})
        private boolean noProt;
        @CommandLine.Option(names={"--no_visgroups"}, description={"Don't group entities from instances into visgroups."})
        private boolean noVisGroups;
        @CommandLine.Option(names={"--no_cams"}, description={"Don't create Hammer cameras above each player spawn."})
        private boolean noCams;
        @CommandLine.Option(names={"--appid"}, description={"Overrides game detection by using this Steam Application ID instead", "Use -appids to list all known app-IDs."}, paramLabel="<id>")
        private int appId;
        @CommandLine.Option(names={"--format"}, description={"Sets the VMF format used for the decompiled maps:", "AUTO - Automatic", "OLD - Source 2004 to 2009", "NEW - Source 2010 and later"}, paramLabel="<format>")
        private SourceFormat sourceFormat;
        @CommandLine.Option(names={"--unpack_embedded"}, description={"Unpack embedded files in the bsp."})
        private boolean unpackEmbedded;
        @CommandLine.Option(names={"--no_smart_unpack"}, description={"Disable 'smart' extracting of embedded files.", "Smart extracting automatically skips all files generated by vbsp, that are only relevant to running the map in the engine."})
        private boolean noSmartUnpack;

        private MiscellaneousOptions() {
            this.sourceFormat = BspSourceCliCommand.INITIAL_CONFIG.sourceFormat;
        }
    }
}

