/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src;

import info.ata4.bspsrc.decompiler.BspSourceConfig;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class ObservableBspSourceConfig {
    private final Set<Runnable> listeners = new HashSet<Runnable>();
    private BspSourceConfig config;

    public ObservableBspSourceConfig(BspSourceConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    public void addListener(Runnable runnable) {
        this.listeners.add(runnable);
    }

    public void setConfig(BspSourceConfig config) {
        this.config = Objects.requireNonNull(config);
        this.listeners.forEach(Runnable::run);
    }

    public void updateConfig(Consumer<BspSourceConfig> consumer) {
        consumer.accept(this.config);
        this.listeners.forEach(Runnable::run);
    }

    public <T> T get(Function<BspSourceConfig, T> getter) {
        return getter.apply(this.config);
    }

    public BspSourceConfig getCopy() {
        return new BspSourceConfig(this.config);
    }
}

