/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.info.gui.panel;

import info.ata4.bspsrc.app.info.gui.Util;
import info.ata4.bspsrc.app.info.gui.models.BspInfoModel;
import info.ata4.bspsrc.app.util.swing.GridBagConstraintsBuilder;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.decompiler.modules.BspProtection;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProtectionPanel
extends JPanel {
    public final JCheckBox chkEntityFlag = Util.createDisplayCheckbox();
    public final JCheckBox chkTextureFlag = Util.createDisplayCheckbox();
    public final JCheckBox chkProtectorBrush = Util.createDisplayCheckbox();
    public final JCheckBox chkEntityObfuscation = Util.createDisplayCheckbox();
    public final JCheckBox chkNodrawTextureHack = Util.createDisplayCheckbox();
    public final JCheckBox chkBspProtect = Util.createDisplayCheckbox();

    public ProtectionPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder builder = new GridBagConstraintsBuilder().insets(Util.PANEL_COMPONENT_INSETS).weightX(1).fill(GridBagConstraintsBuilder.Fill.BOTH);
        this.add((Component)this.createVmexPanel(), builder.position(0, 0).build());
        this.add((Component)this.createIidPanel(), builder.position(0, 1).build());
        this.add((Component)this.createOtherPanel(), builder.position(0, 2).build());
    }

    private JPanel createVmexPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(Util.createPanelBorder("VMEX"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder builder = new GridBagConstraintsBuilder().insets(Util.PANEL_COMPONENT_INSETS);
        panel.add(Box.createGlue(), builder.position(0, 0).weightX(1).build());
        panel.add((Component)new JLabel("Entity flag"), builder.position(1, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.chkEntityFlag, builder.position(2, 0).build());
        panel.add((Component)new JLabel("Texture flag"), builder.position(1, 1).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.chkTextureFlag, builder.position(2, 1).build());
        panel.add((Component)new JLabel("Protector brush"), builder.position(1, 2).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.chkProtectorBrush, builder.position(2, 2).build());
        return panel;
    }

    private JPanel createIidPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(Util.createPanelBorder("IID"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder builder = new GridBagConstraintsBuilder().insets(Util.PANEL_COMPONENT_INSETS).anchor(GridBagConstraintsBuilder.Anchor.LINE_END);
        panel.add(Box.createGlue(), builder.position(0, 0).weightX(1).build());
        panel.add((Component)new JLabel("Entity obfuscation"), builder.position(1, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.chkEntityObfuscation, builder.position(2, 0).build());
        panel.add((Component)new JLabel("Nodraw texture hack"), builder.position(1, 1).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.chkNodrawTextureHack, builder.position(2, 1).build());
        return panel;
    }

    private JPanel createOtherPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(Util.createPanelBorder("Other"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder builder = new GridBagConstraintsBuilder().insets(Util.PANEL_COMPONENT_INSETS).anchor(GridBagConstraintsBuilder.Anchor.LINE_END);
        panel.add(Box.createGlue(), builder.position(0, 0).weightX(1).build());
        panel.add((Component)new JLabel("BSPProtect"), builder.position(1, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.chkBspProtect, builder.position(2, 0).build());
        return panel;
    }

    public void update(BspInfoModel model) {
        this.updateVmex(model);
        this.updateIid(model);
        this.updateOther(model);
    }

    private void updateVmex(BspInfoModel model) {
        this.chkEntityFlag.setSelected(model.getProt().map(BspProtection::hasEntityFlag).orElse(false));
        this.chkTextureFlag.setSelected(model.getProt().map(BspProtection::hasTextureFlag).orElse(false));
        this.chkProtectorBrush.setSelected(model.getProt().map(BspProtection::hasBrushFlag).orElse(false));
    }

    private void updateIid(BspInfoModel model) {
        this.chkEntityObfuscation.setSelected(model.getProt().map(BspProtection::hasObfuscatedEntities).orElse(false));
        this.chkNodrawTextureHack.setSelected(model.getProt().map(BspProtection::hasModifiedTexinfo).orElse(false));
    }

    private void updateOther(BspInfoModel model) {
        this.chkBspProtect.setSelected(model.getProt().map(BspProtection::hasEncryptedEntities).orElse(false));
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new ProtectionPanel());
    }
}

