/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.info.gui.panel;

import info.ata4.bspsrc.app.info.gui.data.LumpInfo;
import info.ata4.bspsrc.app.info.gui.models.BspInfoModel;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.app.util.swing.model.ReadonlyListTableModel;
import info.ata4.bspsrc.app.util.swing.renderer.ByteSizeCellRenderer;
import info.ata4.bspsrc.app.util.swing.renderer.ProgressCellRenderer;
import info.ata4.bspsrc.lib.lump.LumpType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class LumpsPanel
extends JPanel {
    private final JTable tblLumps = new JTable();
    private final ReadonlyListTableModel<LumpInfo> tableModel = new ReadonlyListTableModel(List.of(new ReadonlyListTableModel.Column<LumpInfo, Integer>("ID", Integer.class, LumpInfo::id), new ReadonlyListTableModel.Column<LumpInfo, String>("Name", String.class, LumpInfo::name), new ReadonlyListTableModel.Column<LumpInfo, Integer>("Size", Integer.class, LumpInfo::size), new ReadonlyListTableModel.Column<LumpInfo, Integer>("Size usage", Integer.class, LumpInfo::sizePercentage), new ReadonlyListTableModel.Column<LumpInfo, Integer>("Version", Integer.class, LumpInfo::version)));
    private final JButton btnExtract = new JButton("Extract");
    private final JButton btnExtractAll = new JButton("Extract all");

    public LumpsPanel(Consumer<Set<Integer>> onExtractLumps) {
        this.setLayout(new BorderLayout());
        this.tblLumps.setModel(this.tableModel);
        this.tblLumps.setAutoCreateRowSorter(true);
        this.tblLumps.getColumnModel().getColumn(2).setCellRenderer(new ByteSizeCellRenderer());
        this.tblLumps.getColumnModel().getColumn(3).setCellRenderer(new ProgressCellRenderer());
        GuiUtil.setColumnWidth(this.tblLumps, 0, Arrays.stream(LumpType.values()).map(LumpType::getIndex).max(Integer::compareTo).orElseThrow(), true, false);
        GuiUtil.setColumnWidth(this.tblLumps, 1, Arrays.stream(LumpType.values()).map(Enum::name).max(Comparator.comparingInt(String::length)).orElseThrow(), false, false);
        GuiUtil.setColumnWidth(this.tblLumps, 2, 100100, true, false);
        GuiUtil.setColumnWidth(this.tblLumps, 3, 100, true, false);
        GuiUtil.setColumnWidth(this.tblLumps, 4, 10, true, false);
        this.tblLumps.setPreferredScrollableViewportSize(new Dimension(this.tblLumps.getPreferredSize().width, -1));
        JScrollPane scrlTable = new JScrollPane(this.tblLumps, 20, 31);
        this.add((Component)scrlTable, "Center");
        this.btnExtract.addActionListener(e -> {
            Set lumpIndices = Arrays.stream(this.tblLumps.getSelectedRows()).map(this.tblLumps::convertRowIndexToModel).boxed().collect(Collectors.toSet());
            if (!lumpIndices.isEmpty()) {
                onExtractLumps.accept(lumpIndices);
            }
        });
        this.btnExtractAll.addActionListener(e -> {
            Set lumpIndices = IntStream.range(0, this.tblLumps.getModel().getRowCount()).boxed().collect(Collectors.toSet());
            onExtractLumps.accept(lumpIndices);
        });
        JPanel pnlButtons = new JPanel(new FlowLayout(3));
        pnlButtons.add(this.btnExtract);
        pnlButtons.add(this.btnExtractAll);
        this.add((Component)pnlButtons, "South");
    }

    public void update(BspInfoModel model) {
        this.tableModel.setData(model.getLumps());
        boolean buttonsEnabled = !model.getLumps().isEmpty();
        this.btnExtract.setEnabled(buttonsEnabled);
        this.btnExtractAll.setEnabled(buttonsEnabled);
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new LumpsPanel(indicies -> {}));
    }
}

