/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.info.gui.panel;

import info.ata4.bspsrc.app.info.gui.Util;
import info.ata4.bspsrc.app.info.gui.models.BspInfoModel;
import info.ata4.bspsrc.app.util.swing.GridBagConstraintsBuilder;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.app.util.swing.components.URILabel;
import info.ata4.bspsrc.decompiler.modules.BspCompileParams;
import info.ata4.bspsrc.lib.BspFile;
import info.ata4.bspsrc.lib.app.SourceAppDB;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.net.URI;
import java.nio.ByteOrder;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GeneralPanel
extends JPanel {
    public final JTextField txtName = Util.createDisplayTxtField(0);
    public final JTextField txtVersion = Util.createDisplayTxtField(3);
    public final JTextField txtRevision = Util.createDisplayTxtField(4);
    public final JTextField txtCompressed = Util.createDisplayTxtField(5);
    public final JTextField txtEndianness = Util.createDisplayTxtField(13);
    public final JTextField txtComment = Util.createDisplayTxtField(0);
    public final JTextField txtGameName = Util.createDisplayTxtField(0);
    public final JTextField txtAppId = Util.createDisplayTxtField(8);
    public final URILabel lblSteamLink = new URILabel();
    public final JTextField txtFileCrc = Util.createDisplayTxtField(8);
    public final JTextField txtMapCrc = Util.createDisplayTxtField(8);
    public final JTextField txtVbsp = Util.createDisplayTxtField(0);
    public final JTextField txtVvis = Util.createDisplayTxtField(0);
    public final JTextField txtVrad = Util.createDisplayTxtField(0);

    public GeneralPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder builder = new GridBagConstraintsBuilder().insets(Util.PANEL_COMPONENT_INSETS).weightX(1);
        this.add((Component)this.createHeadersPanel(), builder.position(0, 0).fill(GridBagConstraintsBuilder.Fill.BOTH).build());
        this.add((Component)this.createGamePanel(), builder.position(0, 1).fill(GridBagConstraintsBuilder.Fill.BOTH).build());
        this.add((Component)this.createChecksumsPanel(), builder.position(0, 2).fill(GridBagConstraintsBuilder.Fill.BOTH).build());
        this.add((Component)this.createCompilerParams(), builder.position(0, 3).fill(GridBagConstraintsBuilder.Fill.BOTH).build());
    }

    private JPanel createHeadersPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(Util.createPanelBorder("Headers"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder builder = new GridBagConstraintsBuilder().insets(Util.PANEL_COMPONENT_INSETS);
        panel.add((Component)new JLabel("Name"), builder.position(0, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtName, builder.position(1, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).width(4).weightX(1).fill(GridBagConstraintsBuilder.Fill.BOTH).build());
        panel.add((Component)new JLabel("Version"), builder.position(0, 1).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtVersion, builder.position(1, 1).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).fill(GridBagConstraintsBuilder.Fill.BOTH).build());
        panel.add((Component)new JLabel("Revision"), builder.position(2, 1).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtRevision, builder.position(3, 1).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).fill(GridBagConstraintsBuilder.Fill.BOTH).build());
        panel.add(Box.createGlue(), builder.position(4, 1).weightX(1).build());
        panel.add((Component)new JLabel("Compressed"), builder.position(0, 2).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtCompressed, builder.position(1, 2).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).fill(GridBagConstraintsBuilder.Fill.BOTH).build());
        panel.add((Component)new JLabel("Endianness"), builder.position(2, 2).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtEndianness, builder.position(3, 2).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).fill(GridBagConstraintsBuilder.Fill.BOTH).build());
        panel.add(Box.createGlue(), builder.position(4, 2).weightX(1).build());
        panel.add((Component)new JLabel("Comment"), builder.position(0, 3).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtComment, builder.position(1, 3).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).width(4).weightX(1).fill(GridBagConstraintsBuilder.Fill.BOTH).build());
        return panel;
    }

    private JPanel createGamePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(Util.createPanelBorder("Game"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder builder = new GridBagConstraintsBuilder().insets(Util.PANEL_COMPONENT_INSETS);
        panel.add((Component)new JLabel("Name"), builder.position(0, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtGameName, builder.position(1, 0).width(2).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).weightX(1).fill(GridBagConstraintsBuilder.Fill.HORIZONTAL).build());
        panel.add((Component)new JLabel("App-ID"), builder.position(0, 1).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtAppId, builder.position(1, 1).fill(GridBagConstraintsBuilder.Fill.HORIZONTAL).build());
        panel.add((Component)this.lblSteamLink, builder.position(2, 1).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).build());
        return panel;
    }

    private JPanel createChecksumsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(Util.createPanelBorder("Checksums"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder builder = new GridBagConstraintsBuilder().insets(Util.PANEL_COMPONENT_INSETS);
        panel.add((Component)new JLabel("File CRC"), builder.position(0, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtFileCrc, builder.position(1, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).build());
        panel.add((Component)new JLabel("Map CRC"), builder.position(2, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtMapCrc, builder.position(3, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).build());
        panel.add(Box.createGlue(), builder.position(4, 0).weightX(1).build());
        return panel;
    }

    private JPanel createCompilerParams() {
        JPanel panel = new JPanel();
        panel.setBorder(Util.createPanelBorder("Detected compile parameters"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder builder = new GridBagConstraintsBuilder().insets(Util.PANEL_COMPONENT_INSETS);
        panel.add((Component)new JLabel("vbsp"), builder.position(0, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtVbsp, builder.position(1, 0).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).weightX(1).fill(GridBagConstraintsBuilder.Fill.HORIZONTAL).build());
        panel.add((Component)new JLabel("vvis"), builder.position(0, 1).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtVvis, builder.position(1, 1).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).weightX(1).fill(GridBagConstraintsBuilder.Fill.HORIZONTAL).build());
        panel.add((Component)new JLabel("vrad"), builder.position(0, 2).anchor(GridBagConstraintsBuilder.Anchor.LINE_END).build());
        panel.add((Component)this.txtVrad, builder.position(1, 2).anchor(GridBagConstraintsBuilder.Anchor.LINE_START).weightX(1).fill(GridBagConstraintsBuilder.Fill.HORIZONTAL).build());
        return panel;
    }

    public void update(BspInfoModel model) {
        this.updateGeneral(model);
        this.updateGame(model);
        this.updateChecksums(model);
        this.updateCompileParameters(model);
    }

    private void updateGeneral(BspInfoModel model) {
        String comment = model.getBspData().flatMap(bspData -> bspData.entities.stream().findFirst()).map(entity -> entity.getValue("comment")).orElse("");
        this.txtName.setText(model.getBspFile().map(BspFile::getName).orElse(""));
        this.txtVersion.setText(model.getBspFile().map(BspFile::getVersion).map(Object::toString).orElse(""));
        this.txtRevision.setText(model.getBspFile().map(BspFile::getRevision).map(Object::toString).orElse(""));
        this.txtCompressed.setText(model.getBspFile().map(BspFile::isCompressed).map(bool -> bool != false ? "Yes" : "No").orElse(""));
        this.txtEndianness.setText(model.getBspFile().map(bspFile -> bspFile.getByteOrder() == ByteOrder.LITTLE_ENDIAN ? "Little endian" : "Big endian").orElse(null));
        this.txtComment.setText(comment);
    }

    private void updateGame(BspInfoModel model) {
        String gameName = model.getBspFile().map(bspFile -> SourceAppDB.getInstance().getName(bspFile.getAppId()).orElse("Unknown")).orElse("");
        this.txtGameName.setText(gameName);
        this.txtAppId.setText(model.getBspFile().map(BspFile::getAppId).map(Object::toString).orElse(""));
        model.getBspFile().ifPresentOrElse(bspFile -> this.lblSteamLink.setURI("Steam store link", SourceAppDB.getSteamStoreURI(bspFile.getAppId())), () -> this.lblSteamLink.setURI("", (URI)null));
    }

    private void updateChecksums(BspInfoModel model) {
        this.txtFileCrc.setText(model.getFileCrc().map(checksum -> String.format("%x", checksum)).orElse(""));
        this.txtMapCrc.setText(model.getMapCrc().map(checksum -> String.format("%x", checksum)).orElse(""));
    }

    private void updateCompileParameters(BspInfoModel model) {
        String vbsp = model.getCparams().map(BspCompileParams::getVbspParams).map(strings -> String.join((CharSequence)" ", strings)).orElse("");
        String vvis = model.getCparams().map(params -> params.isVvisRun() ? String.join((CharSequence)" ", params.getVvisParams()) : "").orElse("");
        String vrad = model.getCparams().map(params -> params.isVradRun() ? String.join((CharSequence)" ", params.getVradParams()) : "").orElse("");
        this.txtVbsp.setText(vbsp);
        this.txtVvis.setText(vvis);
        this.txtVrad.setText(vrad);
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new GeneralPanel());
    }
}

