/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.info.gui.panel;

import info.ata4.bspsrc.app.info.gui.Util;
import info.ata4.bspsrc.app.info.gui.models.BspInfoModel;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.app.util.swing.model.ReadonlyListTableModel;
import info.ata4.bspsrc.lib.entity.Entity;
import info.ata4.bspsrc.lib.struct.BspData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class EntitiesPanel
extends JPanel {
    public final JTextField txtPoint = Util.createDisplayTxtField(2);
    public final JTextField txtBrush = Util.createDisplayTxtField(2);
    public final JTextField txtTotal = Util.createDisplayTxtField(2);
    public final JTable tblEntities = new JTable();
    public final ReadonlyListTableModel<EntityInfo> tableModel = new ReadonlyListTableModel(List.of(new ReadonlyListTableModel.Column<EntityInfo, String>("Class", String.class, EntityInfo::className), new ReadonlyListTableModel.Column<EntityInfo, Long>("Count", Long.class, EntityInfo::occurrences)));

    public EntitiesPanel() {
        this.setLayout(new BorderLayout());
        JPanel pnlHeader = new JPanel(new FlowLayout(3));
        pnlHeader.add(new JLabel("Point"));
        pnlHeader.add(this.txtPoint);
        pnlHeader.add(new JLabel("Brush"));
        pnlHeader.add(this.txtBrush);
        pnlHeader.add(new JLabel("Total"));
        pnlHeader.add(this.txtTotal);
        this.add((Component)pnlHeader, "North");
        this.tblEntities.setModel(this.tableModel);
        this.tblEntities.setAutoCreateRowSorter(true);
        GuiUtil.setColumnWidth(this.tblEntities, 0, "-".repeat(20), false, false);
        GuiUtil.setColumnWidth(this.tblEntities, 1, 100, true, false);
        JScrollPane scrlTable = new JScrollPane(this.tblEntities, 20, 31);
        this.add((Component)scrlTable, "Center");
    }

    public void update(BspInfoModel model) {
        BspData bspData = model.getBspData().orElse(null);
        if (bspData != null) {
            long brushEntsCount = bspData.entities.stream().filter(entity -> entity.getModelNum() > 0).count();
            long pointEntsCount = (long)bspData.entities.size() - brushEntsCount;
            this.txtPoint.setText("%,d".formatted(pointEntsCount));
            this.txtBrush.setText("%,d".formatted(brushEntsCount));
            this.txtTotal.setText("%,d".formatted(bspData.entities.size()));
            this.tableModel.setData(bspData.entities.stream().collect(Collectors.groupingBy(Entity::getClassName, Collectors.counting())).entrySet().stream().map(entry -> new EntityInfo((String)entry.getKey(), (Long)entry.getValue())).toList());
        } else {
            this.txtPoint.setText("");
            this.txtBrush.setText("");
            this.txtTotal.setText("");
            this.tableModel.setData(List.of());
        }
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new EntitiesPanel());
    }

    public record EntityInfo(String className, long occurrences) {
    }
}

