/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.info.gui.panel;

import info.ata4.bspsrc.app.info.gui.models.BspInfoModel;
import info.ata4.bspsrc.decompiler.modules.BspDependencies;
import java.awt.Font;
import java.util.Optional;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class DependenciesPanel
extends JTabbedPane {
    public final JTextArea txtMaterials = new JTextArea(5, 20);
    public final JTextArea txtSounds = new JTextArea(5, 20);
    public final JTextArea txtSoundScripts = new JTextArea(5, 20);
    public final JTextArea txtSoundscapes = new JTextArea(5, 20);
    public final JTextArea txtModels = new JTextArea(5, 20);
    public final JTextArea txtParticles = new JTextArea(5, 20);

    public DependenciesPanel() {
        Font font = new Font("Monospaced", 0, 12);
        this.txtMaterials.setEditable(false);
        this.txtSounds.setEditable(false);
        this.txtSoundScripts.setEditable(false);
        this.txtSoundscapes.setEditable(false);
        this.txtModels.setEditable(false);
        this.txtParticles.setEditable(false);
        this.txtMaterials.setFont(font);
        this.txtSounds.setFont(font);
        this.txtSoundScripts.setFont(font);
        this.txtSoundscapes.setFont(font);
        this.txtModels.setFont(font);
        this.txtParticles.setFont(font);
        this.addTab("Materials", new JScrollPane(this.txtMaterials, 20, 31));
        this.addTab("Sounds", new JScrollPane(this.txtSounds, 20, 31));
        this.addTab("Sound scripts", new JScrollPane(this.txtSoundScripts, 20, 31));
        this.addTab("Soundscapes", new JScrollPane(this.txtSoundscapes, 20, 31));
        this.addTab("Models", new JScrollPane(this.txtModels, 20, 31));
        this.addTab("Particles", new JScrollPane(this.txtParticles, 20, 31));
    }

    public void update(BspInfoModel model) {
        this.txtMaterials.setText(DependenciesPanel.optionalSetToString(model.getBspres().map(BspDependencies::getMaterials)));
        this.txtSounds.setText(DependenciesPanel.optionalSetToString(model.getBspres().map(BspDependencies::getSoundFiles)));
        this.txtSoundScripts.setText(DependenciesPanel.optionalSetToString(model.getBspres().map(BspDependencies::getSoundScripts)));
        this.txtSoundscapes.setText(DependenciesPanel.optionalSetToString(model.getBspres().map(BspDependencies::getSoundscapes)));
        this.txtModels.setText(DependenciesPanel.optionalSetToString(model.getBspres().map(BspDependencies::getModels)));
        this.txtParticles.setText(DependenciesPanel.optionalSetToString(model.getBspres().map(BspDependencies::getParticles)));
    }

    private static String optionalSetToString(Optional<Set<String>> set) {
        return set.map(strings -> String.join((CharSequence)"\n", strings)).orElse("");
    }
}

