/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.info.gui.models;

import info.ata4.bspsrc.app.info.BspFileUtils;
import info.ata4.bspsrc.app.info.gui.data.EmbeddedInfo;
import info.ata4.bspsrc.app.info.gui.data.GameLumpInfo;
import info.ata4.bspsrc.app.info.gui.data.LumpInfo;
import info.ata4.bspsrc.decompiler.modules.BspChecksum;
import info.ata4.bspsrc.decompiler.modules.BspCompileParams;
import info.ata4.bspsrc.decompiler.modules.BspDependencies;
import info.ata4.bspsrc.decompiler.modules.BspProtection;
import info.ata4.bspsrc.decompiler.modules.geom.BrushBounds;
import info.ata4.bspsrc.decompiler.modules.texture.TextureSource;
import info.ata4.bspsrc.decompiler.util.WindingFactory;
import info.ata4.bspsrc.lib.BspFile;
import info.ata4.bspsrc.lib.BspFileReader;
import info.ata4.bspsrc.lib.exceptions.BspException;
import info.ata4.bspsrc.lib.lump.AbstractLump;
import info.ata4.bspsrc.lib.lump.GameLump;
import info.ata4.bspsrc.lib.lump.Lump;
import info.ata4.bspsrc.lib.struct.BspData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BspInfoModel {
    private static final Logger L = LogManager.getLogger();
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private final WindingFactory windingFactory = new WindingFactory();
    private final BrushBounds brushBounds = new BrushBounds(this.windingFactory);
    private BspFile bspFile;
    private BspData bspData;
    private BspCompileParams cparams;
    private BspProtection prot;
    private BspDependencies bspres;
    private Long fileCrc;
    private Long mapCrc;
    private List<LumpInfo> lumps = List.of();
    private List<GameLumpInfo> gameLumps = List.of();
    private List<EmbeddedInfo> embeddedInfos = List.of();

    public void load(Path filePath) throws BspException, IOException {
        this.bspFile = new BspFile();
        this.bspFile.load(filePath);
        int lumpSizeSum = this.bspFile.getLumps().stream().mapToInt(AbstractLump::getLength).sum();
        this.lumps = this.bspFile.getLumps().stream().map(lump -> new LumpInfo(lump.getIndex(), lump.getName(), lump.getLength(), (int)Math.round((double)lump.getLength() * 100.0 / (double)lumpSizeSum), lump.getVersion())).toList();
        int gameLumpSizeSum = this.bspFile.getGameLumps().stream().mapToInt(AbstractLump::getLength).sum();
        this.gameLumps = this.bspFile.getGameLumps().stream().map(lump -> new GameLumpInfo(lump.getName(), lump.getLength(), (int)Math.round((double)lump.getLength() * 100.0 / (double)gameLumpSizeSum), lump.getVersion())).toList();
        BspFileReader bspReader = new BspFileReader(this.bspFile);
        bspReader.loadEntities();
        this.bspData = bspReader.getData();
        this.cparams = new BspCompileParams(bspReader);
        TextureSource texsrc = new TextureSource(bspReader);
        this.prot = new BspProtection(bspReader, this.brushBounds, texsrc);
        this.prot.check();
        this.bspres = new BspDependencies(bspReader);
        BspChecksum checksum = new BspChecksum(bspReader);
        this.fileCrc = checksum.getFileCRC();
        this.mapCrc = checksum.getMapCRC();
        try (ZipFile zip = this.bspFile.getPakFile().getZipFile();){
            ArrayList<EmbeddedInfo> files = new ArrayList<EmbeddedInfo>();
            Enumeration<ZipArchiveEntry> enumeration = zip.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipArchiveEntry ze = enumeration.nextElement();
                files.add(new EmbeddedInfo(ze.getName(), ze.getSize()));
            }
            this.embeddedInfos = files;
        }
        catch (IOException ex) {
            L.warn("Can't read pak");
        }
        this.listeners.forEach(Runnable::run);
    }

    public void extractLumps(Set<Integer> lumpIndices, Path lumpsDst) throws IOException {
        for (int lumpIndex : lumpIndices) {
            Lump lump = this.bspFile.getLumps().get(lumpIndex);
            BspFileUtils.extractLump(lump, lumpsDst);
        }
    }

    public void extractGameLumps(Set<Integer> lumpIndices, Path lumpsDst) throws IOException {
        for (int lumpIndex : lumpIndices) {
            GameLump lump = this.bspFile.getGameLumps().get(lumpIndex);
            BspFileUtils.extractGameLump(lump, lumpsDst);
        }
    }

    public void extractEmbeddedFiles(Set<Integer> fileIndices, Path filesDst) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        try (ZipFile zip = this.bspFile.getPakFile().getZipFile();){
            Enumeration<ZipArchiveEntry> enumeration = zip.getEntries();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                ZipArchiveEntry ze = enumeration.nextElement();
                if (fileIndices.contains(i)) {
                    fileNames.add(ze.getName());
                }
                ++i;
            }
        }
        this.bspFile.getPakFile().unpack(filesDst, fileNames::contains);
    }

    public void extractEmbeddedFilesRaw(Path filesDst) throws IOException {
        this.bspFile.getPakFile().unpack(filesDst, true);
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public Optional<BspFile> getBspFile() {
        return Optional.ofNullable(this.bspFile);
    }

    public Optional<BspData> getBspData() {
        return Optional.ofNullable(this.bspData);
    }

    public Optional<BspCompileParams> getCparams() {
        return Optional.ofNullable(this.cparams);
    }

    public Optional<BspProtection> getProt() {
        return Optional.ofNullable(this.prot);
    }

    public Optional<BspDependencies> getBspres() {
        return Optional.ofNullable(this.bspres);
    }

    public Optional<Long> getFileCrc() {
        return Optional.ofNullable(this.fileCrc);
    }

    public Optional<Long> getMapCrc() {
        return Optional.ofNullable(this.mapCrc);
    }

    public List<LumpInfo> getLumps() {
        return this.lumps;
    }

    public List<GameLumpInfo> getGameLumps() {
        return this.gameLumps;
    }

    public List<EmbeddedInfo> getEmbeddedInfos() {
        return this.embeddedInfos;
    }
}

