/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.info.gui;

import info.ata4.bspsrc.app.info.gui.Util;
import info.ata4.bspsrc.app.info.gui.models.BspInfoModel;
import info.ata4.bspsrc.app.info.gui.panel.DependenciesPanel;
import info.ata4.bspsrc.app.info.gui.panel.EmbeddedPanel;
import info.ata4.bspsrc.app.info.gui.panel.EntitiesPanel;
import info.ata4.bspsrc.app.info.gui.panel.GameLumpsPanel;
import info.ata4.bspsrc.app.info.gui.panel.GeneralPanel;
import info.ata4.bspsrc.app.info.gui.panel.LumpsPanel;
import info.ata4.bspsrc.app.info.gui.panel.ProtectionPanel;
import info.ata4.bspsrc.app.util.log.Log4jUtil;
import info.ata4.bspsrc.app.util.log.plugins.DialogAppender;
import info.ata4.bspsrc.app.util.swing.FileExtensionFilter;
import info.ata4.bspsrc.app.util.swing.GridBagConstraintsBuilder;
import info.ata4.bspsrc.lib.exceptions.BspException;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BspInfoFrame
extends JFrame {
    private static final Logger L = LogManager.getLogger();
    public static final String NAME = "BSPInfo";
    public static final String VERSION = "1.4.4";
    private final BspInfoModel model;
    private final JFileChooser fileChooser = new JFileChooser();
    private final JFileChooser lumpDstChooser = new JFileChooser();
    private final JFileChooser embeddedFileDstChooser = new JFileChooser();
    private final JFileChooser embeddedRawDstChooser = new JFileChooser();
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final GeneralPanel generalPanel = new GeneralPanel();
    private final LumpsPanel lumpsPanel = new LumpsPanel(this::extractLumps);
    private final GameLumpsPanel gameLumpsPanel = new GameLumpsPanel(this::extractGameLumps);
    private final EntitiesPanel entitiesPanel = new EntitiesPanel();
    private final DependenciesPanel dependenciesPanel = new DependenciesPanel();
    private final EmbeddedPanel embeddedPanel = new EmbeddedPanel(this::extractFiles, this::extractFilesRaw);
    private final ProtectionPanel protectionPanel = new ProtectionPanel();

    public BspInfoFrame(BspInfoModel model) {
        this.model = model;
        model.addListener(this::onChanges);
        this.initErrorDialog();
        this.fileChooser.setFileFilter(new FileExtensionFilter("Source engine map file", "bsp"));
        this.lumpDstChooser.setFileSelectionMode(1);
        this.embeddedFileDstChooser.setFileSelectionMode(1);
        this.embeddedRawDstChooser.setAcceptAllFileFilterUsed(false);
        this.embeddedRawDstChooser.setFileFilter(new FileExtensionFilter("Zip file", "zip"));
        Border tabbedPanePaddingBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        JPanel wrappedGeneralPanel = Util.wrapWithAlign(this.generalPanel, GridBagConstraintsBuilder.Anchor.PAGE_START, GridBagConstraintsBuilder.Fill.HORIZONTAL);
        JPanel wrappedProtectionPanel = Util.wrapWithAlign(this.protectionPanel, GridBagConstraintsBuilder.Anchor.FIRST_LINE_START, GridBagConstraintsBuilder.Fill.NONE);
        wrappedGeneralPanel.setBorder(tabbedPanePaddingBorder);
        this.lumpsPanel.setBorder(BorderFactory.createCompoundBorder(tabbedPanePaddingBorder, this.lumpsPanel.getBorder()));
        this.gameLumpsPanel.setBorder(BorderFactory.createCompoundBorder(tabbedPanePaddingBorder, this.gameLumpsPanel.getBorder()));
        this.entitiesPanel.setBorder(BorderFactory.createCompoundBorder(tabbedPanePaddingBorder, this.entitiesPanel.getBorder()));
        this.dependenciesPanel.setBorder(BorderFactory.createCompoundBorder(tabbedPanePaddingBorder, this.dependenciesPanel.getBorder()));
        this.embeddedPanel.setBorder(BorderFactory.createCompoundBorder(tabbedPanePaddingBorder, this.embeddedPanel.getBorder()));
        wrappedProtectionPanel.setBorder(tabbedPanePaddingBorder);
        this.tabbedPane.addTab("General", wrappedGeneralPanel);
        this.tabbedPane.addTab("Lumps", this.lumpsPanel);
        this.tabbedPane.addTab("Game lumps", this.gameLumpsPanel);
        this.tabbedPane.addTab("Entities", this.entitiesPanel);
        this.tabbedPane.addTab("Dependencies", this.dependenciesPanel);
        this.tabbedPane.addTab("Embedded files", this.embeddedPanel);
        this.tabbedPane.addTab("Protection", wrappedProtectionPanel);
        this.setContentPane(this.tabbedPane);
        this.initMenuBar();
        this.initTransferHandler();
        this.onChanges();
        this.setTitle("BSPInfo 1.4.4");
        URL iconUrl = Objects.requireNonNull(this.getClass().getResource("resources/icon.png"));
        Image icon = Toolkit.getDefaultToolkit().createImage(iconUrl);
        this.setIconImage(icon);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setDefaultCloseOperation(2);
    }

    private void initErrorDialog() {
        DialogAppender dialogAppender = DialogAppender.createAppender("DialogAppender" + this.hashCode(), null, null, false, this);
        final Log4jUtil.CloseableScope appenderCloseable = Log4jUtil.addAppenders(dialogAppender);
        this.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosed(WindowEvent e) {
                appenderCloseable.close();
            }
        });
    }

    private void initMenuBar() {
        JMenuItem menuItemOpenFile = new JMenuItem("Open");
        menuItemOpenFile.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        menuItemOpenFile.addActionListener(e -> {
            int result = this.fileChooser.showOpenDialog(this);
            if (result != 0) {
                return;
            }
            this.lumpDstChooser.setCurrentDirectory(this.fileChooser.getCurrentDirectory());
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.model.load(this.fileChooser.getSelectedFile().toPath());
            }
            catch (BspException | IOException ex) {
                L.error("Error occurred loading file", (Throwable)ex);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        });
        JMenu menuFile = new JMenu("File");
        menuFile.add(menuItemOpenFile);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menuFile);
        this.setJMenuBar(menuBar);
    }

    private void initTransferHandler() {
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return Arrays.stream(support.getDataFlavors()).anyMatch(DataFlavor::isFlavorJavaFileListType);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                try {
                    List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    BspInfoFrame.this.model.load(((File)files.get(files.size() - 1)).toPath());
                    return true;
                }
                catch (BspException | UnsupportedFlavorException | IOException e) {
                    L.warn("Error in drag and drop", (Throwable)e);
                    return false;
                }
            }
        });
    }

    private void onChanges() {
        this.generalPanel.update(this.model);
        this.lumpsPanel.update(this.model);
        this.gameLumpsPanel.update(this.model);
        this.entitiesPanel.update(this.model);
        this.dependenciesPanel.update(this.model);
        this.embeddedPanel.update(this.model);
        this.protectionPanel.update(this.model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractLumps(Set<Integer> lumpIndices) {
        Path lumpDst = this.chooseDstDialog(this.lumpDstChooser);
        if (lumpDst == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.model.extractLumps(lumpIndices, lumpDst);
        }
        catch (IOException e) {
            L.error("Error occurred extracting lump(s)", (Throwable)e);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        JOptionPane.showMessageDialog(this, "Successfully extracted lump(s).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractGameLumps(Set<Integer> lumpIndices) {
        Path lumpDst = this.chooseDstDialog(this.lumpDstChooser);
        if (lumpDst == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.model.extractGameLumps(lumpIndices, lumpDst);
        }
        catch (IOException e) {
            L.error("Error occurred extracting game lump(s)", (Throwable)e);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        JOptionPane.showMessageDialog(this, "Successfully extracted game lump(s).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFiles(Set<Integer> fileIndices) {
        Path filesDst = this.chooseDstDialog(this.embeddedFileDstChooser);
        if (filesDst == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.model.extractEmbeddedFiles(fileIndices, filesDst);
        }
        catch (IOException e) {
            L.error("Error occurred extracting embedded file(s)", (Throwable)e);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        JOptionPane.showMessageDialog(this, "Successfully extracted embedded file(s).");
    }

    private void extractFilesRaw() {
        Path filesDst = this.chooseDstDialog(this.embeddedRawDstChooser);
        if (filesDst == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.model.extractEmbeddedFilesRaw(filesDst);
        }
        catch (IOException e) {
            L.error("Error occurred extracting embedded files", (Throwable)e);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        JOptionPane.showMessageDialog(this, "Successfully extracted embedded files.");
    }

    private Path chooseDstDialog(JFileChooser fileChooser) {
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            return fileChooser.getSelectedFile().toPath();
        }
        return null;
    }
}

