/*
 * Decompiled with CFR 0.152.
 */
package unmap;

import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import unmap.Brush;
import unmap.Brushside;
import unmap.Cons;
import unmap.Cubemap;
import unmap.Dispinfo;
import unmap.Dispvert;
import unmap.Entity;
import unmap.Face;
import unmap.GLump;
import unmap.Leaf;
import unmap.Lump;
import unmap.Model;
import unmap.Node;
import unmap.Overlay;
import unmap.Plane;
import unmap.Pstatic;
import unmap.Texdata;
import unmap.Texinfo;
import unmap.Texture;
import unmap.Treelimit;
import unmap.Vec;
import unmap.Wind;

public class BSP {
    int ident;
    int version;
    Lump[] lump;
    int maprev;
    boolean no_decomp = false;
    int verts;
    float[] x;
    float[] y;
    float[] z;
    boolean[] o;
    int edges;
    int[] vi1;
    int[] vi2;
    byte[] eim;
    boolean[] t;
    int surfedges;
    int[] sedge;
    int faces;
    Face[] face;
    int models;
    Model[] mod;
    int entities;
    Entity[] ent;
    int ofaces;
    Face[] oface;
    Wind[] owind;
    int nodes;
    Node[] node;
    int leaves;
    Leaf[] leaf;
    int lfaces;
    int[] lface;
    int lbrushes;
    int[] lbrush;
    int texinfos;
    Texinfo[] tx;
    int texdatas;
    Texdata[] td;
    int tdsts;
    int[] tdst;
    int tdsds;
    byte[] tdsd;
    String[] texname;
    int[] texenv;
    int propstatics;
    Pstatic[] ps;
    int psnames;
    String[] psname;
    int glumps;
    GLump[] gl;
    int cubemaps;
    Cubemap[] cm;
    int dispinfos;
    Dispinfo[] dinfo;
    int dispverts;
    Dispvert[] dv;
    int disptris;
    int[] dtri;
    int planes;
    Plane[] pl;
    int brushes;
    Brush[] br;
    int brushsides;
    Brushside[] bsd;
    Wind[] bwind;
    int overlays;
    Overlay[] ov;

    public void loadmap(ByteBuffer b) {
        Cons.println("Header");
        this.loadheader(b);
        Cons.print("Vertexes ");
        this.loadverts(b);
        Cons.print("Edges ");
        this.loadedges(b);
        Cons.print("Faces ");
        this.loadfaces(b);
        Cons.print("Orig faces ");
        this.loadorigfaces(b);
        Cons.print("Models ");
        this.loadmodels(b);
        Cons.print("Surfedges ");
        this.loadsurfedges(b);
        Cons.println("Marks");
        this.markedges();
        Cons.print("Texinfo ");
        this.loadtexinfos(b);
        Cons.print("Texdata ");
        this.loadtexdatas(b);
        Cons.println("Texdata string data");
        this.loadtdsd(b);
        Cons.print("Texdata string table ");
        this.loadtdst(b);
        Cons.print("Entities ");
        this.loadentities(b);
        this.transmodels();
        this.loadgamelumpheader(b);
        Cons.print("Prop_statics ");
        this.loadstatics(b);
        Cons.print("Cubemaps ");
        this.loadcubemaps(b);
        Cons.print("Planes ");
        this.loadplanes(b);
        Cons.print("Brushes ");
        this.loadbrushes(b);
        Cons.print("Brushsides ");
        this.loadbrushsides(b);
        Cons.print("Dispinfo ");
        this.loaddispinfo(b);
        Cons.print("Dispverts ");
        this.loaddispverts(b);
        Cons.print("Disptris ");
        this.loaddisptris(b);
        Cons.print("Nodes ");
        this.loadnodes(b);
        Cons.print("Leaves ");
        this.loadleaves(b);
        Cons.print("Leaf faces ");
        this.loadlfaces(b);
        Cons.print("Leaf brushes ");
        this.loadlbrushes(b);
        Cons.print("Overlays ");
        this.loadoverlays(b);
    }

    public void loadheader(ByteBuffer b) {
        b.position(0);
        this.ident = b.getInt();
        int idbsp = 1347633750;
        this.version = b.getInt();
        Cons.println("Ident: " + this.ident);
        Cons.println("Version: " + this.version);
        if (this.ident != idbsp || this.version != 20 && this.version != 19 && this.version != 17) {
            Cons.println("Unknown map file ident or version!");
            System.exit(1);
        }
        this.lump = new Lump[64];
        for (int i = 0; i < 64; ++i) {
            this.lump[i] = new Lump();
            this.lump[i].ofs = b.getInt();
            this.lump[i].len = b.getInt();
            this.lump[i].vers = b.getInt();
            this.lump[i].fourCC = b.getInt();
            if (this.lump[i].len <= 0) continue;
            Cons.print("Lump " + i + ": ");
            Cons.print(this.lump[i].ofs + ", " + this.lump[i].len + ", " + this.lump[i].vers + ", " + this.lump[i].fourCC);
            Cons.println(" " + Lump.name(i) + "  " + this.lump[i].len / Lump.size(i) + (Lump.size(i) == 1 ? " bytes" : ""));
        }
        this.maprev = b.getInt();
        Cons.println("MapRev: " + this.maprev);
    }

    public int sefix(int edge) {
        int iedge = this.sedge[edge];
        if (iedge < 0) {
            iedge = -iedge;
        }
        return iedge;
    }

    public void loadplanes(ByteBuffer b) {
        b.position(this.lump[1].ofs);
        this.planes = this.lump[1].len / Lump.size(1);
        this.pl = new Plane[this.planes];
        for (int i = 0; i < this.planes; ++i) {
            this.pl[i] = new Plane();
            this.pl[i].nx = b.getFloat();
            this.pl[i].ny = b.getFloat();
            this.pl[i].nz = b.getFloat();
            this.pl[i].dist = b.getFloat();
            this.pl[i].type = b.getInt();
        }
        Cons.println(this.planes);
    }

    public void loadbrushes(ByteBuffer b) {
        b.position(this.lump[18].ofs);
        this.brushes = this.lump[18].len / Lump.size(18);
        this.br = new Brush[this.brushes];
        for (int i = 0; i < this.brushes; ++i) {
            this.br[i] = new Brush();
            this.br[i].fstside = b.getInt();
            this.br[i].numside = b.getInt();
            this.br[i].contents = b.getInt();
        }
        Cons.println(this.brushes);
    }

    public void loadbrushsides(ByteBuffer b) {
        b.position(this.lump[19].ofs);
        this.brushsides = this.lump[19].len / Lump.size(19);
        this.bsd = new Brushside[this.brushsides];
        for (int i = 0; i < this.brushsides; ++i) {
            this.bsd[i] = new Brushside();
            this.bsd[i].pnum = 0xFFFF & b.getShort();
            this.bsd[i].texinfo = b.getShort();
            this.bsd[i].dispinfo = b.getShort();
            this.bsd[i].bevel = b.getShort();
        }
        Cons.println(this.brushsides);
    }

    public void loadverts(ByteBuffer b) {
        float M;
        b.position(this.lump[3].ofs);
        this.verts = this.lump[3].len / Lump.size(3);
        this.x = new float[this.verts];
        this.y = new float[this.verts];
        this.z = new float[this.verts];
        this.o = new boolean[this.verts];
        float xmin = M = 1000000.0f;
        float xmax = -M;
        float ymin = M;
        float ymax = -M;
        float zmin = M;
        float zmax = -M;
        for (int i = 0; i < this.verts; ++i) {
            this.x[i] = b.getFloat();
            xmin = Math.min(this.x[i], xmin);
            xmax = Math.max(this.x[i], xmax);
            this.y[i] = b.getFloat();
            ymin = Math.min(this.y[i], ymin);
            ymax = Math.max(this.y[i], ymax);
            this.z[i] = b.getFloat();
            zmin = Math.min(this.z[i], zmin);
            zmax = Math.max(this.z[i], zmax);
            this.o[i] = false;
        }
        Cons.println(this.verts);
        Cons.println("Min/Max: (" + xmin + ", " + ymin + ", " + zmin + ") - (" + xmax + ", " + ymax + ", " + zmax + ")");
    }

    public void loadedges(ByteBuffer b) {
        b.position(this.lump[12].ofs);
        this.edges = this.lump[12].len / Lump.size(12);
        this.vi1 = new int[this.edges];
        this.vi2 = new int[this.edges];
        this.eim = new byte[this.edges];
        this.t = new boolean[this.edges];
        int vmax = 0;
        for (int i = 0; i < this.edges; ++i) {
            this.vi1[i] = 0xFFFF & b.getShort();
            vmax = Math.max(this.vi1[i], vmax);
            this.vi2[i] = 0xFFFF & b.getShort();
            vmax = Math.max(this.vi2[i], vmax);
            this.eim[i] = 0;
            this.t[i] = false;
        }
        if (vmax > this.verts) {
            Cons.println("Vertex index to high " + vmax + " > " + this.verts);
            return;
        }
        Cons.println(this.edges);
    }

    public void loadfaces(ByteBuffer b) {
        b.position(this.lump[7].ofs);
        this.faces = this.lump[7].vers == 0 ? this.lump[7].len / 104 : this.lump[7].len / Lump.size(7);
        this.face = new Face[this.faces];
        for (int i = 0; i < this.faces; ++i) {
            int j;
            this.face[i] = new Face();
            if (this.lump[7].vers == 0) {
                for (j = 0; j < 32; ++j) {
                    b.get();
                }
            }
            this.face[i].pnum = 0xFFFF & b.getShort();
            this.face[i].side = b.get();
            this.face[i].onnode = b.get();
            this.face[i].fstedge = b.getInt();
            this.face[i].numedge = b.getShort();
            this.face[i].texinfo = b.getShort();
            this.face[i].dispinfo = b.getShort();
            b.getShort();
            b.get();
            b.get();
            b.get();
            b.get();
            if (this.lump[7].vers == 0) {
                for (j = 0; j < 20; ++j) {
                    b.get();
                }
            }
            b.getInt();
            this.face[i].area = b.getFloat();
            b.getInt();
            b.getInt();
            b.getInt();
            b.getInt();
            this.face[i].orig = b.getInt();
            if (this.lump[7].vers == 1) {
                b.getShort();
                b.getShort();
            }
            this.face[i].smooth = b.getInt();
        }
        Cons.println(this.faces);
    }

    public void loadorigfaces(ByteBuffer b) {
        b.position(this.lump[27].ofs);
        this.ofaces = this.version == 19 || this.version == 20 ? this.lump[27].len / Lump.size(27) : this.lump[27].len / 104;
        this.oface = new Face[this.ofaces];
        for (int i = 0; i < this.ofaces; ++i) {
            int j;
            this.oface[i] = new Face();
            if (this.version == 17) {
                for (j = 0; j < 32; ++j) {
                    b.get();
                }
            }
            this.oface[i].pnum = 0xFFFF & b.getShort();
            this.oface[i].side = b.get();
            this.oface[i].onnode = b.get();
            this.oface[i].fstedge = b.getInt();
            this.oface[i].numedge = b.getShort();
            this.oface[i].texinfo = b.getShort();
            this.oface[i].dispinfo = b.getShort();
            b.getShort();
            b.get();
            b.get();
            b.get();
            b.get();
            if (this.version == 17) {
                for (j = 0; j < 20; ++j) {
                    b.get();
                }
            }
            b.getInt();
            b.getFloat();
            this.oface[i].area = 0.0f;
            b.getInt();
            b.getInt();
            b.getInt();
            b.getInt();
            this.oface[i].orig = b.getInt();
            if (this.version == 19 || this.version == 20) {
                b.getShort();
                b.getShort();
            }
            this.oface[i].smooth = b.getInt();
        }
        Cons.println(this.ofaces);
    }

    public void loadmodels(ByteBuffer b) {
        b.position(this.lump[14].ofs);
        this.models = this.lump[14].len / Lump.size(14);
        this.mod = new Model[this.models];
        for (int i = 0; i < this.models; ++i) {
            this.mod[i] = new Model();
            b.getFloat();
            b.getFloat();
            b.getFloat();
            b.getFloat();
            b.getFloat();
            b.getFloat();
            b.getFloat();
            b.getFloat();
            b.getFloat();
            this.mod[i].headnode = b.getInt();
            this.mod[i].fstface = b.getInt();
            this.mod[i].numface = b.getInt();
        }
        Cons.println(this.models);
    }

    public void loadsurfedges(ByteBuffer b) {
        b.position(this.lump[13].ofs);
        this.surfedges = this.lump[13].len / Lump.size(13);
        this.sedge = new int[this.surfedges];
        for (int i = 0; i < this.surfedges; ++i) {
            this.sedge[i] = b.getInt();
        }
        Cons.println(this.surfedges);
    }

    public void loadgamelumpheader(ByteBuffer b) {
        b.position(this.lump[35].ofs);
        this.glumps = b.getInt();
        this.gl = new GLump[this.glumps];
        Cons.print(this.glumps + " game lumps: ");
        for (int i = 0; i < this.glumps; ++i) {
            this.gl[i] = new GLump();
            this.gl[i].id = b.getInt();
            this.gl[i].flags = b.getShort();
            this.gl[i].vers = b.getShort();
            this.gl[i].ofs = b.getInt();
            this.gl[i].len = b.getInt();
            char[] id = new char[]{(char)(0xFF & this.gl[i].id >> 24), (char)(0xFF & this.gl[i].id >> 16), (char)(0xFF & this.gl[i].id >> 8), (char)(0xFF & this.gl[i].id)};
            String sid = new String(id);
            Cons.print(sid + " ");
        }
        Cons.println();
    }

    public void loadstatics(ByteBuffer b) {
        int i;
        int spid = -1;
        for (int i2 = 0; i2 < this.glumps; ++i2) {
            if (this.gl[i2].id != 1936749168) continue;
            spid = i2;
        }
        if (spid < 0) {
            return;
        }
        b.position(this.gl[spid].ofs);
        int pslen = this.gl[spid].len;
        this.psnames = b.getInt();
        this.psname = new String[this.psnames];
        for (int i3 = 0; i3 < this.psnames; ++i3) {
            this.psname[i3] = this.readstr(b, 128);
        }
        int propleaves = b.getInt();
        for (i = 0; i < propleaves; ++i) {
            b.getShort();
        }
        this.propstatics = b.getInt();
        this.ps = new Pstatic[this.propstatics];
        for (i = 0; i < this.propstatics; ++i) {
            this.ps[i] = new Pstatic();
            this.ps[i].ox = b.getFloat();
            this.ps[i].oy = b.getFloat();
            this.ps[i].oz = b.getFloat();
            this.ps[i].ax = b.getFloat();
            this.ps[i].ay = b.getFloat();
            this.ps[i].az = b.getFloat();
            this.ps[i].type = b.getShort();
            b.getShort();
            b.getShort();
            this.ps[i].solid = b.get();
            this.ps[i].flags = b.get();
            this.ps[i].skin = b.getInt();
            this.ps[i].fademin = b.getFloat();
            this.ps[i].fademax = b.getFloat();
            b.getFloat();
            b.getFloat();
            b.getFloat();
            if (this.gl[spid].vers != 5) continue;
            b.getInt();
        }
        Cons.println(this.propstatics);
    }

    public void loadcubemaps(ByteBuffer b) {
        b.position(this.lump[42].ofs);
        this.cubemaps = this.lump[42].len / Lump.size(42);
        this.cm = new Cubemap[this.cubemaps];
        for (int i = 0; i < this.cubemaps; ++i) {
            this.cm[i] = new Cubemap();
            this.cm[i].x = b.getInt();
            this.cm[i].y = b.getInt();
            this.cm[i].z = b.getInt();
            this.cm[i].size = (byte)b.getInt();
        }
        Cons.println(this.cubemaps);
    }

    public void loaddispinfo(ByteBuffer b) {
        b.position(this.lump[26].ofs);
        this.dispinfos = this.lump[26].len / Lump.size(26);
        this.dinfo = new Dispinfo[this.dispinfos];
        for (int i = 0; i < this.dispinfos; ++i) {
            int j;
            Dispinfo di = new Dispinfo();
            di.sx = b.getFloat();
            di.sy = b.getFloat();
            di.sz = b.getFloat();
            di.ivert = b.getInt();
            di.itri = b.getInt();
            di.power = b.getInt();
            di.smoothangle = b.getFloat();
            di.contents = b.getInt();
            di.face = 0xFFFF & b.getShort();
            b.getShort();
            b.getInt();
            b.getInt();
            for (j = 0; j < 92; ++j) {
                b.get();
            }
            for (j = 0; j < 10; ++j) {
                di.allow[j] = b.getInt();
            }
            this.dinfo[i] = di;
        }
        Cons.println(this.dispinfos);
    }

    public void loaddispverts(ByteBuffer b) {
        b.position(this.lump[33].ofs);
        this.dispverts = this.lump[33].len / Lump.size(33);
        this.dv = new Dispvert[this.dispverts];
        for (int i = 0; i < this.dispverts; ++i) {
            this.dv[i] = new Dispvert();
            this.dv[i].x = b.getFloat();
            this.dv[i].y = b.getFloat();
            this.dv[i].z = b.getFloat();
            this.dv[i].dist = b.getFloat();
            this.dv[i].alpha = b.getFloat();
        }
        Cons.println(this.dispverts);
    }

    public void loaddisptris(ByteBuffer b) {
        b.position(this.lump[48].ofs);
        this.disptris = this.lump[48].len / Lump.size(48);
        this.dtri = new int[this.disptris];
        for (int i = 0; i < this.disptris; ++i) {
            this.dtri[i] = 0xFFFF & b.getShort();
        }
        Cons.println(this.disptris);
    }

    public void loadtexinfos(ByteBuffer b) {
        b.position(this.lump[6].ofs);
        this.texinfos = this.lump[6].len / Lump.size(6);
        this.tx = new Texinfo[this.texinfos];
        for (int i = 0; i < this.texinfos; ++i) {
            int k;
            int j;
            this.tx[i] = new Texinfo();
            for (j = 0; j < 2; ++j) {
                for (k = 0; k < 4; ++k) {
                    this.tx[i].tv[j][k] = b.getFloat();
                }
            }
            for (j = 0; j < 2; ++j) {
                for (k = 0; k < 4; ++k) {
                    this.tx[i].lv[j][k] = b.getFloat();
                }
            }
            this.tx[i].flags = b.getInt();
            this.tx[i].texdata = b.getInt();
        }
        Cons.println(this.texinfos);
    }

    public void loadtexdatas(ByteBuffer b) {
        b.position(this.lump[2].ofs);
        this.texdatas = this.lump[2].len / Lump.size(2);
        this.td = new Texdata[this.texdatas];
        for (int i = 0; i < this.texdatas; ++i) {
            this.td[i] = new Texdata();
            b.getFloat();
            b.getFloat();
            b.getFloat();
            this.td[i].nameid = b.getInt();
            b.getInt();
            b.getInt();
            b.getInt();
            b.getInt();
        }
        Cons.println(this.texdatas);
    }

    public void loadtdsd(ByteBuffer b) {
        b.position(this.lump[43].ofs);
        this.tdsds = this.lump[43].len / Lump.size(43);
        this.tdsd = new byte[this.tdsds];
        b.get(this.tdsd);
    }

    public void loadtdst(ByteBuffer b) {
        b.position(this.lump[44].ofs);
        this.tdsts = this.lump[44].len / Lump.size(44);
        this.tdst = new int[this.tdsts];
        this.texname = new String[this.tdsts];
        this.texenv = new int[this.tdsts];
        block0: for (int i = 0; i < this.tdsts; ++i) {
            int ix;
            for (int j = ix = (this.tdst[i] = b.getInt()); j < this.tdsds; ++j) {
                if (this.tdsd[j] != 0) continue;
                this.texname[i] = new String(this.tdsd, ix, j - ix);
                this.texenv[i] = -1;
                continue block0;
            }
        }
        Cons.println(this.tdsts);
    }

    public void loadentities(ByteBuffer byteBuffer) {
        String string;
        byteBuffer.position(this.lump[0].ofs);
        int n = this.lump[0].ofs + this.lump[0].len;
        int n2 = 0;
        while (byteBuffer.position() < n) {
            string = this.readline(byteBuffer, n);
            if (byteBuffer.position() > n) break;
            if (!string.equals("}")) continue;
            ++n2;
        }
        this.entities = n2;
        byteBuffer.position(this.lump[0].ofs);
        this.ent = new Entity[this.entities];
        Entity entity = new Entity();
        boolean bl = false;
        boolean bl2 = false;
        n2 = 0;
        block1: while (!bl2) {
            while (!bl) {
                String[] stringArray;
                string = this.readline(byteBuffer, n);
                if (byteBuffer.position() >= n) {
                    bl2 = true;
                    break block1;
                }
                if (string.equals("{")) {
                    entity = new Entity();
                    entity.index = n2;
                    entity.model = 0;
                    entity.ox = 0.0f;
                    entity.oy = 0.0f;
                    entity.oz = 0.0f;
                    entity.mark = false;
                    continue;
                }
                if (string.equals("}")) {
                    bl = true;
                    continue;
                }
                String[] stringArray2 = string.split("\"");
                if (stringArray2.length != 4) continue;
                String string2 = stringArray2[1];
                String string3 = stringArray2[3];
                entity.key.add(string2);
                entity.value.add(string3);
                boolean bl3 = false;
                if (string2.equals("no_decomp")) {
                    this.no_decomp = false;
                }
                if (string2.equals("classname")) {
                    entity.classname = string3;
                } else if (string2.equals("targetname")) {
                    entity.targetname = string3;
                } else if (string2.equals("parentname")) {
                    entity.parentname = string3;
                } else if (string2.equals("model")) {
                    entity.model = string3.startsWith("*") ? Integer.parseInt(string3.substring(1)) : -1;
                } else if (string2.equals("origin")) {
                    stringArray = string3.split(" ");
                    entity.ox = Float.parseFloat(stringArray[0]);
                    entity.oy = Float.parseFloat(stringArray[1]);
                    entity.oz = Float.parseFloat(stringArray[2]);
                } else {
                    stringArray = string3.split(",");
                    if (stringArray.length == 5 && this.strcount(string3, ',') == 4 && (stringArray[4].equals("1") || stringArray[4].equals("-1"))) {
                        bl3 = true;
                    }
                }
                if (bl3) {
                    entity.con.add(Boolean.TRUE);
                    continue;
                }
                entity.con.add(Boolean.FALSE);
            }
            if (entity.parentname != null && entity.targetname != null && entity.parentname.equals("tlight") && entity.targetname.charAt(0) == 'q') {
                int n3 = Integer.parseInt(entity.targetname.substring(1));
                Cons.println("Unknown entity lump format: 0!=" + n3 / 2);
                System.exit(1);
            }
            this.ent[n2] = entity;
            bl = false;
            ++n2;
        }
        if (n2 != this.entities) {
            Cons.println("Error! Entity count mismatch " + n2 + " != " + this.entities);
        }
        Cons.println(this.entities);
    }

    public int strcount(String str, char c) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public void loadnodes(ByteBuffer b) {
        b.position(this.lump[5].ofs);
        this.nodes = this.lump[5].len / Lump.size(5);
        this.node = new Node[this.nodes];
        for (int i = 0; i < this.nodes; ++i) {
            this.node[i] = new Node();
            this.node[i].pnum = b.getInt();
            this.node[i].child[0] = b.getInt();
            this.node[i].child[1] = b.getInt();
            this.node[i].mins[0] = b.getShort();
            this.node[i].mins[1] = b.getShort();
            this.node[i].mins[2] = b.getShort();
            this.node[i].maxs[0] = b.getShort();
            this.node[i].maxs[1] = b.getShort();
            this.node[i].maxs[2] = b.getShort();
            this.node[i].fstface = 0xFFFF & b.getShort();
            this.node[i].numface = b.getShort();
            this.node[i].area = b.getShort();
            b.getShort();
        }
        Cons.println(this.nodes);
    }

    public void loadleaves(ByteBuffer b) {
        b.position(this.lump[10].ofs);
        this.leaves = this.version == 19 ? this.lump[10].len / Lump.size(10) : this.lump[10].len / 32;
        this.leaf = new Leaf[this.leaves];
        for (int i = 0; i < this.leaves; ++i) {
            this.leaf[i] = new Leaf();
            this.leaf[i].contents = b.getInt();
            this.leaf[i].cluster = b.getShort();
            this.leaf[i].area_flags = b.getShort();
            this.leaf[i].mins[0] = b.getShort();
            this.leaf[i].mins[1] = b.getShort();
            this.leaf[i].mins[2] = b.getShort();
            this.leaf[i].maxs[0] = b.getShort();
            this.leaf[i].maxs[1] = b.getShort();
            this.leaf[i].maxs[2] = b.getShort();
            this.leaf[i].fstleafface = 0xFFFF & b.getShort();
            this.leaf[i].numleafface = b.getShort();
            this.leaf[i].fstleafbrush = 0xFFFF & b.getShort();
            this.leaf[i].numleafbrush = b.getShort();
            b.getShort();
            if (this.version == 19) {
                b.getInt();
                b.getInt();
                b.getInt();
                b.getInt();
                b.getInt();
                b.getInt();
            }
            b.getShort();
        }
        Cons.println(this.leaves);
    }

    public void loadlfaces(ByteBuffer b) {
        b.position(this.lump[16].ofs);
        this.lfaces = this.lump[16].len / Lump.size(16);
        this.lface = new int[this.lfaces];
        for (int i = 0; i < this.lfaces; ++i) {
            this.lface[i] = 0xFFFF & b.getShort();
        }
        Cons.println(this.lfaces);
    }

    public void loadlbrushes(ByteBuffer b) {
        b.position(this.lump[17].ofs);
        this.lbrushes = this.lump[17].len / Lump.size(17);
        this.lbrush = new int[this.lbrushes];
        for (int i = 0; i < this.lbrushes; ++i) {
            this.lbrush[i] = 0xFFFF & b.getShort();
        }
        Cons.println(this.lbrushes);
    }

    public void loadoverlays(ByteBuffer b) {
        b.position(this.lump[45].ofs);
        this.overlays = this.lump[45].len / Lump.size(45);
        this.ov = new Overlay[this.overlays];
        for (int i = 0; i < this.overlays; ++i) {
            int j;
            this.ov[i] = new Overlay();
            this.ov[i].id = b.getInt();
            this.ov[i].texinfo = b.getShort();
            this.ov[i].faces = b.getShort();
            for (j = 0; j < 64; ++j) {
                this.ov[i].face[j] = b.getInt();
            }
            this.ov[i].u0 = b.getFloat();
            this.ov[i].u1 = b.getFloat();
            this.ov[i].v0 = b.getFloat();
            this.ov[i].v1 = b.getFloat();
            for (j = 0; j < 4; ++j) {
                this.ov[i].uv[j] = this.getVec(b);
            }
            this.ov[i].origin = this.getVec(b);
            this.ov[i].normal = this.getVec(b);
            this.ov[i].ubasis = new Vec(this.ov[i].uv[0].z, this.ov[i].uv[1].z, this.ov[i].uv[2].z);
            boolean vflip = this.ov[i].uv[3].z == 1.0f;
            this.ov[i].uv[0].z = 0.0f;
            this.ov[i].uv[1].z = 0.0f;
            this.ov[i].uv[2].z = 0.0f;
            this.ov[i].uv[3].z = 0.0f;
            this.ov[i].vbasis = this.ov[i].normal.cross(this.ov[i].ubasis).norm();
            if (!vflip) continue;
            this.ov[i].vbasis = this.ov[i].vbasis.scalar(-1.0f);
        }
        Cons.println(this.overlays);
    }

    public void transmodels() {
        for (int i = 1; i < this.entities; ++i) {
            int imodel = this.ent[i].model;
            if (imodel <= 0) continue;
            this.mod[imodel].entity = i;
        }
    }

    public void markedges() {
        for (int i = 0; i < this.models; ++i) {
            for (int j = 0; j < this.mod[i].numface; ++j) {
                int iface = this.mod[i].fstface + j;
                for (int k = 0; k < this.face[iface].numedge; ++k) {
                    int isedge = this.face[iface].fstedge + k;
                    int iedge = this.sefix(isedge);
                    this.eim[iedge] = (byte)(i == 0 ? 2 : 1);
                }
            }
        }
    }

    public String readline(ByteBuffer bb, int end) {
        char c;
        StringBuffer linebuff = new StringBuffer();
        while ((c = (char)bb.get()) != '\n' && bb.position() < end) {
            linebuff.append(c);
        }
        return linebuff.toString();
    }

    public String readstr(ByteBuffer bb, int len) {
        char c;
        StringBuffer strbuff = new StringBuffer();
        int pos = 0;
        while ((c = (char)bb.get()) != '\u0000' && ++pos < len) {
            strbuff.append(c);
        }
        while (++pos < len) {
            bb.get();
        }
        return strbuff.toString();
    }

    public Texture gettex(short index) {
        return this.gettex(index, new Vec(0.0f, 0.0f, 0.0f), new DecimalFormat("0.###"));
    }

    public Texture gettex(short index, Vec origin, DecimalFormat fp) {
        Texinfo ti;
        Texture tex = new Texture();
        if (index < 0) {
            return tex;
        }
        tex.texinfo = ti = this.tx[index];
        if (ti.texdata < 0) {
            return tex;
        }
        tex.texdata = this.td[ti.texdata];
        tex.name = this.texname[tex.texdata.nameid];
        tex.lmscale = ti.lmscale;
        tex.envmap = this.texenv[tex.texdata.nameid];
        float[][] tvec = ti.tv;
        double[] uaxis = new double[3];
        double[] vaxis = new double[3];
        double tw0 = 1.0 / Math.sqrt(Math.pow(tvec[0][0], 2.0) + Math.pow(tvec[0][1], 2.0) + Math.pow(tvec[0][2], 2.0));
        double tw1 = 1.0 / Math.sqrt(Math.pow(tvec[1][0], 2.0) + Math.pow(tvec[1][1], 2.0) + Math.pow(tvec[1][2], 2.0));
        for (int i = 0; i < 3; ++i) {
            uaxis[i] = (double)tvec[0][i] * tw0;
            vaxis[i] = (double)tvec[1][i] * tw1;
        }
        Vec t0 = new Vec(tvec[0][0], tvec[0][1], tvec[0][2]);
        Vec t1 = new Vec(tvec[1][0], tvec[1][1], tvec[1][2]);
        double dotp0 = origin.dot(t0);
        double dotp1 = origin.dot(t1);
        double shift0 = (double)tvec[0][3] - dotp0;
        double shift1 = (double)tvec[1][3] - dotp1;
        tex.uaxis = "[" + fp.format(uaxis[0]) + " " + fp.format(uaxis[1]) + " " + fp.format(uaxis[2]) + " " + fp.format(shift0) + "] " + fp.format(tw0);
        tex.vaxis = "[" + fp.format(vaxis[0]) + " " + fp.format(vaxis[1]) + " " + fp.format(vaxis[2]) + " " + fp.format(shift1) + "] " + fp.format(tw1);
        return tex;
    }

    public Wind windbrushface(Brush brush, int side) {
        Wind bw = new Wind();
        int bside = brush.fstside + side;
        int plane = this.bsd[bside].pnum;
        bw.createplane(this.pl[plane]);
        for (int i = 0; i < brush.numside; ++i) {
            if (i == side) continue;
            int ibside = brush.fstside + i;
            int iplane = this.bsd[ibside].pnum;
            if (this.bsd[ibside].bevel == 1) continue;
            bw = bw.clipplane(this.pl[iplane].flip());
        }
        return bw;
    }

    public void treewalk(int inode, Treelimit tl) {
        if (inode < 0) {
            int i;
            int ileaf = -1 - inode;
            Leaf l = this.leaf[ileaf];
            for (i = 0; i < l.numleafface; ++i) {
                int iface = this.lface[l.fstleafface + i];
                if (iface > tl.fmax) {
                    tl.fmax = iface;
                }
                if (iface >= tl.fmin) continue;
                tl.fmin = iface;
            }
            for (i = 0; i < l.numleafbrush; ++i) {
                int ibrush = this.lbrush[l.fstleafbrush + i];
                if (ibrush > tl.bmax) {
                    tl.bmax = ibrush;
                }
                if (ibrush >= tl.bmin) continue;
                tl.bmin = ibrush;
            }
        } else {
            if (inode > tl.nmax) {
                tl.nmax = inode;
            }
            this.treewalk(this.node[inode].child[0], tl);
            this.treewalk(this.node[inode].child[1], tl);
        }
    }

    public Vec getVec(ByteBuffer b) {
        Vec v = new Vec();
        v.x = b.getFloat();
        v.y = b.getFloat();
        v.z = b.getFloat();
        return v;
    }

    public Vec vert(int v) {
        Vec ret = new Vec(this.x[v], this.y[v], this.z[v]);
        return ret;
    }

    public void calclightmapscale() {
        for (int i = 0; i < this.texinfos; ++i) {
            this.tx[i].calclms();
        }
    }
}

