/*
 * Decompiled with CFR 0.152.
 */
package pak;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import pak.ColRGBA8888;

public class Vtf {
    static final int IF_RGBA8888 = 0;
    static final int IF_ABGR8888 = 1;
    static final int IF_RGB888 = 2;
    static final int IF_BGR888 = 3;
    static final int IF_RGB565 = 4;
    static final int IF_I8 = 5;
    static final int IF_IA88 = 6;
    static final int IF_P8 = 7;
    static final int IF_A8 = 8;
    static final int IF_RGB888_BS = 9;
    static final int IF_BGR888_BS = 10;
    static final int IF_ARGB8888 = 11;
    static final int IF_BGRA8888 = 12;
    static final int IF_DXT1 = 13;
    static final int IF_DXT3 = 14;
    static final int IF_DXT5 = 15;
    static final int IF_BGRX8888 = 16;
    static final int IF_BGR565 = 17;
    static final int IF_BGRX5551 = 18;
    static final int IF_BGRA4444 = 19;
    static final int IF_DXT1_1BA = 20;
    static final int IF_BGRA5551 = 21;
    static final int IF_UV88 = 22;
    static final int IF_UVWQ8888 = 23;
    static final int IF_RGBA16161616F = 24;
    static final int IF_RGBA16161616 = 25;
    static final String[] imgfmt = new String[]{"RBGA8888", "ABGR8888", "RGB888", "BGR888", "RGB565", "I8", "IA88", "P8", "A8", "RGB888-BS", "BGR888-BS", "ARGB8888", " BGRA8888", "DXT1", "DXT3", "DXT5", "BGRX8888", "BGR565", "BGRX5551", "BGRA4444", "DXT1_1BA", "BGRA5551", "UV88", "UVWQ8888", "RGBA16161616F", "RGBA16161616"};
    static final int[] imgfmtsize = new int[]{4, 4, 3, 3, 2, 1, 2, 1, 1, 3, 3, 4, 4, 0, 0, 0, 4, 2, 2, 2, 0, 2, 2, 4, 8, 8, 4};
    static final String[] flagstr = new String[]{"POINTSAMPLE", "TRILINEAR", "CLAMP-S", "CLAMP-T", "ANISOTROPIC", "HINT-DXT5", "NOCOMPRESS", "NORMAL", "NOMIP", "NOLOD", "MINMIP", "PROC", "1BALPHA", "8BALPHA", "ENVMAP", "RENDERTARGET", "DEPTH-RT", "NODEBUGOVERRIDE", "SINGLECOPY", "1OVERMIPLEVELINALPHA", "PREMULTCOL1OML", "NORMALTODUDV", "ALPHATESTMIPGEN", "NODEPTHBUFF", "NICEFILTERED"};
    static final int TF_ENVMAP = 16384;
    int[] vers = new int[2];
    boolean isValid = false;
    int headersize;
    short width;
    short height;
    int flags;
    int imageformat;
    int numframes;
    int startframe;
    float refx;
    float refy;
    float refz;
    float bumpscale;
    int nummips;
    int lrimageformat;
    short lrwidth;
    short lrheight;
    boolean isLR;
    byte[] lrbuffer;
    byte[] buffer;
    double gamma = 1.0;
    double bright = 1.0;

    public void load(String filename) throws IOException {
        File infile = new File(filename);
        if (!infile.exists() || !infile.canRead()) {
            System.out.println("Can't open " + filename);
            return;
        }
        System.out.println("Reading " + filename);
        FileChannel rafch = new RandomAccessFile(infile, "r").getChannel();
        MappedByteBuffer mbuffer = rafch.map(FileChannel.MapMode.READ_ONLY, 0L, rafch.size());
        ByteBuffer b = mbuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.read(b, rafch.size());
        rafch.close();
    }

    public void read(ByteBuffer b, long size) throws IOException {
        this.isValid = false;
        char[] type = new char[4];
        for (int i = 0; i < 4; ++i) {
            type[i] = (char)b.get();
        }
        String tstr = new String(type);
        if (!tstr.equals("VTF\u0000")) {
            return;
        }
        this.vers[0] = b.getInt();
        this.vers[1] = b.getInt();
        this.headersize = b.getInt();
        this.width = b.getShort();
        this.height = b.getShort();
        this.flags = b.getInt();
        this.numframes = b.getShort();
        this.startframe = b.getShort();
        b.getInt();
        this.refx = b.getFloat();
        this.refy = b.getFloat();
        this.refz = b.getFloat();
        b.getInt();
        this.bumpscale = b.getFloat();
        this.imageformat = b.getInt();
        this.nummips = b.get();
        this.lrimageformat = b.getInt();
        this.lrwidth = b.get();
        this.lrheight = b.get();
        this.isLR = this.lrimageformat != -1;
        int lrbuffsize = 0;
        if (this.isLR) {
            lrbuffsize = this.CalcSize(this.lrwidth, this.lrheight, this.lrimageformat);
        }
        int buffsize = this.CalcSize(this.width, this.height, this.nummips, this.imageformat) * this.GetFaceCount() * this.numframes;
        b.position(this.headersize);
        this.lrbuffer = new byte[lrbuffsize];
        if (this.isLR) {
            b.get(this.lrbuffer);
        }
        this.buffer = new byte[buffsize];
        b.get(this.buffer);
        this.isValid = true;
    }

    public String GetFlagStr() {
        int bflags = this.flags;
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < 25; ++i) {
            if ((bflags & 1) == 1) {
                str.append(flagstr[i]).append(" ");
            }
            bflags >>= 1;
        }
        return str.toString();
    }

    public int[] GetIntARGB(int frame, int face, int miplevel) {
        int[] idata = new int[this.GetWidth(miplevel) * this.GetHeight(miplevel)];
        byte[] data = this.GetRGBA(this.GetData(frame, face, miplevel), this.GetWidth(miplevel), this.GetHeight(miplevel), this.imageformat);
        int a = 0;
        for (int i = 0; i < idata.length; ++i) {
            idata[i] = (data[a + 3] & 0xFF) << 24 | (data[a] & 0xFF) << 16 | (data[a + 1] & 0xFF) << 8 | data[a + 2] & 0xFF;
            a += 4;
        }
        return idata;
    }

    public int[] GetIntCompRGBA(int frame, int face, int miplevel, int component) {
        int[] idata = new int[this.GetWidth(miplevel) * this.GetHeight(miplevel)];
        byte[] data = this.GetRGBA(this.GetData(frame, face, miplevel), this.GetWidth(miplevel), this.GetHeight(miplevel), this.imageformat);
        int a = 0;
        for (int i = 0; i < idata.length; ++i) {
            int alph = data[a + component] & 0xFF;
            idata[i] = alph << 16 | alph << 8 | alph;
            a += 4;
        }
        return idata;
    }

    public byte[] GetRGBA(int frame, int face, int miplevel) {
        return this.GetRGBA(this.GetData(frame, face, miplevel), this.GetWidth(miplevel), this.GetHeight(miplevel), this.imageformat);
    }

    public byte[] GetRGBA(byte[] data, int mwidth, int mheight, int format) {
        int destsize = this.CalcSize(mwidth, mheight, 0);
        if (format == 13 || format == 20) {
            return this.DecompDXT1(data, mwidth, mheight);
        }
        if (format == 15) {
            return this.DecompDXT5(data, mwidth, mheight);
        }
        byte[] dest = new byte[destsize];
        if (format == 2) {
            int end = mwidth * mheight * 3;
            int j = 0;
            for (int i = 0; i < end; i += 3) {
                dest[j] = data[i];
                dest[j + 1] = data[i + 1];
                dest[j + 2] = data[i + 2];
                dest[j + 3] = -1;
                j += 4;
            }
            return dest;
        }
        if (format == 3) {
            int end = mwidth * mheight * 3;
            int j = 0;
            for (int i = 0; i < end; i += 3) {
                dest[j] = data[i + 2];
                dest[j + 1] = data[i + 1];
                dest[j + 2] = data[i + 0];
                dest[j + 3] = -1;
                j += 4;
            }
            return dest;
        }
        if (format == 0 || format == 23) {
            int end = mwidth * mheight * 4;
            for (int i = 0; i < end; ++i) {
                dest[i] = data[i];
            }
            return dest;
        }
        if (format == 12) {
            int end = mwidth * mheight * 4;
            for (int i = 0; i < end; i += 4) {
                dest[i + 0] = data[i + 2];
                dest[i + 1] = data[i + 1];
                dest[i + 2] = data[i + 0];
                dest[i + 3] = data[i + 3];
            }
            return dest;
        }
        if (format == 16) {
            int end = mwidth * mheight * 4;
            for (int i = 0; i < end; i += 4) {
                dest[i + 0] = data[i + 2];
                dest[i + 1] = data[i + 1];
                dest[i + 2] = data[i + 0];
                dest[i + 3] = -1;
            }
            return dest;
        }
        if (format == 11) {
            int end = mwidth * mheight * 4;
            for (int i = 0; i < end; i += 4) {
                dest[i + 0] = data[i + 3];
                dest[i + 1] = data[i + 2];
                dest[i + 2] = data[i + 1];
                dest[i + 3] = data[i + 0];
            }
            return dest;
        }
        if (format == 8) {
            int end = mwidth * mheight;
            int j = 0;
            for (int i = 0; i < end; ++i) {
                dest[j + 0] = -1;
                dest[j + 1] = -1;
                dest[j + 2] = -1;
                dest[j + 3] = data[i];
                j += 4;
            }
            return dest;
        }
        if (format == 5) {
            int end = mwidth * mheight;
            int j = 0;
            for (int i = 0; i < end; ++i) {
                dest[j + 0] = data[i];
                dest[j + 1] = data[i];
                dest[j + 2] = data[i];
                dest[j + 3] = -1;
                j += 4;
            }
            return dest;
        }
        if (format == 6) {
            int end = mwidth * mheight * 2;
            int j = 0;
            for (int i = 0; i < end; i += 2) {
                dest[j + 0] = data[i];
                dest[j + 1] = data[i];
                dest[j + 2] = data[i];
                dest[j + 3] = data[i + 1];
                j += 4;
            }
            return dest;
        }
        if (format == 9) {
            int end = mwidth * mheight * 3;
            int j = 0;
            for (int i = 0; i < end; i += 3) {
                if (data[i] == 0 && data[i + 1] == 0 && data[i + 2] == 255) {
                    dest[j] = 0;
                    dest[j + 1] = 0;
                    dest[j + 2] = 0;
                    dest[j + 3] = 0;
                } else {
                    dest[j] = data[i];
                    dest[j + 1] = data[i + 1];
                    dest[j + 2] = data[i + 2];
                    dest[j + 3] = -1;
                }
                j += 4;
            }
            return dest;
        }
        if (format == 10) {
            int end = mwidth * mheight * 3;
            int j = 0;
            for (int i = 0; i < end; i += 3) {
                if (data[i] == 255 && data[i + 1] == 0 && data[i + 2] == 0) {
                    dest[j] = 0;
                    dest[j + 1] = 0;
                    dest[j + 2] = 0;
                    dest[j + 3] = 0;
                } else {
                    dest[j] = data[i + 2];
                    dest[j + 1] = data[i + 1];
                    dest[j + 2] = data[i + 0];
                    dest[j + 3] = -1;
                }
                j += 4;
            }
            return dest;
        }
        if (format == 4) {
            int end = mwidth * mheight * 2;
            int j = 0;
            for (int i = 0; i < end; i += 2) {
                int src = (0xFF & data[i + 1]) * 256 + (0xFF & data[i]);
                int red = src & 0x1F;
                int green = src >> 5 & 0x3F;
                int blue = src >>> 11 & 0x1F;
                dest[j + 0] = (byte)(red << 3 | red >> 2);
                dest[j + 1] = (byte)(green << 2 | green >> 4);
                dest[j + 2] = (byte)(blue << 3 | blue >> 2);
                dest[j + 3] = -1;
                j += 4;
            }
            return dest;
        }
        if (format == 17) {
            int end = mwidth * mheight * 2;
            int j = 0;
            for (int i = 0; i < end; i += 2) {
                int src = (0xFF & data[i + 1]) * 256 + (0xFF & data[i]);
                int blue = src & 0x1F;
                int green = src >> 5 & 0x3F;
                int red = src >>> 11 & 0x1F;
                dest[j + 0] = (byte)(red << 3 | red >> 2);
                dest[j + 1] = (byte)(green << 2 | green >> 4);
                dest[j + 2] = (byte)(blue << 3 | blue >> 2);
                dest[j + 3] = -1;
                j += 4;
            }
            return dest;
        }
        if (format == 18) {
            int end = mwidth * mheight * 2;
            int j = 0;
            for (int i = 0; i < end; i += 2) {
                int src = (0xFF & data[i + 1]) * 256 + (0xFF & data[i]);
                int blue = src & 0x1F;
                int green = src >> 5 & 0x1F;
                int red = src >>> 10 & 0x1F;
                dest[j + 0] = (byte)(red << 3 | red >> 2);
                dest[j + 1] = (byte)(green << 3 | green >> 2);
                dest[j + 2] = (byte)(blue << 3 | blue >> 2);
                dest[j + 3] = -1;
                j += 4;
            }
            return dest;
        }
        if (format == 21) {
            int end = mwidth * mheight * 2;
            int j = 0;
            for (int i = 0; i < end; i += 2) {
                int src = (0xFF & data[i + 1]) * 256 + (0xFF & data[i]);
                int blue = src & 0x1F;
                int green = src >> 5 & 0x1F;
                int red = src >>> 10 & 0x1F;
                int alpha = (int)((long)src & 0x8000L);
                dest[j + 0] = (byte)(red << 3 | red >> 2);
                dest[j + 1] = (byte)(green << 3 | green >> 2);
                dest[j + 2] = (byte)(blue << 3 | blue >> 2);
                dest[j + 3] = alpha == 0 ? 0 : -1;
                j += 4;
            }
            return dest;
        }
        if (format == 19) {
            int end = mwidth * mheight * 2;
            int j = 0;
            for (int i = 0; i < end; i += 2) {
                int src = (0xFF & data[i + 1]) * 256 + (0xFF & data[i]);
                int blue = src & 0xF;
                int green = src >> 4 & 0xF;
                int red = src >> 8 & 0xF;
                int alpha = src >>> 12 & 0xF;
                dest[j + 0] = (byte)(red << 4 | red >> 4);
                dest[j + 1] = (byte)(green << 4 | green >> 4);
                dest[j + 2] = (byte)(blue << 4 | blue >> 4);
                dest[j + 3] = (byte)(alpha << 4 | alpha >> 4);
                j += 4;
            }
            return dest;
        }
        if (format == 22) {
            int end = mwidth * mheight * 2;
            int j = 0;
            for (int i = 0; i < end; i += 2) {
                dest[j + 0] = data[i];
                dest[j + 1] = data[i + 1];
                dest[j + 2] = 0;
                dest[j + 3] = -1;
                j += 4;
            }
            return dest;
        }
        if (format == 25) {
            int end = mwidth * mheight * 8;
            int j = 0;
            for (int i = 0; i < end; i += 8) {
                int red = (0xFF & data[i + 1]) * 256 + (0xFF & data[i]);
                int green = (0xFF & data[i + 3]) * 256 + (0xFF & data[i + 2]);
                int blue = (0xFF & data[i + 5]) * 256 + (0xFF & data[i + 4]);
                int alpha = (0xFF & data[i + 7]) * 256 + (0xFF & data[i + 6]);
                dest[j + 0] = (byte)(red >>> 8);
                dest[j + 1] = (byte)(green >>> 8);
                dest[j + 2] = (byte)(blue >>> 8);
                dest[j + 3] = (byte)(alpha >>> 8);
                j += 4;
            }
            return dest;
        }
        if (format == 24) {
            int end = mwidth * mheight * 8;
            int j = 0;
            for (int i = 0; i < end; i += 8) {
                int red = (0xFF & data[i + 1]) * 256 + (0xFF & data[i]);
                int green = (0xFF & data[i + 3]) * 256 + (0xFF & data[i + 2]);
                int blue = (0xFF & data[i + 5]) * 256 + (0xFF & data[i + 4]);
                int alpha = (0xFF & data[i + 7]) * 256 + (0xFF & data[i + 6]);
                red = this.HDRScale(red);
                green = this.HDRScale(green);
                blue = this.HDRScale(blue);
                dest[j + 0] = (byte)(red >>> 8);
                dest[j + 1] = (byte)(green >>> 8);
                dest[j + 2] = (byte)(blue >>> 8);
                dest[j + 3] = (byte)(alpha >>> 8);
                j += 4;
            }
            return dest;
        }
        System.out.println("Vtf: Unsupported format " + imgfmt[format]);
        return dest;
    }

    public int HDRScale(int chan) {
        int out = (int)(Math.pow((float)chan / 65535.0f, this.gamma) * 65535.0 * this.bright);
        if (out > 65535) {
            out = 65535;
        }
        return out;
    }

    public void setHDR(double g, double b) {
        this.gamma = g;
        this.bright = b;
    }

    public byte[] DecompDXT1(byte[] data, int mwidth, int mheight) {
        int i;
        int destsize = this.CalcSize(mwidth, mheight, 0);
        byte[] dest = new byte[destsize];
        int bpp = 4;
        int bps = bpp * mwidth;
        ColRGBA8888[] colours = new ColRGBA8888[4];
        ColRGBA8888 col = new ColRGBA8888();
        for (i = 0; i < 4; ++i) {
            colours[i] = new ColRGBA8888();
        }
        int index = 0;
        for (int y = 0; y < mheight; y += 4) {
            for (int x = 0; x < mwidth; x += 4) {
                colours[0].from565(data[index], data[index + 1]);
                colours[1].from565(data[index + 2], data[index + 3]);
                int bitmask = this.toInt(data, index + 4);
                index += 8;
                if (colours[0].c565 > colours[1].c565) {
                    colours[2].b = (2 * colours[0].b + colours[1].b + 1) / 3;
                    colours[2].g = (2 * colours[0].g + colours[1].g + 1) / 3;
                    colours[2].r = (2 * colours[0].r + colours[1].r + 1) / 3;
                    colours[2].a = -1;
                    colours[3].b = (colours[0].b + 2 * colours[1].b + 1) / 3;
                    colours[3].g = (colours[0].g + 2 * colours[1].g + 1) / 3;
                    colours[3].r = (colours[0].r + 2 * colours[1].r + 1) / 3;
                    colours[3].a = -1;
                } else {
                    colours[2].b = (colours[0].b + colours[1].b) / 2;
                    colours[2].g = (colours[0].g + colours[1].g) / 2;
                    colours[2].r = (colours[0].r + colours[1].r) / 2;
                    colours[2].a = -1;
                    colours[3].b = (colours[0].b + 2 * colours[1].b + 1) / 3;
                    colours[3].g = (colours[0].g + 2 * colours[1].g + 1) / 3;
                    colours[3].r = (colours[0].r + 2 * colours[1].r + 1) / 3;
                    colours[3].a = 0;
                }
                int k = 0;
                for (int j = 0; j < 4; ++j) {
                    for (i = 0; i < 4; ++i) {
                        int select = (bitmask & 3 << k * 2) >>> k * 2;
                        col = colours[select];
                        if (x + i < mwidth && y + j < mheight) {
                            int offset = (y + j) * bps + (x + i) * bpp;
                            dest[offset + 0] = this.toByte(col.r);
                            dest[offset + 1] = this.toByte(col.g);
                            dest[offset + 2] = this.toByte(col.b);
                            dest[offset + 3] = this.toByte(col.a);
                        }
                        ++k;
                    }
                }
            }
        }
        return dest;
    }

    public byte[] DecompDXT5(byte[] data, int mwidth, int mheight) {
        int i;
        int destsize = this.CalcSize(mwidth, mheight, 0);
        byte[] dest = new byte[destsize];
        int bpp = 4;
        int bps = bpp * mwidth;
        int[] alphas = new int[8];
        ColRGBA8888[] colours = new ColRGBA8888[4];
        ColRGBA8888 col = new ColRGBA8888();
        for (i = 0; i < 4; ++i) {
            colours[i] = new ColRGBA8888();
        }
        int index = 0;
        for (int y = 0; y < mheight; y += 4) {
            for (int x = 0; x < mwidth; x += 4) {
                int offset;
                int j;
                alphas[0] = data[index] & 0xFF;
                alphas[1] = data[index + 1] & 0xFF;
                int alphamask0 = this.toInt3(data, index + 2);
                int alphamask1 = this.toInt3(data, index + 5);
                colours[0].from565(data[index += 8], data[index + 1]);
                colours[1].from565(data[index + 2], data[index + 3]);
                int bitmask = this.toInt(data, index + 4);
                index += 8;
                colours[2].b = (2 * colours[0].b + colours[1].b + 1) / 3;
                colours[2].g = (2 * colours[0].g + colours[1].g + 1) / 3;
                colours[2].r = (2 * colours[0].r + colours[1].r + 1) / 3;
                colours[2].a = -1;
                colours[3].b = (colours[0].b + 2 * colours[1].b + 1) / 3;
                colours[3].g = (colours[0].g + 2 * colours[1].g + 1) / 3;
                colours[3].r = (colours[0].r + 2 * colours[1].r + 1) / 3;
                colours[3].a = -1;
                int k = 0;
                for (j = 0; j < 4; ++j) {
                    for (i = 0; i < 4; ++i) {
                        int select = (bitmask & 3 << k * 2) >>> k * 2;
                        col = colours[select];
                        if (x + i < mwidth && y + j < mheight) {
                            offset = (y + j) * bps + (x + i) * bpp;
                            dest[offset + 0] = this.toByte(col.r);
                            dest[offset + 1] = this.toByte(col.g);
                            dest[offset + 2] = this.toByte(col.b);
                        }
                        ++k;
                    }
                }
                if (alphas[0] > alphas[1]) {
                    alphas[2] = (6 * alphas[0] + 1 * alphas[1] + 3) / 7;
                    alphas[3] = (5 * alphas[0] + 2 * alphas[1] + 3) / 7;
                    alphas[4] = (4 * alphas[0] + 3 * alphas[1] + 3) / 7;
                    alphas[5] = (3 * alphas[0] + 4 * alphas[1] + 3) / 7;
                    alphas[6] = (2 * alphas[0] + 5 * alphas[1] + 3) / 7;
                    alphas[7] = (1 * alphas[0] + 6 * alphas[1] + 3) / 7;
                } else {
                    alphas[2] = (4 * alphas[0] + 1 * alphas[1] + 2) / 5;
                    alphas[3] = (3 * alphas[0] + 2 * alphas[1] + 2) / 5;
                    alphas[4] = (2 * alphas[0] + 3 * alphas[1] + 2) / 5;
                    alphas[5] = (1 * alphas[0] + 4 * alphas[1] + 2) / 5;
                    alphas[6] = 0;
                    alphas[7] = 255;
                }
                int bits = alphamask0;
                for (j = 0; j < 2; ++j) {
                    for (i = 0; i < 4; ++i) {
                        if (x + i < mwidth && y + j < mheight) {
                            offset = (y + j) * bps + (x + i) * bpp + 3;
                            dest[offset] = (byte)alphas[bits & 7];
                        }
                        bits >>= 3;
                    }
                }
                bits = alphamask1;
                for (j = 2; j < 4; ++j) {
                    for (i = 0; i < 4; ++i) {
                        if (x + i < mwidth && y + j < mheight) {
                            offset = (y + j) * bps + (x + i) * bpp + 3;
                            dest[offset] = (byte)alphas[bits & 7];
                        }
                        bits >>= 3;
                    }
                }
            }
        }
        return dest;
    }

    public int toInt(byte[] data, int index) {
        int ret = (0xFF & data[index + 3]) << 24;
        ret |= (0xFF & data[index + 2]) << 16;
        ret |= (0xFF & data[index + 1]) << 8;
        return ret |= 0xFF & data[index + 0];
    }

    public int toInt3(byte[] data, int index) {
        int ret = (0xFF & data[index + 2]) << 16;
        ret |= (0xFF & data[index + 1]) << 8;
        return ret |= 0xFF & data[index + 0];
    }

    public byte toByte(int in) {
        return (byte)(in & 0xFF);
    }

    public String toHex(byte b) {
        int c = b & 0xFF;
        return (c < 16 ? "0" : "") + Integer.toHexString(c);
    }

    public byte[] GetData(int frame, int face, int miplevel) {
        int dwidth = this.GetWidth(miplevel);
        int dheight = this.GetHeight(miplevel);
        int dlength = this.CalcSize(dwidth, dheight, this.imageformat);
        int doffset = this.GetOffset(frame, face, miplevel);
        byte[] databuff = new byte[dlength];
        for (int i = 0; i < dlength; ++i) {
            databuff[i] = this.buffer[i + doffset];
        }
        return databuff;
    }

    public int GetOffset(int frame, int face, int mip) {
        int offset = 0;
        int mframecount = this.numframes;
        int mfacecount = this.GetFaceCount();
        int mmipcount = this.nummips;
        if (frame >= mframecount) {
            frame = mframecount - 1;
        }
        if (face >= mfacecount) {
            face = mfacecount - 1;
        }
        if (mip >= mmipcount) {
            mip = mmipcount - 1;
        }
        for (int i = mmipcount - 1; i > mip; --i) {
            offset += mframecount * mfacecount * this.CalcSize(this.GetWidth(i), this.GetHeight(i), this.imageformat);
        }
        int temp = this.CalcSize(this.GetWidth(mip), this.GetHeight(mip), this.imageformat);
        return offset += temp * (frame * mfacecount + face);
    }

    public int GetWidth(int miplev) {
        if (miplev >= this.nummips) {
            return 0;
        }
        int mwidth = this.width;
        for (int i = 0; i < miplev; ++i) {
            if ((mwidth >>= 1) >= 1) continue;
            mwidth = 1;
        }
        return mwidth;
    }

    public int GetHeight(int miplev) {
        if (miplev >= this.nummips) {
            return 0;
        }
        int mheight = this.height;
        for (int i = 0; i < miplev; ++i) {
            if ((mheight >>= 1) >= 1) continue;
            mheight = 1;
        }
        return mheight;
    }

    public int GetFaceCount() {
        if (this.isEnvmap()) {
            if (this.startframe == -1) {
                return 6;
            }
            return 7;
        }
        return 1;
    }

    public boolean isEnvmap() {
        return (this.flags & 0x4000) != 0;
    }

    public int CalcSize(int mwidth, int mheight, int mmipmaps, int mformat) {
        int size = 0;
        if (mheight == 0 || mwidth == 0) {
            return -1;
        }
        for (int i = 0; i < mmipmaps; ++i) {
            size += this.CalcSize(mwidth, mheight, mformat);
            mheight >>= 1;
            if ((mwidth >>= 1) < 1) {
                mwidth = 1;
            }
            if (mheight >= 1) continue;
            mheight = 1;
        }
        return size;
    }

    public int CalcSize(int mwidth, int mheight, int mformat) {
        switch (mformat) {
            case 13: 
            case 20: {
                if (mwidth < 4 && mwidth > 0) {
                    mwidth = 4;
                }
                if (mheight < 4 && mheight > 0) {
                    mheight = 4;
                }
                return (mwidth + 3) / 4 * ((mheight + 3) / 4) * 8;
            }
            case 14: 
            case 15: {
                if (mwidth < 4 && mwidth > 0) {
                    mwidth = 4;
                }
                if (mheight < 4 && mheight > 0) {
                    mheight = 4;
                }
                return (mwidth + 3) / 4 * ((mheight + 3) / 4) * 16;
            }
        }
        return mwidth * mheight * imgfmtsize[mformat];
    }
}

