/*
 * Decompiled with CFR 0.152.
 */
package pak;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import pak.Scanfile;

public class ScanModel
extends AbstractTableModel {
    ArrayList fl;
    static String[] tstr = new String[]{"Unknown", "Material", "Texture", "Model", "Model", "Model", "Model", "Sound", "Sound", "Navigation", "AI Node", "Text", "Soundcache"};
    static String[] header = new String[]{"Filename", "Path", "Type", "Location", "Add"};
    static Object[] cols = new Object[]{"", "", "", "", Boolean.TRUE};
    static String[] locstr = new String[]{"Not found", "In Pak", "In List", "On Disk"};

    public ScanModel(ArrayList filelist) {
        this.fl = filelist;
    }

    public void setfilelist(ArrayList filelist) {
        this.fl = filelist;
        this.update();
    }

    public Scanfile getfile(int row) {
        if (this.fl != null) {
            return (Scanfile)this.fl.get(row);
        }
        return null;
    }

    public int getRowCount() {
        if (this.fl != null) {
            return this.fl.size();
        }
        return 0;
    }

    public int getColumnCount() {
        return 5;
    }

    public Class getColumnClass(int col) {
        return cols[col].getClass();
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.getfile((int)row).listname;
            }
            case 1: {
                return this.getfile((int)row).pathname;
            }
            case 2: {
                return tstr[this.getfile((int)row).type];
            }
            case 3: {
                return this.getloc(row);
            }
            case 4: {
                return new Boolean(this.getfile((int)row).mark);
            }
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 4) {
            this.getfile((int)row).mark = (Boolean)value;
        }
        this.fireTableDataChanged();
    }

    public String getloc(int row) {
        Scanfile sf = this.getfile(row);
        if (sf.inpak) {
            return locstr[1];
        }
        if (sf.inlist) {
            return locstr[2];
        }
        if (sf.ondisk) {
            return locstr[3];
        }
        return locstr[0];
    }

    public String getColumnName(int col) {
        return header[col];
    }

    public boolean isCellEditable(int row, int col) {
        if (col != 4) {
            return false;
        }
        Scanfile sf = this.getfile(row);
        return sf.onlydisk();
    }

    public int numselected() {
        int count = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getfile((int)i).mark) continue;
            ++count;
        }
        return count;
    }

    public boolean noneselected() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getfile((int)i).mark) continue;
            return false;
        }
        return true;
    }

    public boolean setallselected() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Scanfile sf = this.getfile(i);
            if (!sf.onlydisk()) continue;
            sf.mark = true;
        }
        this.fireTableDataChanged();
        return !this.noneselected();
    }

    public void resetallselected() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Scanfile sf = this.getfile(i);
            if (!sf.onlydisk()) continue;
            sf.mark = false;
        }
        this.fireTableDataChanged();
    }

    public void update() {
        this.fireTableDataChanged();
    }
}

