/*
 * Decompiled with CFR 0.152.
 */
package pak;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pak.Cons;
import pak.JProgFrame;
import pak.Mappak;
import pak.Mdl;
import pak.Pakpref;
import pak.Phymdl;
import pak.ScanModel;
import pak.ScanTCBR;
import pak.ScanTCR;
import pak.Scanfile;
import pak.SwingWorker;
import pak.Unpak;
import pak.ZipDirModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scan {
    Mappak m;
    ZipDirModel tmod;
    JFrame sframe;
    JTable stable;
    ScanModel smodel;
    RandomAccessFile raf;
    Unpak pakrat;
    JProgFrame prog = null;
    ArrayList<Scanfile> files;
    boolean auton = false;
    boolean nofiles = false;
    static final String[] mattexref = new String[]{"$basetexture", "$basetexture2", "$bumpmap", "$bumpmap2", "$envmap", "$normalmap", "$dudvmap", "$envmapmask", "$detail", "$parallaxmap", "$parallaxmap2", "$texture2", "$selfillumtexture", "$cloudalphatexture", "$gradienttexture", "$fbtexture", "$refracttexture", "$refracttinttexture", "$hdrbasetexture"};
    static final String[] matmatref = new String[]{"include", "$fallbackmaterial", "$bottommaterial", "$crackmaterial", "$material", "$modelmaterial", "$translucent_material"};
    static final String[] mdlext = new String[]{".dx80.vtx", ".dx90.vtx", ".sw.vtx", ".phy", ".vvd"};
    String basedir;
    ArrayList<String> dirset = new ArrayList();

    public Scan(Unpak pakrat, Component parent, Mappak m, ZipDirModel tmod, String fname, String gamedir) {
        this(pakrat, parent, m, tmod, fname, gamedir, false);
    }

    public Scan(Unpak pakrat, Component parent, Mappak m, ZipDirModel tmod, String fname, String gamedir, boolean autoadd) {
        this.auton = parent == null;
        this.pakrat = pakrat;
        this.m = m;
        this.tmod = tmod;
        this.raf = tmod.getbuff();
        this.files = new ArrayList();
        if (autoadd) {
            this.basedir = gamedir;
            this.doautoscan(parent);
            return;
        }
        this.sframe = new JFrame("Pakrat - Scan Files - " + fname);
        this.sframe.setLocationRelativeTo(parent);
        JPanel spanel = new JPanel(new BorderLayout());
        this.smodel = new ScanModel(this.files);
        this.stable = new JTable(this.smodel);
        Box topbox = Box.createHorizontalBox();
        topbox.add(new JLabel("Gamedir: "));
        final JComboBox<String> filebox = new JComboBox<String>(this.getbasedirs(gamedir));
        Font ffont = filebox.getFont();
        filebox.setFont(new Font(ffont.getName(), 0, ffont.getSize() - 1));
        filebox.setToolTipText("Base game directory to scan");
        filebox.setPreferredSize(new Dimension(450, filebox.getPreferredSize().height));
        topbox.add(filebox);
        filebox.setEditable(true);
        topbox.add(Box.createHorizontalGlue());
        final JButton scanb = new JButton("Scan");
        scanb.setToolTipText("Perform file scan");
        scanb.setMnemonic(83);
        topbox.add(scanb);
        Box controls = Box.createHorizontalBox();
        final JButton selall = new JButton("Select All");
        selall.setToolTipText("Select all On Disk files");
        selall.setMnemonic(69);
        controls.add(selall);
        selall.setEnabled(false);
        final JButton selnone = new JButton("Select None");
        selnone.setToolTipText("Clear selection");
        selnone.setMnemonic(78);
        controls.add(selnone);
        selnone.setEnabled(false);
        controls.add(Box.createHorizontalStrut(40));
        final JButton check = new JButton("Reference");
        check.setToolTipText("Check file reference");
        check.setMnemonic(82);
        check.setEnabled(false);
        controls.add(check);
        controls.add(Box.createHorizontalGlue());
        final JButton addsel = new JButton("Add Selected");
        addsel.setToolTipText("Add selected file(s) to the pak");
        addsel.setMnemonic(65);
        controls.add(addsel);
        addsel.setEnabled(false);
        JButton cancel = new JButton("Done");
        cancel.setToolTipText("Close scan window");
        cancel.setMnemonic(68);
        controls.add(cancel);
        this.stable.setAutoResizeMode(1);
        this.stable.setSelectionMode(0);
        this.stable.getColumn(ScanModel.header[2]).setMaxWidth(78);
        this.stable.getColumn(ScanModel.header[3]).setMaxWidth(60);
        this.stable.getColumn(ScanModel.header[4]).setMaxWidth(24);
        this.stable.getColumn(ScanModel.header[3]).setCellRenderer(new ScanTCR());
        this.stable.getColumn(ScanModel.header[4]).setCellRenderer(new ScanTCBR());
        JScrollPane stablesp = new JScrollPane(this.stable);
        stablesp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6), BorderFactory.createEtchedBorder()));
        spanel.add((Component)stablesp, "Center");
        spanel.add((Component)controls, "South");
        spanel.add((Component)topbox, "North");
        this.sframe.setDefaultCloseOperation(2);
        this.sframe.setSize(640, 400);
        this.sframe.getContentPane().add(spanel);
        this.sframe.setVisible(true);
        scanb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scan.this.basedir = (String)filebox.getSelectedItem();
                Scan.this.addbasedir(Scan.this.basedir);
                Scan.this.sframe.setCursor(Cursor.getPredefinedCursor(3));
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        Scan.this.doscan();
                        return null;
                    }

                    public void finished() {
                        Scan.this.smodel.update();
                        Scan.this.sframe.setCursor(Cursor.getDefaultCursor());
                        selall.setEnabled(true);
                        selnone.setEnabled(true);
                        addsel.setEnabled(Scan.this.smodel.setallselected());
                    }
                };
                worker.start();
            }
        });
        addsel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scan.this.addselected();
                scanb.doClick();
            }
        });
        selall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                addsel.setEnabled(Scan.this.smodel.setallselected());
            }
        });
        selnone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scan.this.smodel.resetallselected();
                addsel.setEnabled(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scan.this.close();
            }
        });
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scan.this.docheck(Scan.this.smodel.getfile(Scan.this.stable.getSelectedRow()));
            }
        });
        ListSelectionModel tabsel = this.stable.getSelectionModel();
        tabsel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (lse.getValueIsAdjusting()) {
                    return;
                }
                if (Scan.this.stable.getSelectedRowCount() == 0) {
                    check.setEnabled(false);
                } else {
                    check.setEnabled(true);
                }
                if (Scan.this.smodel.noneselected()) {
                    addsel.setEnabled(false);
                } else {
                    addsel.setEnabled(true);
                }
            }
        });
    }

    public void docheck(Scanfile s) {
        StringBuffer t = new StringBuffer("File: " + s.fullname + "\n");
        t.append("Type: " + ScanModel.tstr[s.type] + "\n");
        t.append("Diskname: " + s.diskname + "\n");
        t.append("Location: ");
        if (s.inpak) {
            t.append("In Pak  ");
        } else if (s.inlist) {
            t.append("In Pak List  ");
        }
        if (s.ondisk) {
            t.append("On Disk");
        }
        if (!(s.inpak || s.inlist || s.ondisk)) {
            t.append("Not Found");
        }
        t.append("\n");
        this.checkparent(s, t);
        JTextArea textarea = new JTextArea(t.toString());
        textarea.setEditable(false);
        JFrame tframe = new JFrame("Pakrat - Check File Reference - " + s.listname);
        tframe.setLocationRelativeTo(this.sframe);
        tframe.setSize(550, 250);
        tframe.getContentPane().add(new JScrollPane(textarea));
        tframe.setDefaultCloseOperation(2);
        tframe.setVisible(true);
    }

    public void checkparent(Scanfile s, StringBuffer t) {
        if (s == null) {
            return;
        }
        if (s.parent == null) {
            return;
        }
        t.append("\nReferenced from:\n");
        if (s.parent == Scanfile.ENTITY) {
            t.append("    Entity list - " + s.referent + "\n");
            return;
        }
        if (s.parent == Scanfile.STATIC) {
            t.append("    Prop_static list\n");
            return;
        }
        if (s.parent == Scanfile.DETAIL) {
            t.append("    Prop_detail list\n");
            return;
        }
        if (s.parent == Scanfile.TEXTURE) {
            t.append("    Map material list\n");
            return;
        }
        if (s.parent == Scanfile.OTHER) {
            t.append("    Extra file list\n");
            return;
        }
        t.append("    File: " + s.parent.fullname + " - keyword \"" + s.referent + "\"\n");
        this.checkparent(s.parent, t);
    }

    public String[] getbasedirs(String gamedir) {
        this.dirset.clear();
        for (int i = 0; i < 6; ++i) {
            String dir = Pakpref.get("Basedir" + i, null);
            if (dir == null) continue;
            this.dirset.add(dir);
        }
        this.dirset.add(gamedir);
        String mapbase = this.pakrat.infile.getPath().replace(File.separatorChar, '/');
        int im = mapbase.toLowerCase().lastIndexOf("maps/");
        if (im > 0) {
            mapbase = mapbase.substring(0, im - 1);
            this.dirset.add(mapbase);
        }
        this.compactbasedirs();
        return this.dirset.toArray(new String[0]);
    }

    public void addbasedir(String dir) {
        this.dirset.add(0, dir);
        this.compactbasedirs();
        String[] dirs = this.dirset.toArray(new String[0]);
        for (int i = 0; i < dirs.length && i != 6; ++i) {
            Pakpref.put("Basedir" + i, dirs[i]);
        }
    }

    public void compactbasedirs() {
        int i;
        boolean[] marked = new boolean[this.dirset.size()];
        String[] dirs = this.dirset.toArray(new String[0]);
        for (i = 0; i < dirs.length; ++i) {
            marked[i] = false;
        }
        for (i = 0; i < dirs.length; ++i) {
            for (int j = i + 1; j < dirs.length; ++j) {
                if (!dirs[i].equals(dirs[j])) continue;
                marked[j] = true;
            }
        }
        for (i = dirs.length - 1; i >= 0; --i) {
            if (!marked[i]) continue;
            this.dirset.remove(i);
        }
    }

    public void addselected() {
        boolean all = false;
        File[] filearray = new File[this.smodel.numselected()];
        int j = 0;
        try {
            for (int i = 0; i < this.smodel.getRowCount(); ++i) {
                Scanfile sf = this.smodel.getfile(i);
                if (!sf.onlydisk()) continue;
                File sfile = new File(sf.diskname);
                if (!sfile.exists() || !sfile.canRead()) {
                    Cons.println("Couldn't read " + sfile + " from disk");
                    continue;
                }
                filearray[j++] = sfile;
            }
            this.pakrat.addfiletopak(filearray, this.basedir, false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void doautoscan(final Component parent) {
        String mapbase;
        int im;
        if (this.basedir.equals("") && (im = (mapbase = this.pakrat.infile.getPath().replace(File.separatorChar, '/')).toLowerCase().lastIndexOf("maps/")) > 0) {
            this.basedir = mapbase = mapbase.substring(0, im - 1);
        }
        if (this.auton) {
            this.doscan();
            if (this.autoaddfiles(null) == 0) {
                this.nofiles = true;
            }
        } else {
            parent.setCursor(Cursor.getPredefinedCursor(3));
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    Scan.this.doscan();
                    return null;
                }

                public void finished() {
                    parent.setCursor(Cursor.getDefaultCursor());
                    Scan.this.autoaddfiles(parent);
                }
            };
            worker.start();
        }
    }

    public int autoaddfiles(Component parent) {
        Iterator<Scanfile> fit = this.files.iterator();
        while (fit.hasNext()) {
            if (fit.next().onlydisk()) continue;
            fit.remove();
        }
        if (this.files.size() == 0) {
            if (this.auton) {
                Cons.println("Found no files to add.");
            } else {
                JOptionPane.showMessageDialog(parent, "Found no files to add.", "Auto Scan", 1);
            }
            return 0;
        }
        if (this.auton) {
            Cons.println("Found " + this.files.size() + " referenced file(s) on disk.");
        } else {
            int res = JOptionPane.showConfirmDialog(parent, new Object[]{"Found " + this.files.size() + " file(s) on disk.", "Add them to the Pak?"}, "Auto Scan", 0);
            if (res == 1) {
                return 0;
            }
        }
        File[] farray = new File[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            File sfile = new File(this.files.get((int)i).diskname);
            if (this.auton) {
                Cons.println(sfile);
            }
            if (!sfile.exists() || !sfile.canRead()) {
                Cons.println("Couldn't read " + sfile + " from disk");
                continue;
            }
            farray[i] = sfile;
        }
        try {
            this.pakrat.addfiletopak(farray, this.basedir, true);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return this.files.size();
    }

    public void doscan() {
        this.files.clear();
        try {
            if (!this.auton) {
                this.prog = new JProgFrame((Component)this.sframe, "Pakrat - Scanning for files...");
                this.prog.start("Textures...", true);
            }
            Cons.print("Scanning textures...");
            this.scantextures();
            if (!this.auton) {
                this.prog.setString("Prop_statics...");
                this.prog.setValue(0);
            }
            Cons.print("prop_statics...");
            this.scanstatics();
            if (!this.auton) {
                this.prog.setString("Prop_details...");
                this.prog.setValue(0);
            }
            Cons.print("prop_details...");
            this.scandetails();
            if (!this.auton) {
                this.prog.setString("Loading entities...");
                this.prog.setValue(0);
            }
            Cons.print("entities...");
            this.scanentities();
            if (!this.auton) {
                this.prog.setString("Extra files...");
                this.prog.setValue(0);
            }
            Cons.print("extras...");
            this.scanextras();
            if (!this.auton) {
                this.prog.end();
            }
            Cons.println(this.compactlist() + " duplicates removed");
            if (!this.auton) {
                int i;
                int i2;
                int pakfiles = this.tmod.getRowCount();
                boolean[] refd = new boolean[pakfiles];
                String mapname = this.pakrat.infile.getName().toLowerCase();
                String cubemappath = "materials/maps/" + mapname.substring(0, mapname.lastIndexOf(".bsp"));
                for (i2 = 0; i2 < pakfiles; ++i2) {
                    refd[i2] = this.tmod.getzipfile((int)i2).pathname.startsWith(cubemappath);
                }
                for (i2 = 0; i2 < this.files.size(); ++i2) {
                    int row;
                    Scanfile s = this.files.get(i2);
                    if (s.zip == null || (row = this.tmod.getrow(s.zip)) == -1) continue;
                    refd[row] = true;
                }
                int rcount = 0;
                for (i = 0; i < pakfiles; ++i) {
                    if (!refd[i]) continue;
                    ++rcount;
                }
                if (rcount != pakfiles) {
                    Cons.println(pakfiles - rcount + " files in Pak were not referenced in scan (excluding cubemaps):");
                    for (i = 0; i < pakfiles; ++i) {
                        if (refd[i]) continue;
                        Cons.println("  " + this.tmod.getzipfile(i).toString());
                    }
                    Cons.println();
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public void close() {
        if (this.sframe != null) {
            this.sframe.dispose();
        }
        this.sframe = null;
    }

    public void scanextras() throws IOException {
        Scanfile sfile;
        if (!this.auton) {
            this.prog.setMaximum(7);
        }
        String mapname = this.pakrat.infile.getName().toLowerCase();
        mapname = mapname.substring(0, mapname.lastIndexOf(".bsp"));
        if (!this.auton) {
            if (Pakpref.navfile) {
                sfile = new Scanfile("maps/" + mapname + ".nav", this.tmod, this.basedir, 9, Scanfile.OTHER, "");
                this.prog.setValue(1);
                this.files.add(sfile);
            }
            if (Pakpref.ainfile) {
                sfile = new Scanfile("maps/graphs/" + mapname + ".ain", this.tmod, this.basedir, 10, Scanfile.OTHER, "");
                this.prog.setValue(2);
                this.files.add(sfile);
            }
            if (Pakpref.soundcache) {
                sfile = new Scanfile("maps/soundcache/" + mapname + ".cache", this.tmod, this.basedir, 12, Scanfile.OTHER, "");
                this.prog.setValue(3);
                this.files.add(sfile);
            }
        }
        if (Pakpref.description) {
            sfile = new Scanfile("maps/" + mapname + ".txt", this.tmod, this.basedir, 11, Scanfile.OTHER, "");
            if (!this.auton) {
                this.prog.setValue(4);
            }
            this.files.add(sfile);
        }
        if (Pakpref.overview) {
            sfile = new Scanfile("resource/overviews/" + mapname + ".txt", this.tmod, this.basedir, 11, Scanfile.OTHER, "");
            if (!this.auton) {
                this.prog.setValue(5);
            }
            this.files.add(sfile);
            this.files.addAll(this.checksubfile(sfile));
        }
        if (Pakpref.soundscape) {
            sfile = new Scanfile("scripts/soundscapes_" + mapname + ".txt", this.tmod, this.basedir, 11, Scanfile.OTHER, "");
            if (!this.auton) {
                this.prog.setValue(6);
            }
            this.files.add(sfile);
            this.files.addAll(this.checksubfile(sfile));
        }
        if (!this.auton) {
            this.prog.setValue(7);
        }
    }

    public void scanentities() throws IOException {
        this.m.loadentities(this.raf, this.prog);
        if (!this.auton) {
            this.prog.setString("Entities...");
        }
        if (!this.auton) {
            this.prog.setMaximum(this.m.entvallist.size());
        }
        for (int i = 0; i < this.m.entvallist.size(); ++i) {
            if (!this.auton) {
                this.prog.setValue(i);
            }
            String name = this.m.entvallist.get(i);
            String ref = this.m.entkeylist.get(i);
            Scanfile sfile = new Scanfile(name, this.tmod, this.basedir, Scanfile.gettype(name), Scanfile.ENTITY, ref);
            this.files.add(sfile);
            this.files.addAll(this.checksubfile(sfile));
        }
    }

    public void scanstatics() throws IOException {
        if (!this.auton) {
            this.prog.setMaximum(this.m.staticname.length);
        }
        for (int i = 0; i < this.m.staticname.length; ++i) {
            if (!this.auton) {
                this.prog.setValue(i);
            }
            Scanfile sfile = new Scanfile(this.m.staticname[i], this.tmod, this.basedir, 3, Scanfile.STATIC, "");
            this.files.add(sfile);
            this.files.addAll(this.checksubfile(sfile));
        }
    }

    public void scandetails() throws IOException {
        if (!this.auton) {
            this.prog.setMaximum(this.m.detailname.length);
        }
        for (int i = 0; i < this.m.detailname.length; ++i) {
            if (!this.auton) {
                this.prog.setValue(i);
            }
            Scanfile sfile = new Scanfile(this.m.detailname[i], this.tmod, this.basedir, 3, Scanfile.DETAIL, "");
            this.files.add(sfile);
            this.files.addAll(this.checksubfile(sfile));
        }
    }

    public void scantextures() throws IOException {
        if (!this.auton) {
            this.prog.setMaximum(this.m.texname.length);
        }
        for (int i = 0; i < this.m.texname.length; ++i) {
            if (!this.auton) {
                this.prog.setValue(i);
            }
            Scanfile sfile = new Scanfile(this.m.texname[i], this.tmod, this.basedir, 1, Scanfile.TEXTURE, "");
            this.files.add(sfile);
            this.files.addAll(this.checksubfile(sfile));
        }
    }

    public ArrayList<Scanfile> checksubfile(Scanfile sf) throws IOException {
        ArrayList<Scanfile> subfiles = new ArrayList<Scanfile>();
        if (sf.inlist || sf.ondisk) {
            switch (sf.type) {
                case 1: {
                    subfiles = this.getreffromvmt(sf);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    subfiles = this.getreffrommdl(sf);
                    break;
                }
                case 5: {
                    subfiles = this.getreffromphy(sf);
                    break;
                }
                case 11: {
                    if (!sf.fullname.startsWith("resource/overviews/") && !sf.fullname.startsWith("scripts/soundscapes_")) break;
                    subfiles = this.getreffromtxt(sf);
                    break;
                }
            }
        }
        return subfiles;
    }

    public ArrayList<Scanfile> getreffromphy(Scanfile s) throws IOException {
        ArrayList<Scanfile> sublist = new ArrayList<Scanfile>();
        if (!s.inlist && !s.ondisk) {
            return sublist;
        }
        ByteBuffer buff = this.getfilebuffer(s);
        if (buff == null) {
            return sublist;
        }
        buff.order(ByteOrder.LITTLE_ENDIAN);
        Phymdl phy = new Phymdl();
        phy.read(buff);
        if (!phy.isValid) {
            Cons.println("Failed to read model physics file");
            return sublist;
        }
        for (int j = 0; j < phy.gibmodel.size(); ++j) {
            Scanfile sfile = new Scanfile(phy.gibmodel.get(j), this.tmod, this.basedir, 3, s, "gib model");
            sublist.add(sfile);
            sublist.addAll(this.checksubfile(sfile));
        }
        return sublist;
    }

    public ArrayList<Scanfile> getreffrommdl(Scanfile s) throws IOException {
        Scanfile sfile;
        int j;
        ArrayList<Scanfile> sublist = new ArrayList<Scanfile>();
        String basename = s.name;
        for (int i = 0; i < mdlext.length; ++i) {
            String name = basename + mdlext[i];
            Scanfile sfile2 = new Scanfile(name, this.tmod, this.basedir, Scanfile.gettype(name), s, "datafile");
            sublist.add(sfile2);
            sublist.addAll(this.checksubfile(sfile2));
        }
        if (!s.inlist && !s.ondisk) {
            return sublist;
        }
        ByteBuffer buff = this.getfilebuffer(s);
        if (buff == null) {
            return sublist;
        }
        buff.order(ByteOrder.LITTLE_ENDIAN);
        Mdl model = new Mdl();
        model.read(buff);
        if (!model.isValid) {
            Cons.println("Failed to read model");
            return sublist;
        }
        ArrayList<String> texturelist = model.gettexturelist();
        for (j = 0; j < texturelist.size(); ++j) {
            sfile = new Scanfile(texturelist.get(j), this.tmod, this.basedir, 1, s, "texture");
            sublist.add(sfile);
            sublist.addAll(this.checksubfile(sfile));
        }
        for (j = 0; j < model.numincmodels; ++j) {
            sfile = new Scanfile(model.incmodelfile[j], this.tmod, this.basedir, 3, s, "include model");
            sublist.add(sfile);
            sublist.addAll(this.checksubfile(sfile));
        }
        return sublist;
    }

    public ArrayList<Scanfile> getreffromtxt(Scanfile s) throws IOException {
        ArrayList<Scanfile> sublist = new ArrayList<Scanfile>();
        if (!s.inlist && !s.ondisk) {
            return sublist;
        }
        ByteBuffer buff = this.getfilebuffer(s);
        if (buff == null) {
            return sublist;
        }
        while ((long)buff.position() < s.length) {
            Scanfile ssfile;
            String[] token;
            String line = this.readline(buff).trim();
            if (line.length() == 0) continue;
            int ic = line.indexOf("//");
            if (ic > -1) {
                line = line.substring(0, ic);
            }
            if ((token = this.tokenize(line)).length != 2) continue;
            if (token[0].equalsIgnoreCase("material")) {
                ssfile = new Scanfile(token[1], this.tmod, this.basedir, 1, s, "material");
                sublist.add(ssfile);
                ArrayList<Scanfile> subsublist = this.getreffromvmt(ssfile);
                for (int j = 0; j < subsublist.size(); ++j) {
                    sublist.add(subsublist.get(j));
                }
                continue;
            }
            if (!token[0].equalsIgnoreCase("wave")) continue;
            ssfile = new Scanfile(token[1], this.tmod, this.basedir, 7, s, "wave");
            sublist.add(ssfile);
        }
        return sublist;
    }

    public ArrayList<Scanfile> getreffromvmt(Scanfile s) throws IOException {
        ArrayList<Scanfile> sublist = new ArrayList<Scanfile>();
        if (!s.inlist && !s.ondisk) {
            return sublist;
        }
        ByteBuffer buff = this.getfilebuffer(s);
        if (buff == null) {
            return sublist;
        }
        while ((long)buff.position() < s.length) {
            int i;
            String[] token;
            String line = this.readline(buff).trim();
            if (line.length() == 0) continue;
            int ic = line.indexOf("//");
            if (ic > -1) {
                line = line.substring(0, ic);
            }
            if ((token = this.tokenize(line)).length != 2 || token[1].startsWith("_")) continue;
            for (i = 0; i < matmatref.length; ++i) {
                if (!token[0].equalsIgnoreCase(matmatref[i])) continue;
                Scanfile ssfile = new Scanfile(token[1], this.tmod, this.basedir, 1, s, token[0]);
                sublist.add(ssfile);
                ArrayList<Scanfile> subsublist = this.getreffromvmt(ssfile);
                for (int j = 0; j < subsublist.size(); ++j) {
                    sublist.add(subsublist.get(j));
                }
            }
            for (i = 0; i < mattexref.length; ++i) {
                Scanfile vfile;
                if (!token[0].equalsIgnoreCase(mattexref[i])) continue;
                if (mattexref[i].equals("$envmap")) {
                    if (token[1].equalsIgnoreCase("env_cubemap")) continue;
                    vfile = new Scanfile(token[1], this.tmod, this.basedir, 2, s, token[0]);
                    sublist.add(vfile);
                    continue;
                }
                vfile = new Scanfile(token[1], this.tmod, this.basedir, 2, s, token[0]);
                sublist.add(vfile);
            }
        }
        return sublist;
    }

    public String[] tokenize(String line) {
        ArrayList<String> token = new ArrayList<String>();
        Matcher match = Pattern.compile("\\S+").matcher(line);
        while (match.find()) {
            token.add(this.antiquine(match.group()));
        }
        return token.toArray(new String[0]);
    }

    public String antiquine(String in) {
        String[] tok = in.split("\"");
        if (tok.length < 2) {
            return in;
        }
        return tok[1];
    }

    public int compactlist() {
        for (int i = 0; i < this.files.size(); ++i) {
            Scanfile ifile = this.files.get(i);
            if (ifile.mark) continue;
            for (int j = i + 1; j < this.files.size(); ++j) {
                Scanfile jfile = this.files.get(j);
                if (!ifile.name.equals(jfile.name) || ifile.type != jfile.type) continue;
                jfile.mark = true;
            }
        }
        int count = 0;
        Iterator<Scanfile> fit = this.files.iterator();
        while (fit.hasNext()) {
            if (!fit.next().mark) continue;
            fit.remove();
            ++count;
        }
        return count;
    }

    public String readline(ByteBuffer b) {
        StringBuffer linebuff = new StringBuffer();
        try {
            char c;
            while ((c = (char)b.get()) != '\n' && c != '\r') {
                linebuff.append(c);
            }
            return linebuff.toString();
        }
        catch (BufferUnderflowException bue) {
            return linebuff.toString();
        }
    }

    public String readstr(ByteBuffer b) {
        char c;
        StringBuffer linebuff = new StringBuffer();
        while ((c = (char)b.get()) != '\u0000') {
            linebuff.append(c);
        }
        return linebuff.toString();
    }

    public ByteBuffer getfilebuffer(Scanfile s) throws IOException {
        long bufflen;
        ByteBuffer buff;
        if (s.inlist) {
            int off = this.tmod.getoffset();
            if (s.inpak) {
                this.raf.seek(off + s.zip.datofs);
                byte[] buffer = new byte[s.zip.size];
                this.raf.read(buffer);
                buff = ByteBuffer.wrap(buffer);
            } else {
                buff = ByteBuffer.wrap(s.zip.data);
            }
            bufflen = s.zip.size;
        } else {
            File diskfile = new File(s.diskname);
            if (!diskfile.exists() || !diskfile.canRead()) {
                Cons.println("Couldn't read " + diskfile + " from disk");
                return null;
            }
            RandomAccessFile sraf = new RandomAccessFile(diskfile, "r");
            bufflen = diskfile.length();
            byte[] buffer = new byte[(int)bufflen];
            sraf.read(buffer);
            buff = ByteBuffer.wrap(buffer);
            sraf.close();
        }
        s.length = bufflen;
        return buff;
    }
}

