/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import info.ata4.io.lzma.LzmaDecoderProps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;
import lzma.LzmaDecoder;
import net.contrapunctus.lzma.ConcurrentBufferOutputStream;

class DecoderThread
extends Thread {
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;
    protected ArrayBlockingQueue<byte[]> q;
    protected InputStream in;
    protected OutputStream out;
    protected LzmaDecoder dec;
    protected LzmaDecoderProps props = new LzmaDecoderProps();
    protected IOException exn;

    DecoderThread(InputStream _in) {
        this.q = ConcurrentBufferOutputStream.newQueue();
        this.in = _in;
        this.out = ConcurrentBufferOutputStream.create(this.q);
        this.dec = new LzmaDecoder();
        this.exn = null;
        if (DEBUG) {
            dbg.printf("%s >> %s (%s)%n", this, this.out, this.q);
        }
    }

    public void run() {
        block8: {
            try {
                try {
                    this.props.fromInputStream(this.in);
                }
                catch (IllegalArgumentException ex) {
                    throw new IOException("Invalid LZMA properties", ex);
                }
                this.props.apply(this.dec);
                if (DEBUG) {
                    dbg.printf("%s begins%n", this);
                }
                this.dec.code(this.in, this.out, this.props.getUncompressedSize());
                if (DEBUG) {
                    dbg.printf("%s ends%n", this);
                }
                this.in.close();
            }
            catch (IOException _exn) {
                this.exn = _exn;
                if (!DEBUG) break block8;
                dbg.printf("%s exception: %s%n", this, this.exn.getMessage());
            }
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void maybeThrow() throws IOException {
        if (this.exn != null) {
            throw this.exn;
        }
    }

    public LzmaDecoderProps getProps() {
        return this.props;
    }

    public String toString() {
        return String.format("Dec@%x", this.hashCode());
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_LzmaCoders");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
    }
}

