/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.file;

import info.ata4.io.DataReader;
import info.ata4.io.DataReaders;
import info.ata4.io.DataWriter;
import info.ata4.io.DataWriters;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public abstract class FileHandler {
    protected Path sourceFile;

    public void load(Path file) throws IOException {
        this.sourceFile = file;
        this.load(DataReaders.forFile(file, StandardOpenOption.READ));
    }

    public abstract void load(DataReader var1) throws IOException;

    public void save(Path file) throws IOException {
        this.sourceFile = file;
        this.save(DataWriters.forFile(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
    }

    public abstract void save(DataWriter var1) throws IOException;

    public Path getSourceFile() {
        return this.sourceFile;
    }
}

