/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.vector;

import info.ata4.bsplib.vector.VectorXf;
import info.ata4.io.DataReader;
import info.ata4.io.DataWriter;
import java.io.IOException;

public final class Vector3f
extends VectorXf {
    public static final Vector3f NULL = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f MAX_VALUE = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    public static final Vector3f MIN_VALUE = MAX_VALUE.scalar(-1.0f);
    public final float x;
    public final float y;
    public final float z;

    public static Vector3f read(DataReader in) throws IOException {
        float x = in.readFloat();
        float y = in.readFloat();
        float z = in.readFloat();
        return new Vector3f(x, y, z);
    }

    public static void write(DataWriter out, Vector3f vec) throws IOException {
        out.writeFloat(vec.x);
        out.writeFloat(vec.y);
        out.writeFloat(vec.z);
    }

    public Vector3f(Vector3f v) {
        this(v.x, v.y, v.z);
    }

    public Vector3f(float[] v) {
        this(v[0], v[1], v[2]);
    }

    public Vector3f(float x, float y, float z) {
        super(3);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public float get(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return 0.0f;
    }

    @Override
    public Vector3f set(int index, float value) {
        switch (index) {
            case 0: {
                return new Vector3f(value, this.y, this.z);
            }
            case 1: {
                return new Vector3f(this.x, value, this.z);
            }
            case 2: {
                return new Vector3f(this.x, this.y, value);
            }
        }
        return this;
    }

    public float dot(Vector3f that) {
        return this.x * that.x + this.y * that.y + this.z * that.z;
    }

    public Vector3f cross(Vector3f that) {
        float rx = this.y * that.z - this.z * that.y;
        float ry = this.z * that.x - this.x * that.z;
        float rz = this.x * that.y - this.y * that.x;
        return new Vector3f(rx, ry, rz);
    }

    public Vector3f normalize() {
        float len = this.length();
        float rx = this.x / len;
        float ry = this.y / len;
        float rz = this.z / len;
        return new Vector3f(rx, ry, rz);
    }

    public Vector3f add(Vector3f that) {
        float rx = this.x + that.x;
        float ry = this.y + that.y;
        float rz = this.z + that.z;
        return new Vector3f(rx, ry, rz);
    }

    public Vector3f sub(Vector3f that) {
        float rx = this.x - that.x;
        float ry = this.y - that.y;
        float rz = this.z - that.z;
        return new Vector3f(rx, ry, rz);
    }

    public Vector3f snap(float value) {
        float rx = (float)Math.round(this.x / value) * value;
        float ry = (float)Math.round(this.y / value) * value;
        float rz = (float)Math.round(this.z / value) * value;
        return new Vector3f(rx, ry, rz);
    }

    public float length() {
        return (float)Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
    }

    public Vector3f scalar(float mul) {
        float rx = this.x * mul;
        float ry = this.y * mul;
        float rz = this.z * mul;
        return new Vector3f(rx, ry, rz);
    }

    public Vector3f scalar(Vector3f that) {
        float rx = this.x * that.x;
        float ry = this.y * that.y;
        float rz = this.z * that.z;
        return new Vector3f(rx, ry, rz);
    }

    public Vector3f rotate(Vector3f angles) {
        Point2d p;
        if (angles.x == 0.0f && angles.y == 0.0f && angles.z == 0.0f) {
            return this;
        }
        double rx = this.x;
        double ry = this.y;
        double rz = this.z;
        if (angles.x != 0.0f) {
            p = new Point2d(ry, rz).rotate(angles.x);
            ry = p.x;
            rz = p.y;
        }
        if (angles.y != 0.0f) {
            p = new Point2d(rx, rz).rotate(angles.y);
            rx = p.x;
            rz = p.y;
        }
        if (angles.z != 0.0f) {
            p = new Point2d(rx, ry).rotate(angles.z);
            rx = p.x;
            ry = p.y;
        }
        return new Vector3f((float)rx, (float)ry, (float)rz);
    }

    public Vector3f min(Vector3f that) {
        float rx = Math.min(this.x, that.x);
        float ry = Math.min(this.y, that.y);
        float rz = Math.min(this.z, that.z);
        return new Vector3f(rx, ry, rz);
    }

    public Vector3f max(Vector3f that) {
        float rx = Math.max(this.x, that.x);
        float ry = Math.max(this.y, that.y);
        float rz = Math.max(this.z, that.z);
        return new Vector3f(rx, ry, rz);
    }

    private class Point2d {
        private final double x;
        private final double y;

        private Point2d(double x, double y) {
            this.x = x;
            this.y = y;
        }

        private Point2d rotate(double angle) {
            if ((angle %= 360.0) == 0.0) {
                return this;
            }
            if (angle == 90.0) {
                return new Point2d(-this.y, this.x);
            }
            if (angle == 180.0) {
                return new Point2d(-this.x, -this.y);
            }
            if (angle == 270.0) {
                return new Point2d(this.y, -this.x);
            }
            angle = Math.toRadians(angle);
            double r = Math.hypot(this.x, this.y);
            double theta = Math.atan2(this.y, this.x);
            double rx = r * Math.cos(theta + angle);
            double ry = r * Math.sin(theta + angle);
            return new Point2d(rx, ry);
        }
    }
}

