/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspinfo.gui;

import info.ata4.bspinfo.gui.BspFileUtils;
import info.ata4.bspinfo.gui.models.EmbeddedTableModel;
import info.ata4.bspinfo.gui.models.EntityTableModel;
import info.ata4.bspinfo.gui.models.GameLumpTableModel;
import info.ata4.bspinfo.gui.models.LumpTableModel;
import info.ata4.bsplib.BspFile;
import info.ata4.bsplib.BspFileFilter;
import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.app.SourceApp;
import info.ata4.bsplib.entity.Entity;
import info.ata4.bsplib.lump.LumpType;
import info.ata4.bsplib.struct.BspData;
import info.ata4.bspsrc.modules.BspChecksum;
import info.ata4.bspsrc.modules.BspCompileParams;
import info.ata4.bspsrc.modules.BspDependencies;
import info.ata4.bspsrc.modules.BspProtection;
import info.ata4.bspsrc.modules.texture.TextureSource;
import info.ata4.log.DialogHandler;
import info.ata4.log.LogUtils;
import info.ata4.util.gui.FileDrop;
import info.ata4.util.gui.FileExtensionFilter;
import info.ata4.util.gui.components.ByteSizeCellRenderer;
import info.ata4.util.gui.components.DecimalFormatCellRenderer;
import info.ata4.util.gui.components.ProgressCellRenderer;
import info.ata4.util.gui.components.ReadOnlyCheckBox;
import info.ata4.util.gui.components.URILabel;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;

public class BspInfoFrame
extends JFrame {
    private static final Logger L = LogUtils.getLogger();
    public static final String NAME = "BSPInfo";
    public static final String VERSION = "1.3.24";
    private File currentFile;
    private BspFile bspFile;
    private BspFileReader bspReader;
    private FileDrop fdrop;
    private ReadOnlyCheckBox checkBoxBSPProtect;
    private ReadOnlyCheckBox checkBoxIIDObfs;
    private ReadOnlyCheckBox checkBoxIIDTexHack;
    private ReadOnlyCheckBox checkBoxVmexBrush;
    private ReadOnlyCheckBox checkBoxVmexEntity;
    private ReadOnlyCheckBox checkBoxVmexTexture;
    private JButton extractAllEmbeddedButton;
    private JButton extractAllGameLumpsButton;
    private JButton extractAllLumpsButton;
    private JButton extractEmbeddedButton;
    private JButton extractEmbeddedZipButton;
    private JButton extractGameLumpButton;
    private JButton extractLumpButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JLabel labelAppID;
    private JLabel labelComment;
    private JLabel labelCompressed;
    private JLabel labelEndian;
    private JLabel labelFileCRC;
    private JLabel labelGame;
    private JLabel labelMapCRC;
    private JLabel labelName;
    private JLabel labelRevision;
    private JLabel labelVbsp;
    private JLabel labelVersion;
    private JLabel labelVrad;
    private JLabel labelVvis;
    private URILabel linkLabelAppURL;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JFileChooser openFileChooser;
    private JMenuItem openFileMenuItem;
    private JPanel panelChecksums;
    private JPanel panelCompileParams;
    private JPanel panelEmbedded;
    private JPanel panelEntities;
    private JPanel panelGame;
    private JPanel panelGameLumps;
    private JPanel panelGeneral;
    private JPanel panelHeaders;
    private JPanel panelIID;
    private JPanel panelLumps;
    private JPanel panelOther;
    private JPanel panelProt;
    private JPanel panelVmex;
    private JFileChooser saveDirectoryChooser;
    private JFileChooser saveZipFileChooser;
    private JScrollPane scrollPaneEmbedded;
    private JScrollPane scrollPaneGameLumps;
    private JScrollPane scrollPaneLumps;
    private JScrollPane scrollPaneMaterials;
    private JScrollPane scrollPaneModels;
    private JScrollPane scrollPaneParticles;
    private JScrollPane scrollPaneSoundScripts;
    private JScrollPane scrollPaneSounds;
    private JScrollPane scrollPaneSoundscapes;
    private JTabbedPane tabbedPane;
    private JTabbedPane tabbedPaneDependencies;
    private JTable tableEmbedded;
    private JTable tableEntities;
    private JTable tableGameLumps;
    private JTable tableLumps;
    private JTextArea textAreaMaterials;
    private JTextArea textAreaModels;
    private JTextArea textAreaParticles;
    private JTextArea textAreaSoundScripts;
    private JTextArea textAreaSounds;
    private JTextArea textAreaSoundscapes;
    private JTextField textFieldAppID;
    private JTextField textFieldBrushEnts;
    private JTextField textFieldComment;
    private JTextField textFieldCompressed;
    private JTextField textFieldEndian;
    private JTextField textFieldFileCRC;
    private JTextField textFieldGame;
    private JTextField textFieldMapCRC;
    private JTextField textFieldName;
    private JTextField textFieldPointEnts;
    private JTextField textFieldRevision;
    private JTextField textFieldTotalEnts;
    private JTextField textFieldVbspParams;
    private JTextField textFieldVersion;
    private JTextField textFieldVradParams;
    private JTextField textFieldVvisParams;

    public static void main(String[] args) {
        LogUtils.configure();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            L.warning("Failed to set SystemLookAndFeel");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new BspInfoFrame().setVisible(true);
            }
        });
    }

    public BspInfoFrame() {
        this.initComponents();
        this.initComponentsCustom();
        this.fdrop = new FileDrop(this, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                BspFileFilter filter = new BspFileFilter();
                if (filter.accept(files[0])) {
                    BspInfoFrame.this.loadFile(files[0]);
                }
            }
        });
        L.addHandler(new DialogHandler(this));
    }

    public final void reset() {
        this.textFieldName.setText(null);
        this.textFieldVersion.setText(null);
        this.textFieldRevision.setText(null);
        this.textFieldCompressed.setText(null);
        this.textFieldEndian.setText(null);
        this.textFieldAppID.setText(null);
        this.textFieldGame.setText(null);
        this.linkLabelAppURL.setText(null);
        this.textFieldFileCRC.setText(null);
        this.textFieldMapCRC.setText(null);
        this.textFieldVbspParams.setText(null);
        this.textFieldVvisParams.setText(null);
        this.textFieldVradParams.setText(null);
        this.checkBoxVmexEntity.setSelected(false);
        this.checkBoxVmexTexture.setSelected(false);
        this.checkBoxVmexBrush.setSelected(false);
        this.checkBoxIIDObfs.setSelected(false);
        this.checkBoxIIDTexHack.setSelected(false);
        this.checkBoxBSPProtect.setSelected(false);
        this.tableLumps.setModel(new LumpTableModel());
        this.textFieldTotalEnts.setText(null);
        this.textFieldBrushEnts.setText(null);
        this.textFieldPointEnts.setText(null);
        this.tableEntities.setModel(new EntityTableModel());
        this.textAreaMaterials.setText(null);
        this.textAreaSounds.setText(null);
        this.textAreaSoundScripts.setText(null);
        this.textAreaSoundscapes.setText(null);
        this.textAreaModels.setText(null);
        this.textAreaParticles.setText(null);
        this.tableEmbedded.setModel(new EmbeddedTableModel());
        this.extractLumpButton.setEnabled(false);
        this.extractAllLumpsButton.setEnabled(false);
        this.extractGameLumpButton.setEnabled(false);
        this.extractAllGameLumpsButton.setEnabled(false);
        this.extractEmbeddedButton.setEnabled(false);
        this.extractAllEmbeddedButton.setEnabled(false);
        this.extractEmbeddedZipButton.setEnabled(false);
    }

    public void loadFile(File file) {
        this.currentFile = file;
        this.setTitle("BSPInfo 1.3.24 - " + file.getName());
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BspInfoFrame.this.reset();
                BspInfoFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    BspInfoFrame.this.bspFile = new BspFile();
                    BspInfoFrame.this.bspFile.load(BspInfoFrame.this.currentFile.toPath());
                    boolean compressed = BspInfoFrame.this.bspFile.isCompressed();
                    BspInfoFrame.this.bspReader = new BspFileReader(BspInfoFrame.this.bspFile);
                    BspInfoFrame.this.bspReader.loadEntities();
                    BspData data = BspInfoFrame.this.bspReader.getData();
                    BspInfoFrame.this.textFieldName.setText(BspInfoFrame.this.bspFile.getName());
                    BspInfoFrame.this.textFieldVersion.setText(String.valueOf(BspInfoFrame.this.bspFile.getVersion()));
                    BspInfoFrame.this.textFieldRevision.setText(String.valueOf(BspInfoFrame.this.bspFile.getRevision()));
                    BspInfoFrame.this.textFieldCompressed.setText(compressed ? "Yes" : "No");
                    BspInfoFrame.this.textFieldEndian.setText(BspInfoFrame.this.bspFile.getByteOrder() == ByteOrder.LITTLE_ENDIAN ? "Little endian" : "Big endian");
                    if (data.entities != null && !data.entities.isEmpty()) {
                        Entity worldspawn = data.entities.get(0);
                        BspInfoFrame.this.textFieldComment.setText(worldspawn.getValue("comment"));
                    }
                    SourceApp app = BspInfoFrame.this.bspFile.getSourceApp();
                    BspInfoFrame.this.textFieldAppID.setText(app.getAppID() > 0 ? String.valueOf(app.getAppID()) : "n/a");
                    BspInfoFrame.this.textFieldGame.setText(app.getName());
                    URI steamStoreURI = app.getSteamStoreURI();
                    if (steamStoreURI != null) {
                        BspInfoFrame.this.linkLabelAppURL.setURI("Steam store link", steamStoreURI);
                    }
                    BspCompileParams cparams = new BspCompileParams(BspInfoFrame.this.bspReader);
                    BspInfoFrame.this.textFieldVbspParams.setText(StringUtils.join(cparams.getVbspParams(), ' '));
                    if (cparams.isVvisRun()) {
                        BspInfoFrame.this.textFieldVvisParams.setText(StringUtils.join(cparams.getVvisParams(), ' '));
                    } else {
                        BspInfoFrame.this.textFieldVvisParams.setText("(not run)");
                    }
                    if (cparams.isVradRun()) {
                        BspInfoFrame.this.textFieldVradParams.setText(StringUtils.join(cparams.getVradParams(), ' '));
                    } else {
                        BspInfoFrame.this.textFieldVradParams.setText("(not run)");
                    }
                    TextureSource texsrc = new TextureSource(BspInfoFrame.this.bspReader);
                    BspProtection prot = new BspProtection(BspInfoFrame.this.bspReader, texsrc);
                    prot.check();
                    BspInfoFrame.this.checkBoxVmexEntity.setSelected(prot.hasEntityFlag());
                    BspInfoFrame.this.checkBoxVmexTexture.setSelected(prot.hasTextureFlag());
                    BspInfoFrame.this.checkBoxVmexBrush.setSelected(prot.hasBrushFlag());
                    BspInfoFrame.this.checkBoxIIDObfs.setSelected(prot.hasObfuscatedEntities());
                    BspInfoFrame.this.checkBoxIIDTexHack.setSelected(prot.hasModifiedTexinfo());
                    BspInfoFrame.this.checkBoxBSPProtect.setSelected(prot.hasEncryptedEntities());
                    BspInfoFrame.this.tableLumps.setModel(new LumpTableModel(BspInfoFrame.this.bspFile));
                    BspInfoFrame.this.tableGameLumps.setModel(new GameLumpTableModel(BspInfoFrame.this.bspFile));
                    int brushEnts = 0;
                    int pointEnts = 0;
                    List<Entity> entities = ((BspInfoFrame)BspInfoFrame.this).bspReader.getData().entities;
                    for (Entity ent : entities) {
                        if (ent.getModelNum() > 0) {
                            ++brushEnts;
                            continue;
                        }
                        ++pointEnts;
                    }
                    int totalEnts = pointEnts + brushEnts;
                    DecimalFormat df = new DecimalFormat("#,##0");
                    BspInfoFrame.this.textFieldTotalEnts.setText(df.format(totalEnts));
                    BspInfoFrame.this.textFieldBrushEnts.setText(df.format(brushEnts));
                    BspInfoFrame.this.textFieldPointEnts.setText(df.format(pointEnts));
                    BspInfoFrame.this.tableEntities.setModel(new EntityTableModel(BspInfoFrame.this.bspReader));
                    BspDependencies bspres = new BspDependencies(BspInfoFrame.this.bspReader);
                    BspInfoFrame.this.fillTextArea(BspInfoFrame.this.textAreaMaterials, bspres.getMaterials());
                    BspInfoFrame.this.fillTextArea(BspInfoFrame.this.textAreaSounds, bspres.getSoundFiles());
                    BspInfoFrame.this.fillTextArea(BspInfoFrame.this.textAreaSoundScripts, bspres.getSoundScripts());
                    BspInfoFrame.this.fillTextArea(BspInfoFrame.this.textAreaSoundscapes, bspres.getSoundscapes());
                    BspInfoFrame.this.fillTextArea(BspInfoFrame.this.textAreaModels, bspres.getModels());
                    BspInfoFrame.this.fillTextArea(BspInfoFrame.this.textAreaParticles, bspres.getParticles());
                    BspInfoFrame.this.tableEmbedded.setModel(new EmbeddedTableModel(BspInfoFrame.this.bspFile));
                    BspChecksum checksum = new BspChecksum(BspInfoFrame.this.bspReader);
                    BspInfoFrame.this.textFieldFileCRC.setText(String.format("%x", checksum.getFileCRC()));
                    BspInfoFrame.this.textFieldMapCRC.setText(String.format("%x", checksum.getMapCRC()));
                    BspInfoFrame.this.extractLumpButton.setEnabled(true);
                    BspInfoFrame.this.extractAllLumpsButton.setEnabled(true);
                    BspInfoFrame.this.extractGameLumpButton.setEnabled(true);
                    BspInfoFrame.this.extractAllGameLumpsButton.setEnabled(true);
                    BspInfoFrame.this.extractEmbeddedButton.setEnabled(true);
                    BspInfoFrame.this.extractAllEmbeddedButton.setEnabled(true);
                    BspInfoFrame.this.extractEmbeddedZipButton.setEnabled(true);
                }
                catch (Exception ex) {
                    L.log(Level.SEVERE, "Couldn't read BSP file", ex);
                }
                finally {
                    System.gc();
                    BspInfoFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }).start();
    }

    private void fillTextArea(JTextArea textArea, Collection<String> strings) {
        for (String string : strings) {
            textArea.append(string);
            textArea.append("\n");
        }
    }

    private void initComponents() {
        this.openFileChooser = new JFileChooser();
        this.saveDirectoryChooser = new JFileChooser();
        this.saveZipFileChooser = new JFileChooser();
        this.tabbedPane = new JTabbedPane();
        this.panelGeneral = new JPanel();
        this.panelGame = new JPanel();
        this.linkLabelAppURL = new URILabel();
        this.textFieldAppID = new JTextField();
        this.textFieldGame = new JTextField();
        this.labelAppID = new JLabel();
        this.labelGame = new JLabel();
        this.panelHeaders = new JPanel();
        this.textFieldEndian = new JTextField();
        this.textFieldCompressed = new JTextField();
        this.labelEndian = new JLabel();
        this.labelCompressed = new JLabel();
        this.textFieldVersion = new JTextField();
        this.labelVersion = new JLabel();
        this.textFieldName = new JTextField();
        this.labelName = new JLabel();
        this.textFieldRevision = new JTextField();
        this.labelRevision = new JLabel();
        this.labelComment = new JLabel();
        this.textFieldComment = new JTextField();
        this.panelChecksums = new JPanel();
        this.labelFileCRC = new JLabel();
        this.textFieldFileCRC = new JTextField();
        this.labelMapCRC = new JLabel();
        this.textFieldMapCRC = new JTextField();
        this.panelCompileParams = new JPanel();
        this.labelVbsp = new JLabel();
        this.textFieldVbspParams = new JTextField();
        this.labelVvis = new JLabel();
        this.textFieldVvisParams = new JTextField();
        this.labelVrad = new JLabel();
        this.textFieldVradParams = new JTextField();
        this.panelLumps = new JPanel();
        this.scrollPaneLumps = new JScrollPane();
        this.tableLumps = new JTable();
        this.extractLumpButton = new JButton();
        this.extractAllLumpsButton = new JButton();
        this.panelGameLumps = new JPanel();
        this.scrollPaneGameLumps = new JScrollPane();
        this.tableGameLumps = new JTable();
        this.extractGameLumpButton = new JButton();
        this.extractAllGameLumpsButton = new JButton();
        this.panelEntities = new JPanel();
        this.jLabel3 = new JLabel();
        this.textFieldPointEnts = new JTextField();
        this.jLabel2 = new JLabel();
        this.textFieldBrushEnts = new JTextField();
        this.textFieldTotalEnts = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableEntities = new JTable();
        this.tabbedPaneDependencies = new JTabbedPane();
        this.scrollPaneMaterials = new JScrollPane();
        this.textAreaMaterials = new JTextArea();
        this.scrollPaneSounds = new JScrollPane();
        this.textAreaSounds = new JTextArea();
        this.scrollPaneSoundScripts = new JScrollPane();
        this.textAreaSoundScripts = new JTextArea();
        this.scrollPaneSoundscapes = new JScrollPane();
        this.textAreaSoundscapes = new JTextArea();
        this.scrollPaneModels = new JScrollPane();
        this.textAreaModels = new JTextArea();
        this.scrollPaneParticles = new JScrollPane();
        this.textAreaParticles = new JTextArea();
        this.panelEmbedded = new JPanel();
        this.scrollPaneEmbedded = new JScrollPane();
        this.tableEmbedded = new JTable();
        this.extractEmbeddedButton = new JButton();
        this.extractAllEmbeddedButton = new JButton();
        this.extractEmbeddedZipButton = new JButton();
        this.panelProt = new JPanel();
        this.panelVmex = new JPanel();
        this.checkBoxVmexEntity = new ReadOnlyCheckBox();
        this.checkBoxVmexTexture = new ReadOnlyCheckBox();
        this.checkBoxVmexBrush = new ReadOnlyCheckBox();
        this.panelIID = new JPanel();
        this.checkBoxIIDObfs = new ReadOnlyCheckBox();
        this.checkBoxIIDTexHack = new ReadOnlyCheckBox();
        this.panelOther = new JPanel();
        this.checkBoxBSPProtect = new ReadOnlyCheckBox();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.openFileMenuItem = new JMenuItem();
        this.openFileChooser.setFileFilter(new FileExtensionFilter("Source engine map file", "bsp"));
        this.saveDirectoryChooser.setDialogType(1);
        this.saveDirectoryChooser.setFileSelectionMode(1);
        this.saveZipFileChooser.setAcceptAllFileFilterUsed(false);
        this.saveZipFileChooser.setDialogType(1);
        this.saveZipFileChooser.setFileFilter(new FileExtensionFilter("Zip file", "zip"));
        this.setDefaultCloseOperation(3);
        this.panelGame.setBorder(BorderFactory.createTitledBorder("Game"));
        this.linkLabelAppURL.setHorizontalAlignment(2);
        this.linkLabelAppURL.setText(" ");
        this.textFieldAppID.setEditable(false);
        this.textFieldGame.setEditable(false);
        this.labelAppID.setHorizontalAlignment(4);
        this.labelAppID.setText("App-ID");
        this.labelGame.setHorizontalAlignment(4);
        this.labelGame.setText("Name");
        GroupLayout panelGameLayout = new GroupLayout(this.panelGame);
        this.panelGame.setLayout(panelGameLayout);
        panelGameLayout.setHorizontalGroup(panelGameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGameLayout.createSequentialGroup().addContainerGap().addGroup(panelGameLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelGame).addComponent(this.labelAppID)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelGameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGameLayout.createSequentialGroup().addComponent(this.textFieldAppID, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.linkLabelAppURL, -1, -1, Short.MAX_VALUE)).addComponent(this.textFieldGame)).addContainerGap()));
        panelGameLayout.setVerticalGroup(panelGameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGameLayout.createSequentialGroup().addContainerGap().addGroup(panelGameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelGame).addComponent(this.textFieldGame, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelGameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelAppID).addComponent(this.textFieldAppID, -2, -1, -2).addComponent(this.linkLabelAppURL, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.panelHeaders.setBorder(BorderFactory.createTitledBorder("Headers"));
        this.textFieldEndian.setEditable(false);
        this.textFieldCompressed.setEditable(false);
        this.labelEndian.setHorizontalAlignment(4);
        this.labelEndian.setText("Endianness");
        this.labelCompressed.setHorizontalAlignment(4);
        this.labelCompressed.setText("Compressed");
        this.textFieldVersion.setEditable(false);
        this.textFieldVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspInfoFrame.this.textFieldVersionActionPerformed(evt);
            }
        });
        this.labelVersion.setHorizontalAlignment(4);
        this.labelVersion.setText("Version");
        this.textFieldName.setEditable(false);
        this.labelName.setHorizontalAlignment(4);
        this.labelName.setText("Name");
        this.textFieldRevision.setEditable(false);
        this.labelRevision.setHorizontalAlignment(4);
        this.labelRevision.setText("Revision");
        this.labelComment.setText("Comment");
        this.textFieldComment.setEditable(false);
        GroupLayout panelHeadersLayout = new GroupLayout(this.panelHeaders);
        this.panelHeaders.setLayout(panelHeadersLayout);
        panelHeadersLayout.setHorizontalGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHeadersLayout.createSequentialGroup().addContainerGap().addGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHeadersLayout.createSequentialGroup().addGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelComment).addComponent(this.labelCompressed)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHeadersLayout.createSequentialGroup().addComponent(this.textFieldCompressed, -2, 39, -2).addGap(22, 22, 22).addComponent(this.labelEndian).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textFieldEndian)).addComponent(this.textFieldComment))).addGroup(panelHeadersLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelName).addComponent(this.labelVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHeadersLayout.createSequentialGroup().addComponent(this.textFieldVersion, -2, 38, -2).addGap(36, 36, 36).addComponent(this.labelRevision).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textFieldRevision)).addComponent(this.textFieldName)))).addContainerGap()));
        panelHeadersLayout.setVerticalGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHeadersLayout.createSequentialGroup().addContainerGap().addGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelName).addComponent(this.textFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelVersion).addComponent(this.textFieldVersion, -2, -1, -2).addComponent(this.labelRevision).addComponent(this.textFieldRevision, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelCompressed).addComponent(this.textFieldCompressed, -2, -1, -2).addComponent(this.labelEndian).addComponent(this.textFieldEndian, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelHeadersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelComment).addComponent(this.textFieldComment, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.panelChecksums.setBorder(BorderFactory.createTitledBorder("Checksums"));
        this.labelFileCRC.setHorizontalAlignment(4);
        this.labelFileCRC.setText("File CRC");
        this.labelFileCRC.setHorizontalTextPosition(4);
        this.textFieldFileCRC.setEditable(false);
        this.labelMapCRC.setText("Map CRC");
        this.textFieldMapCRC.setEditable(false);
        GroupLayout panelChecksumsLayout = new GroupLayout(this.panelChecksums);
        this.panelChecksums.setLayout(panelChecksumsLayout);
        panelChecksumsLayout.setHorizontalGroup(panelChecksumsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelChecksumsLayout.createSequentialGroup().addContainerGap().addComponent(this.labelFileCRC).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textFieldFileCRC, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelMapCRC).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textFieldMapCRC, -2, 66, -2).addContainerGap(37, Short.MAX_VALUE)));
        panelChecksumsLayout.setVerticalGroup(panelChecksumsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelChecksumsLayout.createSequentialGroup().addContainerGap().addGroup(panelChecksumsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelChecksumsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelMapCRC).addComponent(this.textFieldMapCRC, -2, -1, -2)).addGroup(panelChecksumsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelFileCRC).addComponent(this.textFieldFileCRC, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.panelCompileParams.setBorder(BorderFactory.createTitledBorder("Detected compile parameters"));
        this.labelVbsp.setText("vbsp");
        this.textFieldVbspParams.setEditable(false);
        this.labelVvis.setText("vvis");
        this.textFieldVvisParams.setEditable(false);
        this.labelVrad.setText("vrad");
        this.textFieldVradParams.setEditable(false);
        GroupLayout panelCompileParamsLayout = new GroupLayout(this.panelCompileParams);
        this.panelCompileParams.setLayout(panelCompileParamsLayout);
        panelCompileParamsLayout.setHorizontalGroup(panelCompileParamsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelCompileParamsLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(panelCompileParamsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelVrad).addComponent(this.labelVbsp).addComponent(this.labelVvis)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelCompileParamsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textFieldVradParams).addComponent(this.textFieldVvisParams).addComponent(this.textFieldVbspParams)).addContainerGap()));
        panelCompileParamsLayout.setVerticalGroup(panelCompileParamsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCompileParamsLayout.createSequentialGroup().addContainerGap().addGroup(panelCompileParamsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelVbsp).addComponent(this.textFieldVbspParams, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCompileParamsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textFieldVvisParams, -2, -1, -2).addComponent(this.labelVvis)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCompileParamsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelVrad).addComponent(this.textFieldVradParams, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout panelGeneralLayout = new GroupLayout(this.panelGeneral);
        this.panelGeneral.setLayout(panelGeneralLayout);
        panelGeneralLayout.setHorizontalGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGeneralLayout.createSequentialGroup().addContainerGap().addGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelHeaders, -1, -1, Short.MAX_VALUE).addComponent(this.panelGame, -1, -1, Short.MAX_VALUE).addComponent(this.panelChecksums, -1, -1, Short.MAX_VALUE).addComponent(this.panelCompileParams, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        panelGeneralLayout.setVerticalGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGeneralLayout.createSequentialGroup().addContainerGap().addComponent(this.panelHeaders, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelGame, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelChecksums, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelCompileParams, -2, -1, -2).addContainerGap(18, Short.MAX_VALUE)));
        this.tabbedPane.addTab("General", this.panelGeneral);
        this.tableLumps.setAutoCreateRowSorter(true);
        this.tableLumps.setModel(new LumpTableModel());
        this.tableLumps.getTableHeader().setReorderingAllowed(false);
        this.scrollPaneLumps.setViewportView(this.tableLumps);
        this.extractLumpButton.setText("Extract");
        this.extractLumpButton.setEnabled(false);
        this.extractLumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspInfoFrame.this.extractLumpButtonActionPerformed(evt);
            }
        });
        this.extractAllLumpsButton.setText("Extract all");
        this.extractAllLumpsButton.setEnabled(false);
        this.extractAllLumpsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspInfoFrame.this.extractAllLumpsButtonActionPerformed(evt);
            }
        });
        GroupLayout panelLumpsLayout = new GroupLayout(this.panelLumps);
        this.panelLumps.setLayout(panelLumpsLayout);
        panelLumpsLayout.setHorizontalGroup(panelLumpsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLumpsLayout.createSequentialGroup().addContainerGap().addGroup(panelLumpsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPaneLumps, -1, 305, Short.MAX_VALUE).addGroup(panelLumpsLayout.createSequentialGroup().addComponent(this.extractLumpButton).addGap(18, 18, 18).addComponent(this.extractAllLumpsButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        panelLumpsLayout.setVerticalGroup(panelLumpsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLumpsLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPaneLumps, -1, 412, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLumpsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.extractLumpButton).addComponent(this.extractAllLumpsButton)).addContainerGap()));
        this.tabbedPane.addTab("Lumps", this.panelLumps);
        this.tableGameLumps.setAutoCreateRowSorter(true);
        this.tableGameLumps.setModel(new GameLumpTableModel());
        this.tableGameLumps.getTableHeader().setReorderingAllowed(false);
        this.scrollPaneGameLumps.setViewportView(this.tableGameLumps);
        this.extractGameLumpButton.setText("Extract");
        this.extractGameLumpButton.setEnabled(false);
        this.extractGameLumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspInfoFrame.this.extractGameLumpButtonActionPerformed(evt);
            }
        });
        this.extractAllGameLumpsButton.setText("Extract all");
        this.extractAllGameLumpsButton.setEnabled(false);
        this.extractAllGameLumpsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspInfoFrame.this.extractAllGameLumpsButtonActionPerformed(evt);
            }
        });
        GroupLayout panelGameLumpsLayout = new GroupLayout(this.panelGameLumps);
        this.panelGameLumps.setLayout(panelGameLumpsLayout);
        panelGameLumpsLayout.setHorizontalGroup(panelGameLumpsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGameLumpsLayout.createSequentialGroup().addContainerGap().addGroup(panelGameLumpsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPaneGameLumps, -2, 0, Short.MAX_VALUE).addGroup(panelGameLumpsLayout.createSequentialGroup().addComponent(this.extractGameLumpButton).addGap(18, 18, 18).addComponent(this.extractAllGameLumpsButton).addGap(0, 139, Short.MAX_VALUE))).addContainerGap()));
        panelGameLumpsLayout.setVerticalGroup(panelGameLumpsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGameLumpsLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPaneGameLumps, -1, 412, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelGameLumpsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.extractGameLumpButton).addComponent(this.extractAllGameLumpsButton)).addContainerGap()));
        this.tabbedPane.addTab("Game lumps", this.panelGameLumps);
        this.jLabel3.setText("Point");
        this.textFieldPointEnts.setEditable(false);
        this.jLabel2.setText("Brush");
        this.textFieldBrushEnts.setEditable(false);
        this.textFieldTotalEnts.setEditable(false);
        this.jLabel1.setText("Total");
        this.tableEntities.setAutoCreateRowSorter(true);
        this.tableEntities.setModel(new EntityTableModel());
        this.jScrollPane1.setViewportView(this.tableEntities);
        GroupLayout panelEntitiesLayout = new GroupLayout(this.panelEntities);
        this.panelEntities.setLayout(panelEntitiesLayout);
        panelEntitiesLayout.setHorizontalGroup(panelEntitiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEntitiesLayout.createSequentialGroup().addContainerGap().addGroup(panelEntitiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEntitiesLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textFieldPointEnts, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textFieldBrushEnts, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textFieldTotalEnts, -2, 60, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        panelEntitiesLayout.setVerticalGroup(panelEntitiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEntitiesLayout.createSequentialGroup().addContainerGap().addGroup(panelEntitiesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.textFieldPointEnts, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.textFieldBrushEnts, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.textFieldTotalEnts, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 410, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab("Entities", this.panelEntities);
        this.textAreaMaterials.setColumns(20);
        this.textAreaMaterials.setEditable(false);
        this.textAreaMaterials.setFont(new Font("Monospaced", 0, 12));
        this.textAreaMaterials.setRows(5);
        this.scrollPaneMaterials.setViewportView(this.textAreaMaterials);
        this.tabbedPaneDependencies.addTab("Materials", this.scrollPaneMaterials);
        this.textAreaSounds.setColumns(20);
        this.textAreaSounds.setFont(new Font("Monospaced", 0, 12));
        this.textAreaSounds.setRows(5);
        this.scrollPaneSounds.setViewportView(this.textAreaSounds);
        this.tabbedPaneDependencies.addTab("Sounds", this.scrollPaneSounds);
        this.textAreaSoundScripts.setColumns(20);
        this.textAreaSoundScripts.setFont(new Font("Monospaced", 0, 12));
        this.textAreaSoundScripts.setRows(5);
        this.scrollPaneSoundScripts.setViewportView(this.textAreaSoundScripts);
        this.tabbedPaneDependencies.addTab("Sound scripts", this.scrollPaneSoundScripts);
        this.textAreaSoundscapes.setColumns(20);
        this.textAreaSoundscapes.setFont(new Font("Monospaced", 0, 12));
        this.textAreaSoundscapes.setRows(5);
        this.scrollPaneSoundscapes.setViewportView(this.textAreaSoundscapes);
        this.tabbedPaneDependencies.addTab("Soundscapes", this.scrollPaneSoundscapes);
        this.textAreaModels.setColumns(20);
        this.textAreaModels.setFont(new Font("Monospaced", 0, 12));
        this.textAreaModels.setRows(5);
        this.scrollPaneModels.setViewportView(this.textAreaModels);
        this.tabbedPaneDependencies.addTab("Models", this.scrollPaneModels);
        this.textAreaParticles.setColumns(20);
        this.textAreaParticles.setFont(new Font("Monospaced", 0, 12));
        this.textAreaParticles.setRows(5);
        this.scrollPaneParticles.setViewportView(this.textAreaParticles);
        this.tabbedPaneDependencies.addTab("Particles", this.scrollPaneParticles);
        this.tabbedPane.addTab("Dependencies", this.tabbedPaneDependencies);
        this.tableEmbedded.setAutoCreateRowSorter(true);
        this.tableEmbedded.setModel(new EmbeddedTableModel());
        this.tableEmbedded.setSelectionMode(2);
        this.scrollPaneEmbedded.setViewportView(this.tableEmbedded);
        this.extractEmbeddedButton.setText("Extract");
        this.extractEmbeddedButton.setEnabled(false);
        this.extractEmbeddedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspInfoFrame.this.extractEmbeddedButtonActionPerformed(evt);
            }
        });
        this.extractAllEmbeddedButton.setText("Extract all");
        this.extractAllEmbeddedButton.setEnabled(false);
        this.extractAllEmbeddedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspInfoFrame.this.extractAllEmbeddedButtonActionPerformed(evt);
            }
        });
        this.extractEmbeddedZipButton.setText("Extract Zip file");
        this.extractEmbeddedZipButton.setEnabled(false);
        this.extractEmbeddedZipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspInfoFrame.this.extractEmbeddedZipButtonActionPerformed(evt);
            }
        });
        GroupLayout panelEmbeddedLayout = new GroupLayout(this.panelEmbedded);
        this.panelEmbedded.setLayout(panelEmbeddedLayout);
        panelEmbeddedLayout.setHorizontalGroup(panelEmbeddedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEmbeddedLayout.createSequentialGroup().addContainerGap().addGroup(panelEmbeddedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPaneEmbedded, -1, 305, Short.MAX_VALUE).addGroup(panelEmbeddedLayout.createSequentialGroup().addComponent(this.extractEmbeddedButton).addGap(18, 18, 18).addComponent(this.extractAllEmbeddedButton).addGap(18, 18, 18).addComponent(this.extractEmbeddedZipButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        panelEmbeddedLayout.setVerticalGroup(panelEmbeddedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEmbeddedLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPaneEmbedded, -1, 412, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelEmbeddedLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.extractEmbeddedButton).addComponent(this.extractAllEmbeddedButton).addComponent(this.extractEmbeddedZipButton)).addContainerGap()));
        this.tabbedPane.addTab("Embedded files", this.panelEmbedded);
        this.panelVmex.setBorder(BorderFactory.createTitledBorder("VMEX"));
        this.checkBoxVmexEntity.setText("Entity flag");
        this.checkBoxVmexEntity.setHorizontalTextPosition(2);
        this.checkBoxVmexEntity.setIconTextGap(6);
        this.checkBoxVmexTexture.setText("Texture flag");
        this.checkBoxVmexTexture.setHorizontalTextPosition(2);
        this.checkBoxVmexTexture.setIconTextGap(6);
        this.checkBoxVmexBrush.setText("Protector brush");
        this.checkBoxVmexBrush.setHorizontalTextPosition(2);
        this.checkBoxVmexBrush.setIconTextGap(6);
        GroupLayout panelVmexLayout = new GroupLayout(this.panelVmex);
        this.panelVmex.setLayout(panelVmexLayout);
        panelVmexLayout.setHorizontalGroup(panelVmexLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelVmexLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(panelVmexLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxVmexBrush, -2, -1, -2).addComponent(this.checkBoxVmexTexture, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.checkBoxVmexEntity, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addContainerGap()));
        panelVmexLayout.setVerticalGroup(panelVmexLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelVmexLayout.createSequentialGroup().addComponent(this.checkBoxVmexEntity, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxVmexTexture, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxVmexBrush, -2, -1, -2)));
        this.panelIID.setBorder(BorderFactory.createTitledBorder("IID"));
        this.checkBoxIIDObfs.setText("Entity obfuscation");
        this.checkBoxIIDObfs.setHorizontalTextPosition(2);
        this.checkBoxIIDObfs.setIconTextGap(6);
        this.checkBoxIIDTexHack.setText("Nodraw texture hack");
        this.checkBoxIIDTexHack.setHorizontalTextPosition(2);
        this.checkBoxIIDTexHack.setIconTextGap(6);
        GroupLayout panelIIDLayout = new GroupLayout(this.panelIID);
        this.panelIID.setLayout(panelIIDLayout);
        panelIIDLayout.setHorizontalGroup(panelIIDLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelIIDLayout.createSequentialGroup().addContainerGap(17, Short.MAX_VALUE).addGroup(panelIIDLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxIIDTexHack, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.checkBoxIIDObfs, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addContainerGap()));
        panelIIDLayout.setVerticalGroup(panelIIDLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelIIDLayout.createSequentialGroup().addComponent(this.checkBoxIIDObfs, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxIIDTexHack, -2, -1, -2)));
        this.panelOther.setBorder(BorderFactory.createTitledBorder("Other"));
        this.checkBoxBSPProtect.setText("BSPProtect");
        this.checkBoxBSPProtect.setHorizontalTextPosition(2);
        this.checkBoxBSPProtect.setIconTextGap(6);
        GroupLayout panelOtherLayout = new GroupLayout(this.panelOther);
        this.panelOther.setLayout(panelOtherLayout);
        panelOtherLayout.setHorizontalGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelOtherLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.checkBoxBSPProtect, -2, -1, -2).addContainerGap()));
        panelOtherLayout.setVerticalGroup(panelOtherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxBSPProtect, -2, -1, -2));
        GroupLayout panelProtLayout = new GroupLayout(this.panelProt);
        this.panelProt.setLayout(panelProtLayout);
        panelProtLayout.setHorizontalGroup(panelProtLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProtLayout.createSequentialGroup().addContainerGap().addGroup(panelProtLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.panelVmex, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.panelIID, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.panelOther, -1, -1, Short.MAX_VALUE)).addContainerGap(151, Short.MAX_VALUE)));
        panelProtLayout.setVerticalGroup(panelProtLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProtLayout.createSequentialGroup().addContainerGap().addComponent(this.panelVmex, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelIID, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelOther, -2, -1, -2).addContainerGap(233, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Protection", this.panelProt);
        this.menuFile.setText("File");
        this.openFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openFileMenuItem.setText("Open");
        this.openFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BspInfoFrame.this.openFileMenuItemActionPerformed(evt);
            }
        });
        this.menuFile.add(this.openFileMenuItem);
        this.menuBar.add(this.menuFile);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        this.pack();
    }

    private void initComponentsCustom() {
        this.setTitle("BSPInfo 1.3.24");
        try {
            URL iconUrl = this.getClass().getResource("resources/icon.png");
            Image icon = Toolkit.getDefaultToolkit().createImage(iconUrl);
            this.setIconImage(icon);
        }
        catch (Exception iconUrl) {
            // empty catch block
        }
        DecimalFormat largeFormat = new DecimalFormat("#,##0");
        TableColumnModel tcm = this.tableLumps.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(30);
        tcm.getColumn(1).setPreferredWidth(150);
        tcm.getColumn(4).setPreferredWidth(40);
        tcm.getColumn(2).setCellRenderer(new ByteSizeCellRenderer(false));
        tcm.getColumn(3).setCellRenderer(new ProgressCellRenderer());
        this.tableLumps.setAutoCreateColumnsFromModel(false);
        tcm = this.tableGameLumps.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(30);
        tcm.getColumn(3).setPreferredWidth(40);
        tcm.getColumn(1).setCellRenderer(new ByteSizeCellRenderer(false));
        tcm.getColumn(2).setCellRenderer(new ProgressCellRenderer());
        this.tableGameLumps.setAutoCreateColumnsFromModel(false);
        tcm = this.tableEntities.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(250);
        tcm.getColumn(1).setPreferredWidth(50);
        tcm.getColumn(1).setCellRenderer(new DecimalFormatCellRenderer(largeFormat));
        this.tableEntities.setAutoCreateColumnsFromModel(false);
        tcm = this.tableEmbedded.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(250);
        tcm.getColumn(1).setPreferredWidth(50);
        tcm.getColumn(1).setCellRenderer(new ByteSizeCellRenderer(false));
        this.tableEmbedded.setAutoCreateColumnsFromModel(false);
    }

    private void openFileMenuItemActionPerformed(ActionEvent evt) {
        int result = this.openFileChooser.showOpenDialog(this);
        if (result != 0) {
            return;
        }
        this.loadFile(this.openFileChooser.getSelectedFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractLumpButtonActionPerformed(ActionEvent evt) {
        int[] selected = this.tableLumps.getSelectedRows();
        if (selected.length == 0) {
            return;
        }
        this.saveDirectoryChooser.setCurrentDirectory(this.currentFile);
        int result = this.saveDirectoryChooser.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        File dest = this.saveDirectoryChooser.getSelectedFile();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int files = 0;
            TableModel model = this.tableLumps.getModel();
            RowSorter<? extends TableModel> sorter = this.tableLumps.getRowSorter();
            for (int index : selected) {
                index = sorter.convertRowIndexToModel(index);
                int lumpIndex = (Integer)model.getValueAt(index, 0);
                LumpType lumpType = LumpType.get(lumpIndex, this.bspFile.getVersion());
                try {
                    BspFileUtils.extractLump(this.bspFile, dest, lumpType);
                    ++files;
                }
                catch (IOException ex) {
                    L.log(Level.WARNING, "Couldn't extract lump " + (Object)((Object)lumpType), ex);
                }
            }
            JOptionPane.showMessageDialog(this, "Successfully extracted " + files + " lumps.");
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractAllLumpsButtonActionPerformed(ActionEvent evt) {
        this.saveDirectoryChooser.setCurrentDirectory(this.currentFile);
        int result = this.saveDirectoryChooser.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        File dest = this.saveDirectoryChooser.getSelectedFile();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            BspFileUtils.extractLumps(this.bspFile, dest);
            JOptionPane.showMessageDialog(this, "Successfully extracted all lumps.");
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Couldn't extract lumps", ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractGameLumpButtonActionPerformed(ActionEvent evt) {
        int[] selected = this.tableGameLumps.getSelectedRows();
        if (selected.length == 0) {
            return;
        }
        this.saveDirectoryChooser.setCurrentDirectory(this.currentFile);
        int result = this.saveDirectoryChooser.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        File dest = this.saveDirectoryChooser.getSelectedFile();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int files = 0;
            TableModel model = this.tableGameLumps.getModel();
            RowSorter<? extends TableModel> sorter = this.tableGameLumps.getRowSorter();
            for (int index : selected) {
                index = sorter.convertRowIndexToModel(index);
                String id = (String)model.getValueAt(index, 0);
                try {
                    BspFileUtils.extractGameLump(this.bspFile, dest, id);
                    ++files;
                }
                catch (IOException ex) {
                    L.log(Level.WARNING, "Couldn't extract game lump " + id, ex);
                }
            }
            JOptionPane.showMessageDialog(this, "Successfully extracted " + files + " game lumps.");
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractAllGameLumpsButtonActionPerformed(ActionEvent evt) {
        this.saveDirectoryChooser.setCurrentDirectory(this.currentFile);
        int result = this.saveDirectoryChooser.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        File dest = this.saveDirectoryChooser.getSelectedFile();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            BspFileUtils.extractGameLumps(this.bspFile, dest);
            JOptionPane.showMessageDialog(this, "Successfully extracted all game lumps.");
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Couldn't extract lumps", ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEmbeddedButtonActionPerformed(ActionEvent evt) {
        int[] selected = this.tableEmbedded.getSelectedRows();
        if (selected.length == 0) {
            return;
        }
        this.saveDirectoryChooser.setCurrentDirectory(this.currentFile);
        int result = this.saveDirectoryChooser.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        File dest = this.saveDirectoryChooser.getSelectedFile();
        this.setCursor(Cursor.getPredefinedCursor(3));
        ArrayList<String> names = new ArrayList<String>();
        TableModel model = this.tableEmbedded.getModel();
        RowSorter<? extends TableModel> sorter = this.tableEmbedded.getRowSorter();
        for (int index : selected) {
            index = sorter.convertRowIndexToModel(index);
            names.add((String)model.getValueAt(index, 0));
        }
        try {
            this.bspFile.getPakFile().unpack(dest.toPath(), names);
            JOptionPane.showMessageDialog(this, "Successfully extracted " + names.size() + " embedded files.");
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Couldn't extract embedded files", ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractAllEmbeddedButtonActionPerformed(ActionEvent evt) {
        this.saveDirectoryChooser.setCurrentDirectory(this.currentFile);
        int result = this.saveDirectoryChooser.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        File dest = this.saveDirectoryChooser.getSelectedFile();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.bspFile.getPakFile().unpack(dest.toPath(), false);
            JOptionPane.showMessageDialog(this, "Successfully extracted all embedded files.");
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Couldn't extract embedded files", ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEmbeddedZipButtonActionPerformed(ActionEvent evt) {
        this.saveZipFileChooser.setSelectedFile(new File(this.currentFile.getParent(), this.bspFile.getName() + ".zip"));
        int result = this.saveZipFileChooser.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        File dest = this.saveZipFileChooser.getSelectedFile();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.bspFile.getPakFile().unpack(dest.toPath(), true);
            JOptionPane.showMessageDialog(this, "Successfully extracted embedded Zip file.");
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Couldn't extract embedded Zip file", ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void textFieldVersionActionPerformed(ActionEvent evt) {
    }
}

