/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import info.ata4.io.lzma.LzmaDecoderProps;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import net.contrapunctus.lzma.ConcurrentBufferInputStream;
import net.contrapunctus.lzma.DecoderThread;

public class LzmaInputStream
extends FilterInputStream {
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;
    private DecoderThread dth;

    public LzmaInputStream(InputStream _in) {
        super(null);
        this.dth = new DecoderThread(_in);
        this.in = ConcurrentBufferInputStream.create(this.dth.q);
        if (DEBUG) {
            dbg.printf("%s << %s (%s)%n", this, this.in, this.dth.q);
        }
        this.dth.start();
    }

    public LzmaDecoderProps getProperties() {
        return this.dth.getProps();
    }

    public int read() throws IOException {
        int k = this.in.read();
        this.dth.maybeThrow();
        return k;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int k = this.in.read(b, off, len);
        this.dth.maybeThrow();
        return k;
    }

    public void close() throws IOException {
        if (DEBUG) {
            dbg.printf("%s closed%n", this);
        }
        super.close();
        try {
            this.dth.join();
            if (DEBUG) {
                dbg.printf("%s joined %s%n", this, this.dth);
            }
        }
        catch (InterruptedException exn) {
            throw new InterruptedIOException(exn.getMessage());
        }
        if (this.dth.exn != null) {
            throw this.dth.exn;
        }
    }

    public String toString() {
        return String.format("lzmaIn@%x", this.hashCode());
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_LzmaStreams");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
    }
}

