/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.util.gui.components;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ByteSizeCellRenderer
extends DefaultTableCellRenderer {
    private boolean si;

    public ByteSizeCellRenderer(boolean si) {
        this.si = si;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Long) {
            value = this.humanReadableByteCount((Long)value);
        } else if (value instanceof Integer) {
            value = this.humanReadableByteCount(((Integer)value).intValue());
        }
        JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        c.setHorizontalAlignment(4);
        return c;
    }

    private String humanReadableByteCount(long bytes) {
        int unit;
        int n = unit = this.si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (this.si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (this.si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

