/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.log;

import info.ata4.log.ConsoleFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ConsoleHandler
extends Handler {
    private boolean doneHeader;

    public ConsoleHandler() {
        this.setFormatter(new ConsoleFormatter());
    }

    private void doHeaders() {
        if (!this.doneHeader) {
            System.out.print(this.getFormatter().getHead(this));
            System.err.print(this.getFormatter().getHead(this));
            this.doneHeader = true;
        }
    }

    @Override
    public void publish(LogRecord record) {
        String msg;
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            this.doHeaders();
            if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                System.err.print(msg);
            } else {
                System.out.print(msg);
            }
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    @Override
    public void flush() {
        try {
            System.out.flush();
            System.err.flush();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 2);
        }
    }

    @Override
    public void close() throws SecurityException {
        this.doHeaders();
        System.out.print(this.getFormatter().getTail(this));
        System.err.print(this.getFormatter().getTail(this));
        this.flush();
    }
}

