/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ConsoleFormatter
extends Formatter {
    private static final Map<Level, String> LEVEL_PREFIX;

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append(LEVEL_PREFIX.get(record.getLevel()));
        sb.append(' ');
        String[] classNameParts = record.getLoggerName().split("\\.");
        if (record.getLevel() != Level.INFO && classNameParts.length != 0) {
            sb.append(classNameParts[classNameParts.length - 1]);
            sb.append(": ");
        }
        sb.append(this.formatMessage(record));
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            sb.append(", caused by ");
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                thrown.printStackTrace(pw);
            }
            sb.append(sw.toString());
        }
        sb.append("\n");
        return sb.toString();
    }

    static {
        HashMap<Level, String> levelPrefix = new HashMap<Level, String>();
        levelPrefix.put(Level.CONFIG, "[config]");
        levelPrefix.put(Level.FINE, "[debug]");
        levelPrefix.put(Level.FINER, "[debug]");
        levelPrefix.put(Level.FINEST, "[trace]");
        levelPrefix.put(Level.INFO, "[info]");
        levelPrefix.put(Level.SEVERE, "[error]");
        levelPrefix.put(Level.WARNING, "[warning]");
        LEVEL_PREFIX = Collections.unmodifiableMap(levelPrefix);
    }
}

