/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.lzma;

import info.ata4.io.lzma.LzmaProps;
import java.io.IOException;
import java.io.OutputStream;
import lzma.LzmaEncoder;

public class LzmaEncoderProps
extends LzmaProps {
    private int numFastBytes = 32;
    private boolean endMarkerMode = false;

    public int getNumFastBytes() {
        return this.numFastBytes;
    }

    public void setNumFastBytes(int numFastBytes) {
        if (numFastBytes < 5 || numFastBytes > 273) {
            throw new IllegalArgumentException();
        }
        this.numFastBytes = numFastBytes;
    }

    public boolean isEndMarkerMode() {
        return this.endMarkerMode;
    }

    public void setEndMarkerMode(boolean endMarkerMode) {
        this.endMarkerMode = endMarkerMode;
    }

    public void apply(LzmaEncoder encoder) {
        encoder.setLcLpPb(this.getNumLiteralContextBits(), this.getNumLiteralPosStateBits(), this.getPosStateBits());
        encoder.setDictionarySize(this.getDictionarySize());
        encoder.setNumFastBytes(this.getNumFastBytes());
        encoder.setEndMarkerMode(this.isEndMarkerMode());
    }

    public void toOutputStream(OutputStream out) throws IOException {
        out.write(this.toArray());
    }
}

