/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules.texture;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bspsrc.modules.ModuleRead;
import info.ata4.bspsrc.modules.texture.TextureBuilder;
import info.ata4.log.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class TextureSource
extends ModuleRead {
    private static final Logger L = LogUtils.getLogger();
    private final Pattern originPattern = Pattern.compile("_(-?\\d+)_(-?\\d+)_(-?\\d+)?$");
    private final Pattern wvtPatchPattern = Pattern.compile("_wvt_patch$");
    private final Pattern waterPatchPattern = Pattern.compile("_depth_(-?\\d+)$");
    private final Pattern mapPattern;
    private Map<Integer, Set<Integer>> cubemapToSideList = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Integer> texnameToCubemap = new HashMap<Integer, Integer>();
    private List<String> texnamesFixed = new ArrayList<String>();
    private boolean fixTextureNames;
    private boolean fixToolTextures;

    public TextureSource(BspFileReader reader) {
        super(reader);
        this.mapPattern = Pattern.compile("^maps/" + reader.getBspFile().getName() + "/");
        reader.loadTexInfo();
        reader.loadTexData();
        reader.loadCubemaps();
        this.processTextureNames();
    }

    private void processTextureNames() {
        for (int i = 0; i < this.bsp.texnames.size(); ++i) {
            String textureOld;
            String textureNew = textureOld = this.bsp.texnames.get(i);
            Matcher matcher = this.mapPattern.matcher(textureNew = this.canonizeTextureName(textureNew));
            if (matcher.find()) {
                textureNew = matcher.replaceFirst("");
                if ((matcher = this.wvtPatchPattern.matcher(textureNew)).find()) {
                    textureNew = matcher.replaceFirst("");
                }
                if ((matcher = this.waterPatchPattern.matcher(textureNew)).find()) {
                    textureNew = matcher.replaceFirst("");
                }
                if ((matcher = this.originPattern.matcher(textureNew)).find()) {
                    int cx = Integer.valueOf(matcher.group(1));
                    int cy = Integer.valueOf(matcher.group(2));
                    int cz = Integer.valueOf(matcher.group(3));
                    this.setCubemapForTexname(i, cx, cy, cz);
                    textureNew = matcher.replaceFirst("");
                }
            }
            if (!textureNew.equalsIgnoreCase(textureOld)) {
                L.log(Level.FINEST, "{0} -> {1}", new Object[]{textureOld, textureNew});
            }
            this.texnamesFixed.add(textureNew);
        }
    }

    private void setCubemapForTexname(int itexname, int cx, int cy, int cz) {
        for (int i = 0; i < this.bsp.cubemaps.size(); ++i) {
            int[] origin = this.bsp.cubemaps.get((int)i).origin;
            if (cx != origin[0] && cy != origin[1] && cz != origin[2]) continue;
            if (L.isLoggable(Level.FINEST)) {
                L.log(Level.FINEST, "TN: {0} C: {1}", new Object[]{itexname, i});
            }
            this.texnameToCubemap.put(itexname, i);
            return;
        }
        L.log(Level.FINER, "Couldn''t find cubemap for coordinates ({0}, {1}, {2})", new Object[]{cx, cy, cz});
    }

    public TextureBuilder getTextureBuilder() {
        return new TextureBuilder(this, this.bsp);
    }

    public void addBrushSideID(int itexname, int side) {
        Integer icubemap = this.texnameToCubemap.get(itexname);
        if (icubemap == null) {
            return;
        }
        Set<Integer> sides = this.cubemapToSideList.get(icubemap);
        if (sides == null) {
            sides = new HashSet<Integer>();
            this.cubemapToSideList.put(icubemap, sides);
        }
        sides.add(side);
    }

    public Set<Integer> getBrushSidesForCubemap(int icubemap) {
        return this.cubemapToSideList.get(icubemap);
    }

    public String getTextureName(short itexinfo) {
        try {
            int ti = this.bsp.texinfos.get((int)itexinfo).texdata;
            int td = this.bsp.texdatas.get((int)ti).texname;
            if (this.fixTextureNames) {
                return this.texnamesFixed.get(td);
            }
            return this.bsp.texnames.get(td);
        }
        catch (IndexOutOfBoundsException ex) {
            return "tools/toolsskip";
        }
    }

    public String canonizeTextureName(String textureNew) {
        textureNew = textureNew.toLowerCase();
        textureNew = FilenameUtils.separatorsToUnix(textureNew);
        return textureNew;
    }

    public List<String> getFixedTextureNames() {
        return Collections.unmodifiableList(this.texnamesFixed);
    }

    public boolean isFixTextureNames() {
        return this.fixTextureNames;
    }

    public void setFixTextureNames(boolean fixTextureNames) {
        this.fixTextureNames = fixTextureNames;
    }

    public boolean isFixToolTextures() {
        return this.fixToolTextures;
    }

    public void setFixToolTextures(boolean fixToolTextures) {
        this.fixToolTextures = fixToolTextures;
    }
}

