/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules.texture;

import info.ata4.bsplib.struct.BrushFlag;
import info.ata4.bsplib.struct.BspData;
import info.ata4.bsplib.struct.DBrush;
import info.ata4.bsplib.struct.DBrushSide;
import info.ata4.bsplib.struct.DTexData;
import info.ata4.bsplib.struct.DTexInfo;
import info.ata4.bsplib.struct.SurfaceFlag;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.bspsrc.modules.texture.Texture;
import info.ata4.bspsrc.modules.texture.TextureAxis;
import info.ata4.bspsrc.modules.texture.TextureSource;
import info.ata4.log.LogUtils;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextureBuilder {
    private static final Logger L = LogUtils.getLogger();
    private static final float EPS_PERP = 0.02f;
    private static EnumSet<SurfaceFlag> SURF_FLAGS_CLIP = EnumSet.of(SurfaceFlag.SURF_NOLIGHT, SurfaceFlag.SURF_NODRAW);
    private static EnumSet<SurfaceFlag> SURF_FLAGS_AREAPORTAL = EnumSet.of(SurfaceFlag.SURF_NOLIGHT);
    private static EnumSet<BrushFlag> BRUSH_FLAGS_AREAPORTAL = EnumSet.of(BrushFlag.CONTENTS_AREAPORTAL);
    private final BspData bsp;
    private final TextureSource texsrc;
    private Texture texture;
    private Vector3f origin;
    private Vector3f angles;
    private Vector3f normal;
    private DTexInfo texinfo;
    private DTexData texdata;
    private short itexinfo = (short)-1;
    private int ibrush = -1;
    private int ibrushside = -1;

    TextureBuilder(TextureSource texsrc, BspData bsp) {
        this.texsrc = texsrc;
        this.bsp = bsp;
    }

    public Texture build() {
        String textureFix;
        this.texture = new Texture();
        this.texture.setOriginalTexture("tools/toolsskip");
        this.fixPerpendicular();
        if (this.itexinfo == -1) {
            return this.texture;
        }
        try {
            this.texinfo = this.bsp.texinfos.get(this.itexinfo);
        }
        catch (IndexOutOfBoundsException ex) {
            L.log(Level.WARNING, "Invalid texinfo index: {0}", this.itexinfo);
            return this.texture;
        }
        try {
            this.texdata = this.bsp.texdatas.get(this.texinfo.texdata);
            this.texture.setData(this.texdata);
        }
        catch (IndexOutOfBoundsException ex) {
            L.log(Level.WARNING, "Invalid texdata index: {0}", this.texinfo.texdata);
            return this.texture;
        }
        String textureOriginal = "tools/toolsskip";
        try {
            textureOriginal = this.bsp.texnames.get(this.texdata.texname);
        }
        catch (IndexOutOfBoundsException ex) {
            L.log(Level.WARNING, "Invalid texname index: {0}", this.texdata.texname);
        }
        String textureOverride = this.texsrc.getFixedTextureNames().get(this.texdata.texname);
        if (this.texsrc.isFixToolTextures() && (textureFix = this.fixToolTexture()) != null) {
            textureOverride = textureFix;
        }
        this.texture.setOriginalTexture(textureOriginal);
        this.texture.setOverrideTexture(textureOverride);
        this.buildLightmapScale();
        this.buildUV();
        this.fixPerpendicular();
        return this.texture;
    }

    private String fixToolTexture() {
        if (this.ibrush == -1 || this.ibrushside == -1) {
            return null;
        }
        DBrush brush = this.bsp.brushes.get(this.ibrush);
        DBrushSide brushSide = this.bsp.brushSides.get(this.ibrushside);
        Set<SurfaceFlag> surfFlags = brushSide.texinfo == -1 ? EnumSet.noneOf(SurfaceFlag.class) : this.bsp.texinfos.get((int)brushSide.texinfo).flags;
        Set<BrushFlag> brushFlags = brush.contents;
        if (surfFlags.equals(SURF_FLAGS_CLIP)) {
            if (brush.isDetail()) {
                if (brush.isPlayerClip() && brush.isNpcClip()) {
                    return "tools/toolsclip";
                }
                if (brush.isPlayerClip()) {
                    return "tools/toolsplayerclip";
                }
                if (brush.isNpcClip()) {
                    return "tools/toolsnpcclip";
                }
                if (brush.isBlockLos()) {
                    return "tools/toolsblock_los";
                }
            }
            return "tools/toolsnodraw";
        }
        if (brushFlags.equals(BRUSH_FLAGS_AREAPORTAL) && surfFlags.equals(SURF_FLAGS_AREAPORTAL)) {
            return "tools/toolsareaportal";
        }
        return null;
    }

    private void fixPerpendicular() {
        if (this.normal == null) {
            return;
        }
        Vector3f texNorm = this.texture.getVAxis().axis.cross(this.texture.getUAxis().axis);
        if (Math.abs(this.normal.dot(texNorm)) >= 0.02f) {
            return;
        }
        Vector3f udir = new Vector3f(0.0f, 0.0f, 1.0f);
        if ((double)Math.abs(udir.dot(this.normal)) > Math.sin(45.0)) {
            udir = new Vector3f(1.0f, 0.0f, 0.0f);
        }
        Vector3f tv1 = udir.cross(this.normal).normalize();
        Vector3f tv2 = tv1.cross(this.normal).normalize();
        this.texture.setUAxis(new TextureAxis(tv1));
        this.texture.setVAxis(new TextureAxis(tv2));
    }

    private void buildLightmapScale() {
        float[][] lvec = this.texinfo.lightmapVecsLuxels;
        Vector3f uaxis = new Vector3f(lvec[0]);
        Vector3f vaxis = new Vector3f(lvec[1]);
        float ls = (uaxis.length() + vaxis.length()) / 2.0f;
        if (ls > 0.001f) {
            this.texture.setLightmapScale(Math.round(1.0f / ls));
        }
    }

    private void buildUV() {
        float[][] tvec = this.texinfo.textureVecsTexels;
        Vector3f uaxis = new Vector3f(tvec[0]);
        Vector3f vaxis = new Vector3f(tvec[1]);
        float utw = 1.0f / uaxis.length();
        float vtw = 1.0f / vaxis.length();
        uaxis = uaxis.scalar(utw);
        vaxis = vaxis.scalar(vtw);
        float ushift = tvec[0][3];
        float vshift = tvec[1][3];
        if (this.origin != null) {
            ushift -= this.origin.dot(uaxis) / utw;
            vshift -= this.origin.dot(vaxis) / vtw;
        }
        if (this.angles != null) {
            uaxis = uaxis.rotate(this.angles);
            vaxis = vaxis.rotate(this.angles);
            Vector3f shift = Vector3f.NULL;
            if (this.origin != null) {
                shift = shift.sub(this.origin);
            }
            shift = shift.rotate(this.angles);
            if (this.origin != null) {
                shift = shift.add(this.origin);
            }
            ushift -= shift.dot(uaxis) / utw;
            vshift -= shift.dot(vaxis) / vtw;
        }
        if (this.texdata.width != 0) {
            ushift %= (float)this.texdata.width;
        }
        if (this.texdata.height != 0) {
            vshift %= (float)this.texdata.height;
        }
        utw = (float)Math.round(utw * 10000.0f) / 10000.0f;
        vtw = (float)Math.round(vtw * 10000.0f) / 10000.0f;
        this.texture.setUAxis(new TextureAxis(uaxis, Math.round(ushift), utw));
        this.texture.setVAxis(new TextureAxis(vaxis, Math.round(vshift), vtw));
    }

    public void setOrigin(Vector3f origin) {
        this.origin = origin;
    }

    public void setAngles(Vector3f angles) {
        this.angles = angles;
    }

    public void setNormal(Vector3f normal) {
        this.normal = normal;
    }

    public void setBrushIndex(int ibrush) {
        this.ibrush = ibrush;
    }

    public void setBrushSideIndex(int ibrushside) {
        this.ibrushside = ibrushside;
    }

    public void setTexinfoIndex(short itexinfo) {
        this.itexinfo = itexinfo;
    }
}

