/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.cli;

import info.ata4.bsplib.app.SourceApp;
import info.ata4.bsplib.app.SourceAppDB;
import info.ata4.bspsrc.BspFileEntry;
import info.ata4.bspsrc.BspSource;
import info.ata4.bspsrc.BspSourceConfig;
import info.ata4.bspsrc.cli.MultiOptions;
import info.ata4.bspsrc.cli.OptionHelpFormatter;
import info.ata4.bspsrc.modules.geom.BrushMode;
import info.ata4.bspsrc.util.SourceFormat;
import info.ata4.log.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;

public class BspSourceCli {
    private static final Logger L = LogUtils.getLogger();
    private Options optsMain = new Options();
    private Options optsEntity = new Options();
    private Options optsWorld = new Options();
    private Options optsTexture = new Options();
    private Options optsOther = new Options();
    private MultiOptions optsAll = new MultiOptions();

    public static void main(String[] args) {
        LogUtils.configure();
        try {
            BspSourceCli cli = new BspSourceCli();
            BspSourceConfig cfg = cli.getConfig(args);
            BspSource bspsrc = new BspSource(cfg);
            bspsrc.run();
        }
        catch (Throwable t) {
            L.log(Level.SEVERE, "Fatal BSPSource error", t);
        }
    }

    private void printHelp() {
        System.out.println("BSPSource 1.3.24");
        System.out.println("usage: bspsrc [options] <path> [path...]");
        System.out.println();
        OptionHelpFormatter clHelp = new OptionHelpFormatter();
        clHelp.printHelp("Main options:", this.optsMain);
        clHelp.printHelp("Entity options:", this.optsEntity);
        clHelp.printHelp("World brush options:", this.optsWorld);
        clHelp.printHelp("Texture options:", this.optsTexture);
        clHelp.printHelp("Other options:", this.optsOther);
        System.exit(0);
    }

    private void printVersion() {
        System.out.println("BSPSource 1.3.24");
        System.out.println();
        System.out.println("Based on VMEX v0.98g by Rof <rof@mellish.org.uk>");
        System.out.println("Extended and modified by Nico Bergemann <barracuda415@yahoo.de>");
        System.exit(0);
    }

    private void printAppIDs() {
        System.out.printf("%6s  %s\n", "ID", "Name");
        List<SourceApp> apps = SourceAppDB.getInstance().getAppList();
        for (SourceApp app : apps) {
            System.out.printf("%6d  %s\n", app.getAppID(), app.getName());
        }
        System.exit(0);
    }

    public BspSourceConfig getConfig(String[] args) {
        Set<BspFileEntry> files;
        boolean recursive;
        File outputFile;
        CommandLine cl;
        BspSourceConfig config;
        block35: {
            config = new BspSourceConfig();
            Option helpOpt = new Option("h", "help", false, "Print this help.");
            this.optsMain.addOption(helpOpt);
            Option versionOpt = new Option("v", "Print version info.");
            this.optsMain.addOption(versionOpt);
            Option debugOpt = new Option("d", "Enable debug mode. Increases verbosity and adds additional data to the VMF file.");
            this.optsMain.addOption(debugOpt);
            Option recursiveOpt = new Option("r", "Decompile all files found in the given directory.");
            this.optsMain.addOption(recursiveOpt);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("file");
            OptionBuilder.withDescription("Override output path for VMF file(s). Treated as directory if multiple BSP files are provided. \ndefault: <mappath>/<mapname>_d.vmf");
            OptionBuilder.withType(String.class);
            Option outputOpt = OptionBuilder.create('o');
            this.optsMain.addOption(outputOpt);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("file");
            OptionBuilder.withDescription("Use a text files with paths as input BSP file list.");
            OptionBuilder.withType(String.class);
            Option fileListOpt = OptionBuilder.create('l');
            this.optsMain.addOption(fileListOpt);
            Option npentsOpt = new Option("no_point_ents", "Don't write any point entities.");
            this.optsEntity.addOption(npentsOpt);
            Option nbentsOpt = new Option("no_brush_ents", "Don't write any brush entities.");
            this.optsEntity.addOption(nbentsOpt);
            Option npropsOpt = new Option("no_sprp", "Don't write prop_static entities.");
            this.optsEntity.addOption(npropsOpt);
            Option noverlOpt = new Option("no_overlays", "Don't write info_overlay entities.");
            this.optsEntity.addOption(noverlOpt);
            Option ncubemOpt = new Option("no_cubemaps", "Don't write env_cubemap entities.");
            this.optsEntity.addOption(ncubemOpt);
            Option ndetailsOpt = new Option("no_details", "Don't write func_detail entities.");
            this.optsEntity.addOption(ndetailsOpt);
            Option nareapOpt = new Option("no_areaportals", "Don't write func_areaportal(_window) entities.");
            this.optsEntity.addOption(nareapOpt);
            Option nocclOpt = new Option("no_occluders", "Don't write func_occluder entities.");
            this.optsEntity.addOption(nocclOpt);
            Option nladderOpt = new Option("no_ladders", "Don't write func_ladder entities.");
            this.optsEntity.addOption(nladderOpt);
            Option nrotfixOpt = new Option("no_rotfix", "Don't fix instance entity brush rotations for Hammer.");
            this.optsEntity.addOption(nrotfixOpt);
            Option nbrushOpt = new Option("no_brushes", "Don't write any world brushes.");
            this.optsWorld.addOption(nbrushOpt);
            Option ndispOpt = new Option("no_disps", "Don't write displacement surfaces.");
            this.optsWorld.addOption(ndispOpt);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("enum");
            OptionBuilder.withDescription("Brush decompiling mode:\n" + BrushMode.BRUSHPLANES.name() + "   - brushes and planes\n" + BrushMode.ORIGFACE.name() + "      - original faces only\n" + BrushMode.ORIGFACE_PLUS.name() + " - original + split faces\n" + BrushMode.SPLITFACE.name() + "     - split faces only\n" + "default: " + config.brushMode.name());
            Option bmodeOpt = OptionBuilder.create("brushmode");
            this.optsWorld.addOption(bmodeOpt);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("float");
            OptionBuilder.withDescription("Thickness of brushes created from flat faces in units.\ndefault: " + config.backfaceDepth);
            Option thicknOpt = OptionBuilder.create("thickness");
            this.optsWorld.addOption(thicknOpt);
            Option ntexfixOpt = new Option("no_texfix", "Don't fix texture names.");
            this.optsTexture.addOption(ntexfixOpt);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("string");
            OptionBuilder.withDescription("Replace all face textures with this one.");
            Option ftexOpt = OptionBuilder.create("facetex");
            this.optsTexture.addOption(ftexOpt);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("string");
            OptionBuilder.withDescription("Replace all back-face textures with this one. Used in face-based decompiling modes only.");
            Option bftexOpt = OptionBuilder.create("bfacetex");
            this.optsTexture.addOption(bftexOpt);
            Option nvmfOpt = new Option("no_vmf", "Don't write any VMF files, read BSP only.");
            this.optsOther.addOption(nvmfOpt);
            Option nlumpfilesOpt = new Option("no_lumpfiles", "Don't load lump files (.lmp) associated with the BSP file.");
            this.optsOther.addOption(nlumpfilesOpt);
            Option nprotOpt = new Option("no_prot", "Skip decompiling protection checking. Can increase speed when mass-decompiling unprotected maps.");
            this.optsOther.addOption(nprotOpt);
            Option listappidsOpt = new Option("appids", "List all available application IDs");
            this.optsOther.addOption(listappidsOpt);
            Option nvisgrpOpt = new Option("no_visgroups", "Don't group entities from instances into visgroups.");
            this.optsOther.addOption(nvisgrpOpt);
            Option ncamsOpt = new Option("no_cams", "Don't create Hammer cameras above each player spawn.");
            this.optsOther.addOption(ncamsOpt);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("string/int");
            OptionBuilder.withDescription("Overrides game detection by using this Steam Application ID instead.\nUse -appids to list all known app-IDs.");
            Option appidOpt = OptionBuilder.create("appid");
            this.optsOther.addOption(appidOpt);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("enum");
            OptionBuilder.withDescription("Sets the VMF format used for the decompiled maps:\n" + SourceFormat.AUTO.name() + " - " + (Object)((Object)SourceFormat.AUTO) + "\n" + SourceFormat.OLD.name() + "  - " + (Object)((Object)SourceFormat.OLD) + "\n" + SourceFormat.NEW.name() + "  - " + (Object)((Object)SourceFormat.NEW) + "\n" + "default: " + config.sourceFormat.name());
            Option formatOpt = OptionBuilder.create("format");
            this.optsOther.addOption(formatOpt);
            this.optsAll.addOptions(this.optsMain);
            this.optsAll.addOptions(this.optsEntity);
            this.optsAll.addOptions(this.optsWorld);
            this.optsAll.addOptions(this.optsTexture);
            this.optsAll.addOptions(this.optsOther);
            if (args.length == 0) {
                this.printHelp();
                System.exit(0);
            }
            PosixParser clParser = new PosixParser();
            cl = null;
            outputFile = null;
            recursive = false;
            files = config.getFileSet();
            try {
                cl = clParser.parse(this.optsAll, args);
                if (cl.hasOption(helpOpt.getOpt())) {
                    this.printHelp();
                }
                if (cl.hasOption(versionOpt.getOpt())) {
                    this.printVersion();
                }
                if (cl.hasOption(listappidsOpt.getOpt())) {
                    this.printAppIDs();
                }
                config.setDebug(cl.hasOption(debugOpt.getOpt()));
                if (cl.hasOption(outputOpt.getOpt())) {
                    outputFile = new File(cl.getOptionValue(outputOpt.getOpt()));
                }
                recursive = cl.hasOption(recursiveOpt.getOpt());
                if (cl.hasOption(fileListOpt.getOpt())) {
                    try {
                        List<String> filePaths = FileUtils.readLines(new File(cl.getOptionValue(fileListOpt.getOpt())));
                        for (String filePath : filePaths) {
                            BspFileEntry entry = new BspFileEntry(new File(filePath));
                            if (outputFile != null) {
                                entry.setVmfFile(new File(outputFile, entry.getVmfFile().getName()));
                            }
                            files.add(entry);
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Can't read file list", ex);
                    }
                }
                config.writePointEntities = !cl.hasOption(npentsOpt.getOpt());
                config.writeBrushEntities = !cl.hasOption(nbentsOpt.getOpt());
                config.writeStaticProps = !cl.hasOption(npropsOpt.getOpt());
                config.writeOverlays = !cl.hasOption(noverlOpt.getOpt());
                config.writeDisp = !cl.hasOption(ndispOpt.getOpt());
                config.writeAreaportals = !cl.hasOption(nareapOpt.getOpt());
                config.writeOccluders = !cl.hasOption(nocclOpt.getOpt());
                config.writeCubemaps = !cl.hasOption(ncubemOpt.getOpt());
                config.writeDetails = !cl.hasOption(ndetailsOpt.getOpt());
                config.writeLadders = !cl.hasOption(nladderOpt.getOpt());
                boolean bl = config.writeWorldBrushes = !cl.hasOption(nbrushOpt.getOpt());
                if (cl.hasOption(bmodeOpt.getOpt())) {
                    String modeStr = cl.getOptionValue(bmodeOpt.getOpt());
                    try {
                        config.brushMode = BrushMode.valueOf(modeStr);
                    }
                    catch (IllegalArgumentException ex) {
                        try {
                            int mode = Integer.valueOf(modeStr.toUpperCase());
                            config.brushMode = BrushMode.fromOrdinal(mode);
                        }
                        catch (IllegalArgumentException ex2) {
                            throw new RuntimeException("Invalid brush mode");
                        }
                    }
                }
                if (cl.hasOption(formatOpt.getOpt())) {
                    String formatStr = cl.getOptionValue(formatOpt.getOpt());
                    try {
                        config.sourceFormat = SourceFormat.valueOf(formatStr);
                    }
                    catch (IllegalArgumentException ex) {
                        try {
                            int format = Integer.valueOf(formatStr.toUpperCase());
                            config.sourceFormat = SourceFormat.fromOrdinal(format);
                        }
                        catch (IllegalArgumentException ex2) {
                            throw new RuntimeException("Invalid source format");
                        }
                    }
                }
                if (cl.hasOption(thicknOpt.getOpt())) {
                    float thickness;
                    config.backfaceDepth = thickness = Float.valueOf(cl.getOptionValue(thicknOpt.getOpt())).floatValue();
                }
                boolean bl2 = config.fixCubemapTextures = !cl.hasOption(ntexfixOpt.getOpt());
                if (cl.hasOption(ftexOpt.getOpt())) {
                    config.faceTexture = cl.getOptionValue(ftexOpt.getOpt());
                }
                if (cl.hasOption(bftexOpt.getOpt())) {
                    config.backfaceTexture = cl.getOptionValue(bftexOpt.getOpt());
                }
                config.loadLumpFiles = !cl.hasOption(nlumpfilesOpt.getOpt());
                config.skipProt = cl.hasOption(nprotOpt.getOpt());
                config.fixEntityRot = !cl.hasOption(nrotfixOpt.getOpt());
                config.nullOutput = cl.hasOption(nvmfOpt.getOpt());
                config.writeVisgroups = !cl.hasOption(nvisgrpOpt.getOpt());
                boolean bl3 = config.writeCameras = !cl.hasOption(ncamsOpt.getOpt());
                if (!cl.hasOption(appidOpt.getOpt())) break block35;
                String appidStr = cl.getOptionValue(appidOpt.getOpt()).toUpperCase();
                try {
                    int appid = Integer.valueOf(appidStr);
                    config.defaultApp = SourceAppDB.getInstance().fromID(appid);
                }
                catch (IllegalArgumentException ex2) {
                    throw new RuntimeException("Invalid default App-ID");
                }
            }
            catch (Exception ex) {
                L.log(Level.SEVERE, "Internal CLI error", ex);
                System.exit(0);
            }
        }
        String[] argsLeft = cl.getArgs();
        if (argsLeft.length == 1 && outputFile != null) {
            BspFileEntry entry = new BspFileEntry(new File(argsLeft[0]));
            entry.setVmfFile(outputFile);
            files.add(entry);
        } else {
            for (String arg : argsLeft) {
                File file = new File(arg);
                if (file.isDirectory()) {
                    Collection<File> subFiles = FileUtils.listFiles(file, new String[]{"bsp"}, recursive);
                    for (File subFile : subFiles) {
                        BspFileEntry entry = new BspFileEntry(subFile);
                        if (outputFile != null) {
                            entry.setVmfFile(new File(outputFile, entry.getVmfFile().getName()));
                        }
                        files.add(entry);
                    }
                    continue;
                }
                BspFileEntry entry = new BspFileEntry(file);
                if (outputFile != null) {
                    entry.setVmfFile(new File(outputFile, entry.getVmfFile().getName()));
                }
                files.add(entry);
            }
        }
        if (files.isEmpty()) {
            L.severe("No BSP file(s) specified");
            System.exit(1);
        }
        return config;
    }
}

