/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc;

import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class BspFileEntry {
    private final File bspFile;
    private File vmfFile;
    private File pakfileDir;

    public BspFileEntry(File bspFile) {
        if (bspFile == null) {
            throw new NullPointerException();
        }
        this.bspFile = bspFile;
        this.vmfFile = this.replaceExtension(bspFile, "_d.vmf");
        this.pakfileDir = this.replaceExtension(bspFile, "");
    }

    private File replaceExtension(File file, String newExt) {
        String base = FilenameUtils.removeExtension(file.getName());
        File parentFile = file.getAbsoluteFile().getParentFile();
        return new File(parentFile, base + newExt);
    }

    public File getBspFile() {
        return this.bspFile;
    }

    public File getVmfFile() {
        return this.vmfFile;
    }

    public void setVmfFile(File vmfFile) {
        this.vmfFile = vmfFile;
    }

    public File getPakDir() {
        return this.pakfileDir;
    }

    public void setPakDir(File pakfileDir) {
        this.pakfileDir = pakfileDir;
    }

    public String toString() {
        return this.bspFile.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BspFileEntry other = (BspFileEntry)obj;
        return this.bspFile == other.bspFile || this.bspFile.equals(other.bspFile);
    }

    public int hashCode() {
        return this.bspFile.hashCode();
    }
}

