/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.io;

import info.ata4.bsplib.util.StringMacroUtils;
import info.ata4.io.buffer.ByteBufferInputStream;
import info.ata4.io.buffer.ByteBufferOutputStream;
import info.ata4.io.lzma.LzmaDecoderProps;
import info.ata4.io.lzma.LzmaEncoderProps;
import info.ata4.log.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import lzma.LzmaDecoder;
import lzma.LzmaEncoder;

public class LzmaBuffer {
    private static final Logger L = LogUtils.getLogger();
    public static final int LZMA_ID = StringMacroUtils.makeID("LZMA");
    public static final int HEADER_SIZE = 17;

    private LzmaBuffer() {
    }

    public static ByteBuffer uncompress(ByteBuffer buffer) throws IOException {
        ByteOrder bo = buffer.order();
        ByteBuffer bbc = buffer.duplicate();
        bbc.order(ByteOrder.LITTLE_ENDIAN);
        bbc.rewind();
        if (bbc.remaining() < 17 || bbc.getInt() != LZMA_ID) {
            throw new IOException("Buffer is not compressed");
        }
        int actualSize = bbc.getInt();
        int lzmaSize = bbc.getInt();
        byte[] propsData = new byte[5];
        bbc.get(propsData);
        int lzmaSizeBuf = bbc.limit() - 17;
        if (lzmaSizeBuf != lzmaSize) {
            L.log(Level.WARNING, "Difference in LZMA data length: found {0} bytes, expected {1}", new Object[]{lzmaSizeBuf, lzmaSize});
        }
        ByteBuffer bbu = ByteBuffer.allocateDirect(actualSize);
        try (ByteBufferInputStream is = new ByteBufferInputStream(bbc);
             ByteBufferOutputStream os = new ByteBufferOutputStream(bbu);){
            LzmaDecoder decoder = new LzmaDecoder();
            LzmaDecoderProps props = new LzmaDecoderProps();
            props.setIncludeSize(false);
            props.fromArray(propsData);
            props.apply(decoder);
            if (!decoder.code(is, os, actualSize)) {
                throw new IOException("Error in LZMA stream");
            }
        }
        bbu.order(bo);
        bbu.rewind();
        return bbu;
    }

    public static ByteBuffer compress(ByteBuffer buffer) throws IOException {
        byte[] lzma;
        ByteOrder bo = buffer.order();
        ByteBuffer bbu = buffer.duplicate();
        bbu.rewind();
        LzmaEncoderProps props = new LzmaEncoderProps();
        props.setIncludeSize(false);
        try (ByteBufferInputStream is = new ByteBufferInputStream(bbu);
             ByteArrayOutputStream os = new ByteArrayOutputStream(bbu.limit() / 8);){
            LzmaEncoder encoder = new LzmaEncoder();
            props.apply(encoder);
            encoder.code(is, os);
            lzma = os.toByteArray();
        }
        int size = 17 + lzma.length;
        ByteBuffer bbc = ByteBuffer.allocateDirect(size);
        bbc.order(ByteOrder.LITTLE_ENDIAN);
        bbc.putInt(LZMA_ID);
        bbc.putInt(bbu.limit());
        bbc.putInt(lzma.length);
        bbc.put(props.toArray());
        bbc.put(lzma);
        bbc.order(bo);
        bbc.rewind();
        return bbc;
    }

    public static boolean isCompressed(ByteBuffer buffer) {
        ByteBuffer bb = buffer.duplicate();
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.rewind();
        return bb.remaining() >= 17 && bb.getInt() == LZMA_ID;
    }
}

