/*
 * Decompiled with CFR 0.152.
 */
package unmap;

import java.util.ArrayList;
import unmap.BSP;
import unmap.Brush;
import unmap.Cons;
import unmap.Face;
import unmap.Plane;
import unmap.Vec;

public class Wind {
    ArrayList<Vec> v = new ArrayList();
    static final int Maxlen = 56756;
    static final int Max_coord = 32768;
    static final int Side_front = 0;
    static final int Side_back = 1;
    static final int Side_on = 2;
    static final float Eps_split = 0.01f;
    static final float Eps_comp = 0.5f;
    static final float Eps_degen = 0.1f;

    public int size() {
        return this.v.size();
    }

    public void createplane(Plane pl) {
        float dmax = -1.0f;
        int idir = -1;
        Vec norm = new Vec(pl.nx, pl.ny, pl.nz);
        for (int i = 0; i < 3; ++i) {
            float dc = Math.abs(norm.comp(i));
            if (!(dc > dmax)) continue;
            dmax = dc;
            idir = i;
        }
        if (idir == -1) {
            Cons.println("createplane: bad plane normal");
            return;
        }
        Vec vup = new Vec(0.0f, 0.0f, 0.0f);
        switch (idir) {
            case 0: 
            case 1: {
                vup.z = 1.0f;
                break;
            }
            case 2: {
                vup.x = 1.0f;
            }
        }
        float vdot = vup.dot(norm);
        vup = vup.addmult(-vdot, norm);
        vup = vup.norm();
        Vec org = norm.scalar(pl.dist);
        Vec vrt = vup.cross(norm);
        vup = vup.scalar(56756.0f);
        vrt = vrt.scalar(56756.0f);
        this.v.add(org.subtract(vrt).add(vup));
        this.v.add(org.add(vrt).add(vup));
        this.v.add(org.add(vrt).subtract(vup));
        this.v.add(org.subtract(vrt).subtract(vup));
    }

    public Wind clipplane(Plane pl) {
        int i;
        Vec norm = new Vec(pl.nx, pl.ny, pl.nz);
        int[] counts = new int[3];
        Wind w = new Wind();
        float[] dists = new float[this.size() + 1];
        int[] sides = new int[this.size() + 1];
        counts[2] = 0;
        counts[1] = 0;
        counts[0] = 0;
        for (i = 0; i < this.size(); ++i) {
            float dot = this.v.get(i).dot(norm);
            dists[i] = dot -= pl.dist;
            sides[i] = dot > 0.01f ? 0 : (dot < -0.01f ? 1 : 2);
            int n = sides[i];
            counts[n] = counts[n] + 1;
        }
        sides[this.size()] = sides[0];
        dists[this.size()] = dists[0];
        if (counts[0] == 0 && counts[1] == 0) {
            return this;
        }
        if (counts[0] == 0) {
            return w;
        }
        if (counts[1] == 0) {
            return this;
        }
        for (i = 0; i < this.size(); ++i) {
            int pi2;
            Vec p2;
            Vec p1 = this.v.get(i);
            int mi = w.size();
            Vec mv = new Vec(0.0f, 0.0f, 0.0f);
            if (sides[i] == 0 || sides[i] == 2) {
                mv = p1.copy();
                w.vset(mi, mv);
                if (sides[i] == 2) continue;
                mi = w.size();
                mv = new Vec(0.0f, 0.0f, 0.0f);
            }
            if (sides[i + 1] == 2 || sides[i + 1] == sides[i]) continue;
            if (i == this.size() - 1) {
                p2 = this.v.get(0);
                pi2 = 0;
            } else {
                p2 = this.v.get(i + 1);
                pi2 = i + 1;
            }
            float dot = dists[i] / (dists[i] - dists[i + 1]);
            for (int j = 0; j < 3; ++j) {
                if (norm.comp(j) == 1.0f) {
                    mv.setcomp(j, pl.dist);
                    continue;
                }
                if (norm.comp(j) == -1.0f) {
                    mv.setcomp(j, -pl.dist);
                    continue;
                }
                mv.setcomp(j, p1.comp(j) + dot * (p2.comp(j) - p1.comp(j)));
            }
            w.vset(mi, mv);
        }
        return w;
    }

    public void vset(int index, Vec vertex) {
        int size = this.v.size();
        if (size == index) {
            this.v.add(vertex);
        } else if (size > index) {
            this.v.set(index, vertex);
        } else {
            Cons.println("Vset: index " + index + " > size " + size);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.size() + " : ");
        for (int i = 0; i < this.size(); ++i) {
            s.append(" (" + this.v.get((int)i).x + ", " + this.v.get((int)i).y + ", " + this.v.get((int)i).z + ") ");
        }
        return s.toString();
    }

    public boolean matches(Wind that) {
        if (this.size() != that.size()) {
            return false;
        }
        float min = 1000000.0f;
        for (int i = 0; i < this.size(); ++i) {
            float mdist = this.matchdist(that, i);
            if (!(mdist < min)) continue;
            min = mdist;
        }
        return min < 0.5f;
    }

    public float matchdist(Wind that, int offset) {
        float dist = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            int j = (i + offset) % this.size();
            dist += this.v.get(i).subtract(that.v.get(j)).modulus();
        }
        return dist;
    }

    public float vmatches(Wind that) {
        float min = 1000000.0f;
        if (this.size() != that.size()) {
            return min;
        }
        for (int i = 0; i < this.size(); ++i) {
            float mdist = this.matchdist(that, i);
            if (!(mdist < min)) continue;
            min = mdist;
        }
        return min;
    }

    public static Wind windfromface(BSP m, Face f) {
        Wind w = new Wind();
        for (int i = 0; i < f.numedge; ++i) {
            int sedge = m.sedge[f.fstedge + i];
            int v = 0;
            v = sedge < 0 ? m.vi2[-sedge] : m.vi1[sedge];
            w.v.add(new Vec(m.x[v], m.y[v], m.z[v]));
        }
        return w;
    }

    public static Wind windfromside(BSP m, Brush brush, int side) {
        Wind bw = new Wind();
        int bside = brush.fstside + side;
        int plane = m.bsd[bside].pnum;
        bw.createplane(m.pl[plane]);
        for (int i = 0; i < brush.numside; ++i) {
            if (i == side) continue;
            int ibside = brush.fstside + i;
            int iplane = m.bsd[ibside].pnum;
            if (m.bsd[ibside].bevel == 1) continue;
            bw = bw.clipplane(m.pl[iplane].flip());
        }
        return bw;
    }

    public boolean isnull() {
        return this.size() == 0;
    }

    public boolean ishuge() {
        for (Vec point : this.v) {
            for (int j = 0; j < 3; ++j) {
                if (!(Math.abs(point.comp(j)) > 32768.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public void removedegenerate() {
        if (this.isnull()) {
            return;
        }
        Wind result = new Wind();
        for (int i = 0; i < this.size(); ++i) {
            Vec v1;
            int j = (i + 1) % this.size();
            Vec v0 = this.v.get(i);
            if (!(v0.subtract(v1 = this.v.get(j)).modulus() > 0.1f)) continue;
            result.v.add(v0);
        }
        if (this.size() != result.size()) {
            this.v = result.v;
        }
    }
}

