/*
 * Decompiled with CFR 0.152.
 */
package pak;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mdl {
    boolean isValid = false;
    int id;
    int version;
    int checksum;
    String name;
    int length;
    int numtextures;
    int textureindex;
    int numtexpaths;
    int texpathindex;
    String[] textures;
    String[] texpaths;
    int numincmodels;
    int incmodelindex;
    String[] incmodelfile;

    public void load(String filename) throws IOException {
        File infile = new File(filename);
        if (!infile.exists() || !infile.canRead()) {
            System.out.println("Can't open " + filename);
            return;
        }
        System.out.println("Reading " + filename);
        FileChannel rafch = new RandomAccessFile(infile, "r").getChannel();
        MappedByteBuffer mbuffer = rafch.map(FileChannel.MapMode.READ_ONLY, 0L, rafch.size());
        ByteBuffer b = mbuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.read(b);
        rafch.close();
    }

    public void read(ByteBuffer b) throws IOException {
        int i;
        this.isValid = false;
        int start = b.position();
        this.id = b.getInt();
        this.version = b.getInt();
        if (this.id != 1414743113 || this.version != 44) {
            return;
        }
        this.checksum = b.getInt();
        this.name = this.readstr(b);
        b.position(start + 76);
        this.length = b.getInt();
        b.position(start + 204);
        this.numtextures = b.getInt();
        this.textureindex = b.getInt();
        this.numtexpaths = b.getInt();
        this.texpathindex = b.getInt();
        this.texpaths = new String[this.numtexpaths];
        this.textures = new String[this.numtextures];
        b.position(start + 336);
        this.numincmodels = b.getInt();
        this.incmodelindex = b.getInt();
        this.incmodelfile = new String[this.numincmodels];
        for (i = 0; i < this.numtexpaths; ++i) {
            b.position(start + this.texpathindex + i * 4);
            int pindex = b.getInt();
            b.position(start + pindex);
            this.texpaths[i] = this.readstr(b);
        }
        for (i = 0; i < this.numtextures; ++i) {
            b.position(start + this.textureindex + 64 * i);
            int tindex = b.getInt();
            b.position(start + this.textureindex + 64 * i + tindex);
            this.textures[i] = this.readstr(b);
        }
        for (i = 0; i < this.numincmodels; ++i) {
            b.position(start + this.incmodelindex + 8 * i + 4);
            int imfindex = b.getInt();
            b.position(start + this.incmodelindex + 8 * i + imfindex);
            this.incmodelfile[i] = this.readstr(b);
        }
        this.isValid = true;
    }

    public ArrayList<String> gettexturelist() {
        ArrayList<String> texlist = new ArrayList<String>();
        if (!this.isValid) {
            return texlist;
        }
        for (int i = 0; i < this.numtexpaths; ++i) {
            for (int j = 0; j < this.numtextures; ++j) {
                String tex = this.texpaths[i] + this.textures[j];
                texlist.add(tex);
            }
        }
        return texlist;
    }

    public String readstr(ByteBuffer b) {
        char c;
        StringBuffer linebuff = new StringBuffer();
        while ((c = (char)b.get()) != '\u0000') {
            linebuff.append(c);
        }
        return linebuff.toString();
    }

    public String toString() {
        if (!this.isValid) {
            return null;
        }
        return this.name + " " + Integer.toHexString(this.checksum);
    }
}

