//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//
//	GameScheme.res
//	LuminousForts
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

Scheme
{

    Colors
	{
		//
		// Valve declarations
		//
		"White"				"255 255 255 255"
		"OffWhite"			"216 216 216 255"
		"DullWhite"			"142 142 142 255"
		"Orange"			"255 155 0 255"
		"TransparentBlack"	"0 0 0 128"
		"Black"				"0 0 0 255"

		"Blank"				"0 0 0 0"
		
		"SteamLightGreen"	"157 194 80 255"
		"AchievementsLightGrey"		"79 79 79 255"
		"AchievementsDarkGrey"		"55 55 55 255"
		"AchievementsInactiveFG"	"130 130 130 255"
		
		//
		//	Color Definitions
		//
		
		"LumBlue.Lite"		"184 233 244 255"
		"LumBlue.Med"		"26 179 212 255"
		"LumBlue.Dark"		"46 109 123 255"
		
		"LumGreen.Lite"		"0 224 21 255"
		"LumGreen.Med"		"118 179 124 255"
		"LumGreen.Dark"		"58 112 63 255"
		
		"LumRed.Lite"		"176 0 0 255"
		"LumRed.Med"		"112 58 58 255"
		"LumRed.Dark"		"90 70 70 255"
		
		"LumTeal.Lite"		"146 172 160 220"
		"LumTeal.Med"		"12 118 67 220"
		"LumTeal.Dark"		"20 70 46 220"
		
		"LumYellow.Lite"	"234 232 171 220"
		"LumYellow.Med"		"179 174 26 220"
		"LumYellow.Dark"	"112 109 29 220"
		
		"LumGreenS.Lite"	"24 177 96 220"
		"LumGreenS.Med"		"32 116 72 220"
		"LumGreenS.Dark"	"26 94 29 220"
		
		"Lum.GreyGreen"		"77 95 77 220"
		"Lum.GreyBlue"		"77 95 94 220"
		
		"Lum.BlackenedGreen""44 71 40 220"
		"Lum.BlackenedBlue"	"40 71 70 220"
		
		// In game background color
		"Lum.HUD.BgColor"	"0 0 0 220"
		
		"Lum.Game.Background"	"0 0 0 250"
		
		//
		//	Widget Color Definitions
		//
        "Grey.Lite"     "191 191 191 220"
        "Grey.Med"      "191 191 191 220"
        "Grey.Dark"     "191 191 191 220"
        
        "LText.Lite"    "191 191 191 220"
        "LText.Med"     "191 191 191 220"
        "LText.Inte"    "191 191 191 220"
        		
		"Fg.Panel"	"191 191 191 220"
		"Bg.Panel"	"0 0 0 252"
		"Bg.Panel.OutFocus"	"0 0 0 252"
		
		"Fg.Widget"	"191 191 191 255"
		"Bg.Widget" "0 0 0 255"
		
		//
		//	Font Color Definitions	
		//
		
		"Fon.Bold"		"228 128 64 255"
		"Fon.Button"	"192 192 192 255"
		
		//
		//	Title Screen MP3 Player
		//
		
		"MP3FG"			"255 255 255 255"
		"MP3BG"			"0 0 0 255"
		"MP3Border"		"0 255 0 255"
	}
	
	BaseSettings
	{
		// In game border
        "LumTeam.Red"        "128 32 16 144"
        "Lum.GameBorder"    "LumTeam.Red"

        // vgui_controls color specifications
        Border.Bright                    "LumTeam.Red"        // the lit side of a control
        Border.Dark                        "LumTeam.Red"        // the dark/unlit side of a control
        Border.Selection                "0 192 128 196"        // the additional border color for displaying the default/selected button

        Button.TextColor                "White"
        Button.BgColor                    "Blank"
        Button.ArmedTextColor            "White"
        Button.ArmedBgColor                "Blank"                [$WIN32]
        Button.DepressedTextColor        "White"
        Button.DepressedBgColor            "Blank"
        Button.FocusBorderColor            "Black"

        CheckButton.TextColor                "White"
        CheckButton.SelectedTextColor        "White"
        CheckButton.BgColor                    "TransparentBlack"
        CheckButton.Border1                  "Border.Dark"         // the left checkbutton border
        CheckButton.Border2                  "Border.Bright"        // the right checkbutton border
        CheckButton.Check                    "White"    // color of the check itself
        CheckButton.HighlightFgColor        "OffWhite"
        CheckButton.ArmedBgColor            "Blank"
        CheckButton.DepressedBgColor        "Blank"
        CheckButton.DisabledBgColor               "TransparentBlack"

        ComboBoxButton.ArrowColor        "DullWhite"
        ComboBoxButton.ArmedArrowColor    "White"
        ComboBoxButton.BgColor            "Blank"
        ComboBoxButton.DisabledBgColor    "Blank"

        Frame.TitleTextInsetX            16
        Frame.ClientInsetX                8
        Frame.ClientInsetY                6
        Frame.BgColor                    "Bg.Panel"    [$WIN32]
        Frame.OutOfFocusBgColor            "Bg.Panel.OutFocus"    [$WIN32]
        Frame.FocusTransitionEffectTime    "0.3"    // time it takes for a window to fade in/out on focus/out of focus
        Frame.TransitionEffectTime        "0.3"    [$WIN32]    // time it takes for a window to fade in/out on open/close
        Frame.AutoSnapRange                "0"
        FrameGrip.Color1                "200 200 200 196"
        FrameGrip.Color2                "0 0 0 196"
        FrameTitleButton.FgColor        "200 200 200 196"
        FrameTitleButton.BgColor        "Blank"
        FrameTitleButton.DisabledFgColor    "255 255 255 192"
        FrameTitleButton.DisabledBgColor    "Blank"
        FrameSystemButton.FgColor        "Blank"
        FrameSystemButton.BgColor        "Blank"
        FrameSystemButton.Icon            ""
        FrameSystemButton.DisabledIcon    ""
        FrameTitleBar.Font                "UiBold"        [$WIN32]
        FrameTitleBar.Font                "DefaultLarge"    [$WIN32]
        FrameTitleBar.TextColor            "255 255 255 192"
        FrameTitleBar.BgColor            "Blank"
        FrameTitleBar.DisabledTextColor    "255 255 255 192"
        FrameTitleBar.DisabledBgColor    "Blank"

        GraphPanel.FgColor                "White"
        GraphPanel.BgColor                "Bg.Panel"

        Label.TextDullColor                "DullWhite"
        Label.TextColor                    "OffWhite"
        Label.TextBrightColor            "White"
        Label.SelectedTextColor            "White"
        Label.BgColor                    "Blank"
        Label.DisabledFgColor1            "117 117 117 255"
        Label.DisabledFgColor2            "30 30 30 255"

        ListPanel.TextColor                    "Fg.Panel"
        ListPanel.TextBgColor                "Blank"
        ListPanel.BgColor                    "Bg.Panel"
        ListPanel.SelectedTextColor            "Bg.Panel"
        ListPanel.SelectedBgColor            "Fg.Panel"
        ListPanel.SelectedOutOfFocusBgColor    "255 155 0 128"
        ListPanel.EmptyListInfoTextColor    "OffWhite"

        Menu.TextColor                    "White"
        Menu.BgColor                    "Bg.Panel"
        Menu.ArmedTextColor                "LumTeam.Red"
        Menu.ArmedBgColor                "Fg.Panel"
        Menu.TextInset                    "6"

        Panel.FgColor                    "Fg.Panel"
        Panel.BgColor                    "Bg.Panel"

        ProgressBar.FgColor                "LumTeam.Red"
        ProgressBar.BgColor                "Bg.Panel"

        PropertySheet.TextColor            "OffWhite"
        PropertySheet.SelectedTextColor    "White"
        PropertySheet.TransitionEffectTime    "0.25"    // time to change from one tab to another

        RadioButton.TextColor            "Fg.Panel"
        RadioButton.SelectedTextColor    "Bg.Panel"

        RichText.TextColor                "Fg.Panel"
        RichText.BgColor                "Bg.Panel"
        RichText.SelectedTextColor        "Black"
        RichText.SelectedBgColor        "LumRed.Lite"

        ScrollBar.Wide                    17

        ScrollBarButton.FgColor                "Grey.Lite"
        ScrollBarButton.BgColor                "Bg.Panel"
        ScrollBarButton.ArmedFgColor        "Grey.Dark"
        ScrollBarButton.ArmedBgColor        "Bg.Panel"
        ScrollBarButton.DepressedFgColor    "Black"
        ScrollBarButton.DepressedBgColor    "Blank"

        ScrollBarSlider.FgColor                "Bg.Panel"    // nob color
        ScrollBarSlider.BgColor                "Bg.Panel"        // slider background color

        SectionedListPanel.HeaderTextColor    "White"
        SectionedListPanel.HeaderBgColor    "Blank"
        SectionedListPanel.DividerColor        "Black"
        SectionedListPanel.TextColor        "Fg.Panel"
        SectionedListPanel.BrightTextColor    "White"
        SectionedListPanel.BgColor            "Bg.Panel"
        SectionedListPanel.SelectedTextColor            "Bg.Panel"
        SectionedListPanel.SelectedBgColor                "Fg.Panel"
        SectionedListPanel.OutOfFocusSelectedTextColor    "Black"
        SectionedListPanel.OutOfFocusSelectedBgColor    "255 155 0 128"

        Slider.NobColor                "108 108 108 255"
        Slider.TextColor            "180 180 180 255"
        Slider.TrackColor            "31 31 31 255"
        Slider.DisabledTextColor1    "117 117 117 255"
        Slider.DisabledTextColor2    "30 30 30 255"

        TextEntry.TextColor            "OffWhite"
        TextEntry.BgColor            "TransparentBlack"
        TextEntry.CursorColor        "OffWhite"
        TextEntry.DisabledTextColor    "DullWhite"
        TextEntry.DisabledBgColor    "Blank"
        TextEntry.SelectedTextColor    "Black"
        TextEntry.SelectedBgColor    "Orange"
        TextEntry.OutOfFocusSelectedBgColor    "255 155 0 128"
        TextEntry.FocusEdgeColor    "0 0 0 196"

        ToggleButton.SelectedTextColor    "White"

        Tooltip.TextColor            "0 0 0 196"
        Tooltip.BgColor                "0 128 225 255"

        TreeView.BgColor            "TransparentBlack"

        WizardSubPanel.BgColor        "Blank"

        // scheme-specific colors
        MainMenu.TextColor            "255 255 255 255"                [$WIN32]
        MainMenu.ArmedTextColor        "32 128 225 255"    [$WIN32]
        MainMenu.DepressedTextColor    "0 0 0 255"
        MainMenu.MenuItemHeight        "30"                [$WIN32]
        MainMenu.Inset                "16"
        MainMenu.Backdrop            "0 0 0 156"

        Console.TextColor            "OffWhite"
        Console.DevTextColor        "White"

        "QuickListBGDeselected"        "AchievementsDarkGrey"
         "QuickListBGSelected"        "AchievementsLightGrey"
	}

    Fonts
	{	
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		// fonts are used in order that they are listed
		"DebugFixed"
		{
			"1"
			{
				"name"		"Courier New"
				"tall"		"10"
				"weight"	"500"
				"antialias" "1"
			}
		}
		// fonts are used in order that they are listed
		"DebugFixedSmall"
		{
			"1"
			{
				"name"		"Courier New"
				"tall"		"7"
				"weight"	"500"
				"antialias" "1"
			}
		}
		"DefaultFixedOutline"
		{
			"1"
			{
				"name"		 "Lucida Console"
				"tall"		 "10"
				"tall_lodef" "15"
				"tall_hidef" "20"
				"weight"	 "0"
				"outline"	 "1"
			}
		}
		"Default"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"500"
			}
		}
		"DefaultBold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"1000"
			}
		}
		"DefaultUnderline"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"500"
				"underline" "1"
			}
		}
		"DefaultSmall"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"0"
			}
		}
		"DefaultSmallDropShadow"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"13"
				"weight"	"0"
				"dropshadow" "1"
			}
		}
		"DefaultVerySmall"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"0"
			}
		}

		"DefaultLarge"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"18"
				"weight"	"0"
			}
		}
		"UiBold"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"13"
				"weight"	"500"
			}
		}
		"MenuLarge"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"16"
				"weight"	"600"
				"antialias" "1"
			}
		}
		"AchievementTitleFont"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"20"
				"weight"	"1200"
				"antialias" "1"
				"outline" "1"
			}
		}
		"AchievementDescriptionFont"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"15"
				"weight"	"1200"
				"antialias" "1"
				"outline" "1"
				"yres"		"0 480"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"20"
				"weight"	"1200"
				"antialias" "1"
				"outline" "1"
				"yres"	 "481 10000"
			}
		}
		
		GameUIButtons
		{
			"1"	[$X360]
			{
				"bitmap"	"1"
				"name"		"Buttons"
				"scalex"	"0.63"
				"scaley"	"0.63"
				"scalex_hidef"	"1.0"
				"scaley_hidef"	"1.0"
				"scalex_lodef"	"0.75"
				"scaley_lodef"	"0.75"
			}
		}
		"ConsoleText"
		{
			"1"
			{
				"name"		"Lucida Console"
				"tall"		"10"
				"weight"	"500"
			}
		}

		// this is the symbol font
		"Marlett"
		{
			"1"
			{
				"name"		"Marlett"
				"tall"		"14"
				"weight"	"0"
				"symbol"	"1"
			}
		}

		"Trebuchet24"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"24"
				"weight"	"900"
			}
		}

		"Trebuchet20"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"20"
				"weight"	"900"
			}
		}

		"Trebuchet18"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"18"
				"weight"	"900"
			}
		}

		// HUD numbers
		// We use multiple fonts to 'pulse' them in the HUD, hence the need for many of near size
		"HUDNumber"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"40"
				"weight"	"900"
			}
		}
		"HUDNumber1"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"41"
				"weight"	"900"
			}
		}
		"HUDNumber2"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"42"
				"weight"	"900"
			}
		}
		"HUDNumber3"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"43"
				"weight"	"900"
			}
		}
		"HUDNumber4"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"44"
				"weight"	"900"
			}
		}
		"HUDNumber5"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"45"
				"weight"	"900"
			}
		}
		"DefaultFixed"
		{
			"1"
			{
				"name"		"Lucida Console"
				"tall"		"10"
				"weight"	"0"
			}
		}

		"DefaultFixedDropShadow"
		{
			"1"
			{
				"name"		"Lucida Console"
				"tall"		"10"
				"weight"	"0"
				"dropshadow" "1"
			}
		}

		"CloseCaption_Normal"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"500"
			}
		}
		"CloseCaption_Italic"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"500"
				"italic"	"1"
			}
		}
		"CloseCaption_Bold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"900"
			}
		}
		"CloseCaption_BoldItalic"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"900"
				"italic"	"1"
			}
		}

		TitleFont
		{
			"1"
			{
				"name"		"HalfLife2"
				"tall"		"72"
				"weight"	"400"
				"antialias"	"1"
				"custom"	"1"
			}
		}

		TitleFont2
		{
			"1"
			{
				"name"		"HalfLife2"
				"tall"		"120"
				"weight"	"400"
				"antialias"	"1"
				"custom"	"1"
			}
		}

		AchievementItemTitle
		{
			"1"
			{
				"name"			"Arial"
				"weight"		"1500"
				"tall"			"16"
				"antialias"		"1"
			}
		}
		
		AchievementItemDescription
		{
			"1"
			{
				"name"			"Arial"
				"weight"		"1000"
				"tall"			"14"
				"antialias"		"1"
			}
		}

		
		"ServerBrowserTitle"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"35"
				"tall_lodef"	"40"
				"weight"	"500"
				"additive"	"0"
				"antialias" "1"
			}
		}

		"ServerBrowserSmall"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Tahoma"
				"tall"		"19"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Tahoma"
				"tall"		"19"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1200 6000"
				"antialias"	"1"
			}
		}
	
		"MainMenuFont"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"18"
				"weight"	"500"
				"additive"	"0"
				"antialias" "1"
			}
		}
		"MenuLarge"
		{
			"1"	[$X360]
			{
				"tall_hidef"		"24"
			}
		}
		"MenuTitleVeryLarge"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"32"
				"weight"	"400"
			}
		}
		"MenuTitle"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"500"
			}
		}

		"MenuTitle2"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"18"
				"weight"	"500"
			}
		}

		"MenuTitle3"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"14"
				"weight"	"500"
			}
		}

		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		Default
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"12"
				"weight"	"700"
				"antialias" "1"
				"yres"	"1 599"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"13"
				"weight"	"700"
				"antialias" "1"
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"15"
				"weight"	"900"
				"antialias" "1"
				"yres"	"768 1023"
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"18"
				"weight"	"900"
				"antialias" "1"
				"yres"	"1024 1199"
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"900"
				"antialias" "1"
				"yres"	"1200 10000"
				"additive"	"1"
			}
		}
		"DefaultSmall"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"10"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"12"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"13"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"16"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"18"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"1200 6000"
				"antialias"	"1"
			}
		}
		"DefaultVerySmall"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"9"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"10"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"12"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"18"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1200 6000"
				"antialias"	"1"
			}
		}
		"ClassMenuDefault"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"9"
				"weight"	"700"
				"antialias" "1"
				"yres"	"1 599"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"12"
				"weight"	"700"
				"antialias" "1"
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"14"
				"weight"	"900"
				"antialias" "1"
				"yres"	"768 1023"
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"900"
				"antialias" "1"
				"yres"	"1024 1199"
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"24"
				"weight"	"900"
				"antialias" "1"
				"yres"	"1200 10000"
				"additive"	"1"
			}
		}
		"ClassMenuDefaultSmall"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"12"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"13"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"14"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"24"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"1200 6000"
				"antialias"	"1"
			}
			"6"
			{
				"name"		"Arial"
				"tall"		"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"0"
			}
		}
		"ClassMenuDefaultVerySmall"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"12"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"13"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"14"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"24"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1200 6000"
				"antialias"	"1"
			}
			"6"
			{
				"name"		"Arial"
				"tall"		"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"0"
			}
			"7"
			{
				"name"		"Arial"
				"tall"		"11"
				"range" 		"0x0000 0x00FF"
				"weight"		"0"
			}
		}
		"ClassMenuBodyFont"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"9"
				"weight"	"700"
				"antialias" "1"
				"yres"	"1 599"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"12"
				"weight"	"700"
				"antialias" "1"
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"14"
				"weight"	"900"
				"antialias" "1"
				"yres"	"768 1023"
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"900"
				"antialias" "1"
				"yres"	"1024 1199"
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"24"
				"weight"	"900"
				"antialias" "1"
				"yres"	"1200 10000"
				"additive"	"1"
			}
		}

		// LF Fonts
		"LFTitle"
		{
			"1"
			{
				"name" "Impact"
				"tall"		"64"
				"weight"	"200"
				"antialias" "1"				
			}
		}
		
		"LFTitleSub"
		{
			"1"
			{
				"name" "Impact"
				"tall"		"32"
				"weight"	"300"
				"antialias" "1"				
			}
		}
		
		"LFMenuItem"
		{
			"1"
			{
				"name" "Impact"
				"tall"		"12"
				"weight"	"500"
				"antialias" "1"	
			}
		}
		
		"LF_icon"
		{
			"1"
			{
				"name" 	"luminousforts_icon"
				"tall"		"16"
				"weight" 	"500"
				"antialias" "1"
			}
		}
		
		"LFSpectatorList"
		{
			"1"
			{
				"name"	"Impact"
				"tall"		"14"
				"weight" "500"
				"antialias" "1"
			}
		}
	}

    Borders
	{
		BaseBorder		DepressedBorder
		ButtonBorder	RaisedBorder
		ComboBoxBorder	DepressedBorder
		MenuBorder		RaisedBorder
		BrowserBorder	DepressedBorder
		PropertySheetBorder	RaisedBorder

		FrameBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}

		DepressedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}
		RaisedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}
		
		TitleButtonBorder
		{
			"backgroundtype" "2"
		}

		TitleButtonDisabledBorder
		{
			"backgroundtype" "2"
		}

		TitleButtonDepressedBorder
		{
			"backgroundtype" "2"
		}

		ScrollBarButtonBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}
		
		ScrollBarButtonDepressedBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}

		TabBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

		}

		TabActiveBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

		}


		ToolTipBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		// this is the border used for default buttons (the button that gets pressed when you hit enter)
		ButtonKeyFocusBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Selection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}
			Top
			{
				"1"
				{
					"color" "Border.Selection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}
			Right
			{
				"1"
				{
					"color" "Border.Selection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}
			Bottom
			{
				"1"
				{
					"color" "Border.Selection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		ButtonDepressedBorder
		{
			"inset" "2 1 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}
	}
	
	//////////////////////// BITMAP FONT FILES /////////////////////////////
	//
	// Bitmap Fonts are ****VERY*** expensive static memory resources so they are purposely sparse
	BitmapFontFiles
	{
		// UI buttons, custom font, (256x64)
		"Buttons"		"materials/vgui/fonts/buttons_32.vbf"
	}

	CustomFontFiles
	{
		"1"		"resource/halflife2.ttf"
		"2"		"resource/HL2EP2.ttf"
		"3"		"resource/luminousfortsicon.ttf"
		"4"		"resource/marlett.ttf"
	}

}
